/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc.dom;

import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.enc.ToBeEncryptedXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMToBeEncryptedXML
implements ToBeEncryptedXML {
    private String type;
    private String mimeType;
    private String encoding;
    private NodeList nodeList;
    private CanonicalizationMethod canonMethod;

    public DOMToBeEncryptedXML(Element element, CanonicalizationMethod canonMethod) {
        if (element == null) {
            throw new NullPointerException("element is null");
        }
        this.init(new NodeListImpl(element), "http://www.w3.org/2001/04/xmlenc#Element", null, null, canonMethod);
    }

    public DOMToBeEncryptedXML(NodeList content, CanonicalizationMethod canonMethod) {
        if (content == null) {
            throw new NullPointerException("content is null");
        }
        this.init(content, "http://www.w3.org/2001/04/xmlenc#Content", null, null, canonMethod);
    }

    private void init(NodeList nodeList, String type, String mimeType, String encoding, CanonicalizationMethod canonMethod) {
        this.nodeList = nodeList;
        this.type = type;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.canonMethod = canonMethod;
    }

    public NodeList getNodeList() {
        return this.nodeList;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonMethod;
    }

    static class NodeListImpl
    implements NodeList {
        private Element elmt;

        NodeListImpl(Element element) {
            this.elmt = element;
        }

        @Override
        public Node item(int index) {
            return index == 0 ? this.elmt : null;
        }

        @Override
        public int getLength() {
            return 1;
        }
    }
}

