/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.util.Debug$KeymanFormatter;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    private static final String LOGGER_NAME = "ikeyman";
    private static final String DEBUG_FILE_NAME = "debugTrace.log";
    private static final int DEBUG_LIMIT = 0x100000;
    private static final int DEBUG_COUNT = 5;
    private static Logger logger = Logger.getLogger("ikeyman");
    private static int stackTraceDepth = -1;
    private static String CURRENT_DIR = "";

    public static void init() {
        if (logger.getLevel() != null && !logger.getLevel().equals(Level.OFF)) {
            return;
        }
        boolean bl = false;
        try {
            bl = System.getProperty("keyman.debug") == null ? false : Boolean.parseBoolean(System.getProperty("keyman.debug"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl2 = false;
        try {
            bl2 = System.getProperty("keyman.logging") == null ? false : Boolean.parseBoolean(System.getProperty("keyman.logging"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (KeymanSettings$Setting.LoggingModeEnabled.getBoolean().booleanValue() || KeymanSettings$Setting.DebugModeEnabled.getBoolean().booleanValue() || bl || bl2) {
            FileHandler fileHandler;
            try {
                fileHandler = new FileHandler(DEBUG_FILE_NAME, 0x100000, 5);
                fileHandler.setFormatter(new Debug$KeymanFormatter(null));
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            logger.addHandler(fileHandler);
            logger.setLevel(Level.ALL);
            logger.setUseParentHandlers(false);
        } else {
            logger.setLevel(Level.OFF);
        }
        CURRENT_DIR = new File(".").getAbsolutePath();
    }

    public static String getCurrentDir() {
        return CURRENT_DIR;
    }

    private static String getMethodName(StackTraceElement stackTraceElement) {
        return stackTraceElement.getMethodName() + " (line " + stackTraceElement.getLineNumber() + ")";
    }

    private static StackTraceElement getStackTraceElement(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceDepth < 0) {
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                if (!stackTraceElement.getClassName().equals("com.ibm.gsk.ikeyman.util.Debug")) continue;
                stackTraceDepth = i + 1;
                break;
            }
        }
        return stackTraceElementArray[stackTraceDepth];
    }

    public static String getDebugFileName() {
        return DEBUG_FILE_NAME;
    }

    public static void entering() {
        StackTraceElement stackTraceElement = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.entering(stackTraceElement.getClassName(), Debug.getMethodName(stackTraceElement));
    }

    public static void entering(Object[] objectArray) {
        StackTraceElement stackTraceElement = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.entering(stackTraceElement.getClassName(), Debug.getMethodName(stackTraceElement), objectArray);
    }

    public static void exiting() {
        StackTraceElement stackTraceElement = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.exiting(stackTraceElement.getClassName(), Debug.getMethodName(stackTraceElement));
    }

    public static void exiting(Object object) {
        StackTraceElement stackTraceElement = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.exiting(stackTraceElement.getClassName(), Debug.getMethodName(stackTraceElement), object);
    }

    public static void throwing(Throwable throwable) {
        StackTraceElement stackTraceElement = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.throwing(stackTraceElement.getClassName(), Debug.getMethodName(stackTraceElement), throwable);
    }

    public static void log(String string, Object[] objectArray) {
        StackTraceElement stackTraceElement = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.logp(Level.INFO, stackTraceElement.getClassName(), Debug.getMethodName(stackTraceElement), string, objectArray);
    }

    public static void finest(String string, Object[] objectArray) {
        StackTraceElement stackTraceElement = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.logp(Level.FINEST, stackTraceElement.getClassName(), Debug.getMethodName(stackTraceElement), string, objectArray);
    }

    static {
        Debug.init();
    }
}

