/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.entry.ByteArray;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$AlgorithmItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree$KeymanTreeNode;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

class DisplayItemFactory$AlgorithmItemImpl
implements DisplayItemFactory$AlgorithmItem {
    private String oid;
    private ByteArray parameters;

    public DisplayItemFactory$AlgorithmItemImpl(AlgorithmId algorithmId) throws KeyManagerException {
        this.initialiseClass(algorithmId);
    }

    public DisplayItemFactory$AlgorithmItemImpl(String string, byte[] byArray) {
        this.oid = string;
        this.parameters = new ByteArray(byArray);
    }

    public DisplayItemFactory$AlgorithmItemImpl(Key key) throws KeyManagerException {
        AlgorithmId algorithmId = null;
        try {
            algorithmId = AlgorithmId.get((String)key.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{key.getAlgorithm()});
        }
        this.initialiseClass(algorithmId);
    }

    public DisplayItemFactory$AlgorithmItemImpl(Key key, int n) throws KeyManagerException {
        AlgorithmId algorithmId = null;
        try {
            algorithmId = AlgorithmId.get((String)key.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                algorithmId = AlgorithmId.get((String)(key.getAlgorithm() + n));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException2, new String[]{key.getAlgorithm()});
            }
        }
        this.initialiseClass(algorithmId);
    }

    public String getOID() {
        return this.oid;
    }

    private void initialiseClass(AlgorithmId algorithmId) throws KeyManagerException {
        this.oid = algorithmId.getOID().toString();
        try {
            this.parameters = new ByteArray(algorithmId.getParameters());
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALGORITHM_PARAMETERS, (Throwable)iOException);
        }
    }

    public String toString() {
        String string = null;
        try {
            string = AlgorithmId.get((String)this.oid).getName();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string = this.oid;
        }
        if (string.equals(this.oid)) {
            return this.oid;
        }
        return string + " (" + this.oid + ")";
    }

    public List getTreeNodes() {
        ArrayList<KeymanTree$KeymanTreeNode> arrayList = new ArrayList<KeymanTree$KeymanTreeNode>();
        arrayList.add(KeymanTree.newNode(Messages.getString("Label.Algorithm"), this.oid));
        arrayList.add(KeymanTree.newNode(Messages.getString("Label.Parameters"), this.parameters.toString()));
        return arrayList;
    }
}

