/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.io.CertificateWriter$OutputMode;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractEntry;
import com.ibm.gsk.ikeyman.keystore.entry.ByteArray;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$AlgorithmItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$DNItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$DisplayItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$ExtensionItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$SanItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$TreeDisplayItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$ValidityItem;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.keystore.ext.Details$DetailIdentifier;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree$KeymanTreeNode;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import java.io.File;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Vector;

class CertificateItemImpl
extends AbstractEntry
implements CertificateItem {
    private Integer keySize = null;
    private DisplayItemFactory$TreeDisplayItem version = null;
    private ByteArray serialNumber = null;
    private DisplayItemFactory$DNItem issuerDN = null;
    private DisplayItemFactory$DNItem subjectDN = null;
    private DisplayItemFactory$ValidityItem validity = null;
    private DisplayItemFactory$DisplayItem fingerprint = null;
    private DisplayItemFactory$AlgorithmItem publicKeyAlgorithm = null;
    private List extensions = null;
    private DisplayItemFactory$AlgorithmItem signatureAlgorithm = null;
    private ByteArray signature = null;
    private DisplayItemFactory$SanItem san = null;
    private Vector extendedKeyUsageV = null;
    private KeyUsageExtension keyUsage = null;
    private SubjectKeyIdentifierExtension skid = null;
    private AuthorityKeyIdentifierExtension akid = null;
    protected X509Certificate cert;

    public CertificateItemImpl(String string, X509Certificate x509Certificate) throws KeyManagerException {
        super(string);
        this.cert = x509Certificate;
        this.populateData();
    }

    private void populateData() throws KeyManagerException {
        try {
            this.validity = DisplayItemFactory.getValidityItem(this.cert.getNotBefore(), this.cert.getNotAfter());
            this.version = X509Version.getVersion(this.cert.getVersion());
            this.extensions = DisplayItemFactory.getExtensionItems(this.cert);
            this.extendedKeyUsageV = DisplayItemFactory.getExtendedKeyUsageItems(this.cert);
            this.keyUsage = DisplayItemFactory.getKeyUsageItems(this.cert);
            this.skid = DisplayItemFactory.getSubjectKeyIdentifierItems(this.cert);
            this.akid = DisplayItemFactory.getAuthorityKeyIdentifierItems(this.cert);
            this.fingerprint = DisplayItemFactory.getFinterprintItem(this.cert);
            this.issuerDN = DisplayItemFactory.getDNItem(this.cert.getIssuerX500Principal());
            this.keySize = CertificateItemImpl.computeKeySize(this.getPublicKey());
            this.publicKeyAlgorithm = DisplayItemFactory.getAlgorithmItem(this.getPublicKey());
            this.serialNumber = new ByteArray(this.cert.getSerialNumber().toByteArray());
            this.signature = new ByteArray(this.cert.getSignature());
            this.signatureAlgorithm = DisplayItemFactory.getAlgorithmItem(this.cert.getSigAlgOID(), this.cert.getSigAlgParams());
            this.subjectDN = DisplayItemFactory.getDNItem(this.cert.getSubjectX500Principal());
        }
        catch (KeyManagerException keyManagerException) {
            keyManagerException.addDetail(this.getLabel());
            throw keyManagerException;
        }
        try {
            this.san = DisplayItemFactory.getSanItem(this.cert.getSubjectAlternativeNames());
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_SAN_IN_CERT, certificateParsingException, new String[]{this.getLabel()});
        }
    }

    public SubjectKeyIdentifierExtension getSubjectKeyIdentifierExtension() {
        return this.skid;
    }

    public AuthorityKeyIdentifierExtension getAuthorityKeyIdentifierExtension() {
        return this.akid;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public DisplayItemFactory$DisplayItem getFingerprint() {
        return this.fingerprint;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public DisplayItemFactory$AlgorithmItem getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DisplayItemFactory$DNItem getSubjectDN() {
        return this.subjectDN;
    }

    public DisplayItemFactory$DNItem getIssuerDN() {
        return this.issuerDN;
    }

    public DisplayItemFactory$ValidityItem getValidity() {
        return this.validity;
    }

    private static String getProvider() {
        return KeymanUtil.getJCEProviderName();
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.getLabel().equals(object);
        }
        if (object instanceof CertificateItemImpl) {
            return this.getLabel().equals(((CertificateItemImpl)object).getLabel());
        }
        return super.equals(object);
    }

    private static int computeKeySize(PublicKey publicKey) {
        int n = 0;
        if (publicKey instanceof RSAPublicKey) {
            n = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            n = ((DSAPublicKey)publicKey).getY().bitLength();
        } else if (publicKey instanceof ECPublicKey) {
            n = ((ECPublicKey)publicKey).getParams().getCurve().getA().bitLength();
        }
        if (n % 2 != 0) {
            ++n;
        }
        return n;
    }

    public void extract(String string, CertificateWriter$OutputMode certificateWriter$OutputMode) throws KeyManagerException {
        CertificateWriter certificateWriter = new CertificateWriter(this.cert, certificateWriter$OutputMode);
        certificateWriter.write(new File(string));
    }

    public void extractAppend(String string, CertificateWriter$OutputMode certificateWriter$OutputMode) throws KeyManagerException {
        CertificateWriter certificateWriter = new CertificateWriter(this.cert, certificateWriter$OutputMode);
        certificateWriter.append(new File(string));
    }

    public DisplayItemFactory$SanItem getSan() {
        return this.san;
    }

    public boolean isTrusted() {
        return true;
    }

    private String trustString() {
        return this.isTrusted() ? Messages.getString("Label.Enabled") : Messages.getString("Label.Disabled");
    }

    public String toLongString() {
        return Messages.getString("Label.Label") + " " + this.getLabel() + "\n" + Messages.getString("Label.KeySize") + KeymanUtil.getLocalisedColon() + " " + this.keySize + "\n" + Messages.getString("Label.Version") + KeymanUtil.getLocalisedColon() + " " + this.version.toString() + "\n" + Messages.getString("Label.SerialNumber") + KeymanUtil.getLocalisedColon() + " " + this.serialNumber.toString() + "\n" + Messages.getString("Label.IssuedBy") + " " + this.issuerDN.toString() + "\n" + Messages.getString("Label.Subject") + KeymanUtil.getLocalisedColon() + " " + this.subjectDN.toString() + "\n" + Messages.getString("Label.Valid") + KeymanUtil.getLocalisedColon() + " " + this.validity.toString() + "\n" + Messages.getString("Label.Fingerprint") + "\n" + this.fingerprint + "\n" + Messages.getString("Label.Extensions") + ": " + this.getExtensionString() + "\n" + Messages.getString("Label.SigAlg") + KeymanUtil.getLocalisedColon() + " " + this.signatureAlgorithm.toString() + "\n" + Messages.getString("Label.TrustStatus") + KeymanUtil.getLocalisedColon() + " " + this.trustString() + "\n";
    }

    private String getExtensionString() {
        StringBuffer stringBuffer = new StringBuffer(" \n");
        if (!this.extensions.isEmpty()) {
            for (DisplayItemFactory$ExtensionItem displayItemFactory$ExtensionItem : this.extensions) {
                Object object;
                Object object2;
                Extension extension = displayItemFactory$ExtensionItem.getExtension();
                if (extension instanceof ExtKeyUsageExtension) {
                    object2 = ((ExtKeyUsageExtension)extension).getExtendedKeyUsage();
                    stringBuffer.append("  - ExtKeyUsage: ");
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        if (string.equalsIgnoreCase("2.5.29.37.0")) {
                            string = "any";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.1")) {
                            string = "serverAuth";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.2")) {
                            string = "clientAuth";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.3")) {
                            string = "codeSigning";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.4")) {
                            string = "emailProtection";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.5")) {
                            string = "ipsecEndSystem";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.6")) {
                            string = "ipsecTunnel";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.7")) {
                            string = "ipsecUser";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.8")) {
                            string = "timeStamping";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.7.3.9")) {
                            string = "OCSPSigning";
                        } else if (string.equalsIgnoreCase("1.3.6.1.5.5.8.2.2")) {
                            string = "iKEIntermediate";
                        } else if (string.equalsIgnoreCase("1.3.6.1.4.1.311.10.3.3")) {
                            string = "microsoftSGC";
                        } else if (string.equalsIgnoreCase("2.16.840.1.113730.4.1")) {
                            string = "netscapeSGC";
                        }
                        stringBuffer.append(string + ", ");
                    }
                    if (!stringBuffer.toString().endsWith(", ") || stringBuffer.length() < 2) continue;
                    stringBuffer.replace(stringBuffer.length() - 2, stringBuffer.length(), "\n");
                    continue;
                }
                if (extension instanceof KeyUsageExtension) {
                    object2 = "";
                    object = ((KeyUsageExtension)extension).getElements();
                    while (object.hasMoreElements()) {
                        object2 = (String)object2 + (String)object.nextElement() + ", ";
                    }
                    if (!((String)object2).equals("")) {
                        object2 = ((String)object2).substring(0, ((String)object2).length() - 2) + "\n";
                    }
                    stringBuffer.append("  - KeyUsage: " + (String)object2);
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.9")) {
                    stringBuffer.append("  - SubjectDirectoryAttributes: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.14")) {
                    stringBuffer.append("  - SubjectKeyIdentifier: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.16")) {
                    stringBuffer.append("  - PrivateKeyUsagePeriod: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.17")) {
                    stringBuffer.append("  - SAN: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.18")) {
                    stringBuffer.append("  - IssuerAlternativeNames: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.19")) {
                    stringBuffer.append("  - BasicConstraints: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.30")) {
                    stringBuffer.append("  - NameConstraints: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.31")) {
                    stringBuffer.append("  - CRLDistributionPoints: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.32")) {
                    stringBuffer.append("  - CertificatePolicies: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.33")) {
                    stringBuffer.append("  - PolicyMappings: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.35")) {
                    stringBuffer.append("  - AuthorityKeyIdentifier: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (extension.getExtensionId().toString().equals("2.5.29.36")) {
                    stringBuffer.append("  - PolicyConstraints: ").append(extension.toString()).append("\n");
                    continue;
                }
                if (!extension.getExtensionId().toString().equals("1.3.6.1.5.5.7.1.1")) continue;
                stringBuffer.append("  - AuthorityInfoAccess: ").append(extension.toString()).append("\n");
            }
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }

    public KeymanTree toTree() {
        KeymanTree keymanTree = new KeymanTree(KeymanTree.newNode(this.getLabel()));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode = (KeymanTree$KeymanTreeNode)keymanTree.getRoot();
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode2 = keymanTree$KeymanTreeNode.addChild(KeymanTree.newNode(Messages.getString("Label.Certificate")));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode3 = keymanTree$KeymanTreeNode2.addChild(KeymanTree.newNode(Messages.getString("Label.TBSCertificate")));
        keymanTree$KeymanTreeNode3.addChildren(this.version.getTreeNodes());
        keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.SerialNumber"), this.serialNumber.toString()));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode4 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.Issuer")));
        keymanTree$KeymanTreeNode4.addChildren(this.issuerDN.getTreeNodes());
        keymanTree$KeymanTreeNode3.addChildren(this.getValidity().getTreeNodes());
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode5 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.Subject")));
        keymanTree$KeymanTreeNode5.addChildren(this.subjectDN.getTreeNodes());
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode6 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKeyInfo")));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode7 = keymanTree$KeymanTreeNode6.addChild(KeymanTree.newNode(Messages.getString("Label.Algorithm")));
        keymanTree$KeymanTreeNode7.addChildren(this.publicKeyAlgorithm.getTreeNodes());
        keymanTree$KeymanTreeNode6.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKey"), new ByteArray(this.getPublicKey().getEncoded()).toString()));
        if (this.extensions.size() > 0) {
            keymanTree$KeymanTreeNode7 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.Extensions")));
            for (DisplayItemFactory$TreeDisplayItem displayItemFactory$TreeDisplayItem : this.extensions) {
                keymanTree$KeymanTreeNode7.addChildren(displayItemFactory$TreeDisplayItem.getTreeNodes());
            }
        }
        keymanTree$KeymanTreeNode4 = keymanTree$KeymanTreeNode2.addChild(KeymanTree.newNode(Messages.getString("Label.SigAlg")));
        keymanTree$KeymanTreeNode4.addChildren(this.signatureAlgorithm.getTreeNodes());
        keymanTree$KeymanTreeNode2.addChild(KeymanTree.newNode(Messages.getString("Label.SigVal"), this.signature.toString()));
        return keymanTree;
    }

    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.TrustedCertificateEntry(this.getCert());
    }

    public String get(Details$DetailIdentifier details$DetailIdentifier) throws KeyManagerException {
        switch (details$DetailIdentifier) {
            case Fingerprint: {
                return this.getFingerprint().toString();
            }
            case IssuedBy: {
                return this.issuerDN.toString();
            }
            case KeySize: {
                return this.keySize + "";
            }
            case SerialNumber: {
                return this.serialNumber.toString();
            }
            case SignatureAlgorithm: {
                return this.signatureAlgorithm.toString();
            }
            case Subject: {
                return this.subjectDN.toString();
            }
            case TrustStatus: {
                return this.isTrusted() + "";
            }
            case Valid: {
                return this.validity.toString();
            }
            case Version: {
                return this.version.toString();
            }
            case EmailAddress: {
                return this.san.getEmailAddress();
            }
            case DnsName: {
                return this.san.getDnsName();
            }
            case IpAddress: {
                return this.san.getIpAddress();
            }
        }
        return super.get(details$DetailIdentifier);
    }

    public boolean isValid() {
        return !this.validity.isExpired();
    }

    public Vector getExtendedKeyUsageV() {
        return this.extendedKeyUsageV;
    }

    public KeyUsageExtension getKeyUsage() {
        return this.keyUsage;
    }
}

