/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.certrequest.BasicCertificateRequestFile;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.CMSCertificateRequestFile;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory$EntryBag;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory$EntryInterface;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.KeyStoreItemFactory$CMSKeyStoreItemImpl;
import com.ibm.gsk.ikeyman.keystore.KeyStoreItemFactory$KeyStoreItemImpl;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$KeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$MSCapiType;
import com.ibm.gsk.ikeyman.keystore.ProtectionParameterCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$CMSDatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS12DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem$ValidationMode;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory$TypeDisplayer;
import java.io.File;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;

public class KeyStoreItemFactory {
    private static final boolean REMOVE_SIGNERS_ENABLED = KeymanSettings$Setting.NoDefaultCertsFunctionEnabled.getBoolean();

    public static KeyStoreItem createKeyStore(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Collection collection) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{databaseDescriptorFactory$DatabaseDescriptor, collection});
        switch (databaseDescriptorFactory$DatabaseDescriptor.getType()) {
            case CMS: {
                Debug.exiting();
                return KeyStoreItemFactory.newCMSKeyStoreItem((DatabaseDescriptorFactory$CMSDatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor, collection, false);
            }
            case JCEKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, collection, true, false);
            }
            case JKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, collection, false, false);
            }
            case PKCS12: 
            case PKCS12S2: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS12KeyStoreItem((DatabaseDescriptorFactory$PKCS12DatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor, collection, false);
            }
        }
        throw new RuntimeException("not implemented for database type " + databaseDescriptorFactory$DatabaseDescriptor.getType());
    }

    public static KeyStoreItem createKeyStore(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException, CancelledException {
        Debug.entering();
        switch (databaseDescriptorFactory$DatabaseDescriptor.getType()) {
            case CMS: {
                Debug.exiting();
                return KeyStoreItemFactory.newCMSKeyStoreItem((DatabaseDescriptorFactory$CMSDatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor, null, !REMOVE_SIGNERS_ENABLED);
            }
            case JCEKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, null, true, !REMOVE_SIGNERS_ENABLED);
            }
            case JKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, null, false, !REMOVE_SIGNERS_ENABLED);
            }
            case PKCS12: 
            case PKCS12S2: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS12KeyStoreItem((DatabaseDescriptorFactory$PKCS12DatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor, null, !REMOVE_SIGNERS_ENABLED);
            }
        }
        throw new RuntimeException("not implemented for database type " + databaseDescriptorFactory$DatabaseDescriptor.getType());
    }

    public static KeyStoreItem loadKeystore(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException, CancelledException {
        Debug.entering();
        switch (databaseDescriptorFactory$DatabaseDescriptor.getType()) {
            case CMS: {
                Debug.exiting();
                return KeyStoreItemFactory.newCMSKeyStoreItem((DatabaseDescriptorFactory$CMSDatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor);
            }
            default: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, true);
            }
            case JKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, false);
            }
            case PKCS12: 
            case PKCS12S2: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS12KeyStoreItem((DatabaseDescriptorFactory$PKCS12DatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor);
            }
            case PKCS11Direct: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS11ImplKeyStoreItem((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor);
            }
            case MSCapi: {
                Debug.exiting();
                return KeyStoreItemFactory.newMSCAPIKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor);
            }
            case PKCS11Config: 
        }
        Debug.exiting();
        return KeyStoreItemFactory.newPKCS11ImplKeyStoreItem((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor);
    }

    public static KeyStoreItem newBasicKeyStoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, boolean bl) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{databaseDescriptorFactory$DatabaseDescriptor});
        Debug.exiting();
        return KeyStoreItemFactory.getBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, false, bl);
    }

    public static KeyStoreItem newBasicKeyStoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Collection collection, boolean bl, boolean bl2) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{databaseDescriptorFactory$DatabaseDescriptor, collection});
        KeyStoreItemFactory.validateFileName(databaseDescriptorFactory$DatabaseDescriptor);
        KeyStoreItem keyStoreItem = KeyStoreItemFactory.getBasicKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor, true, bl);
        if (collection != null) {
            keyStoreItem.addAll(collection, false, true, KeyStoreItem$ValidationMode.ADD);
        }
        if (bl2) {
            KeyStoreItemFactory.addDefaultCACerts(keyStoreItem);
        }
        keyStoreItem.save();
        Debug.exiting(keyStoreItem);
        return keyStoreItem;
    }

    private static void validateFileName(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        Debug.entering(new Object[]{databaseDescriptorFactory$DatabaseDescriptor});
        try {
            if (KeyStoreItemFactory.outputFilesExist(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString())) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_EXISTS, new String[]{databaseDescriptorFactory$DatabaseDescriptor.getFileNameString()});
            }
        }
        catch (SecurityException securityException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_READ_PERMISSION, securityException, new String[]{databaseDescriptorFactory$DatabaseDescriptor.getFileNameString()});
        }
    }

    private static void addDefaultCACerts(KeyStoreItem keyStoreItem) throws KeyManagerException {
        Debug.entering(new Object[]{keyStoreItem});
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("entrust");
        arrayList.add("verisign");
        arrayList.add("thawte");
        for (String string : arrayList) {
            keyStoreItem.addAll(CACertificates.getDefaultCACertificates(string), false, false, KeyStoreItem$ValidationMode.ADD);
        }
        Debug.exiting();
    }

    private static KeyStoreItem getBasicKeyStoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, boolean bl, boolean bl2) throws CancelledException, KeyManagerException {
        EntryBagFactory$EntryBag entryBagFactory$EntryBag;
        EntryBagFactory$EntryBag entryBagFactory$EntryBag2;
        KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy = databaseDescriptorFactory$DatabaseDescriptor.getType().getCreater().create(databaseDescriptorFactory$DatabaseDescriptor, bl);
        keyStoreProxyCreatorFactory$KeyStoreProxy.getKeyStore();
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface = bl ? BasicCertificateRequestFile.createRequestFile(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString(), databaseDescriptorFactory$DatabaseDescriptor.getPassword(), DatabaseDescriptorFactory$DatabaseDescriptor.class) : BasicCertificateRequestFile.loadRequestFile(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString(), databaseDescriptorFactory$DatabaseDescriptor.getPassword(), DatabaseDescriptorFactory$DatabaseDescriptor.class);
        EntryBagFactory$EntryBag entryBagFactory$EntryBag3 = EntryBagFactory.newKeyStoreCertificateBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), databaseDescriptorFactory$DatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag4 = EntryBagFactory.newKeyStoreKeyBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), databaseDescriptorFactory$DatabaseDescriptor.getPassword());
        if (bl2) {
            entryBagFactory$EntryBag2 = EntryBagFactory.newKeyStoreSecretKeyBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), databaseDescriptorFactory$DatabaseDescriptor.getPassword());
            entryBagFactory$EntryBag = EntryBagFactory.newBagCollection(new EntryBagFactory$EntryBag[]{entryBagFactory$EntryBag3, entryBagFactory$EntryBag4, entryBagFactory$EntryBag2});
        } else {
            entryBagFactory$EntryBag = EntryBagFactory.newBagCollection(new EntryBagFactory$EntryBag[]{entryBagFactory$EntryBag3, entryBagFactory$EntryBag4});
        }
        entryBagFactory$EntryBag2 = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(entryBagFactory$EntryBag, databaseDescriptorFactory$DatabaseDescriptor, keyStoreProxyCreatorFactory$KeyStoreProxy);
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface2 = EntryInterfaceFactory.newCompoundEntryInterface(databaseDescriptorFactory$DatabaseDescriptor, new EntryInterfaceFactory$EntryInterface[]{entryBagFactory$EntryBag2, entryInterfaceFactory$EntryInterface});
        KeyStoreItemFactory$KeyStoreItemImpl keyStoreItemFactory$KeyStoreItemImpl = new KeyStoreItemFactory$KeyStoreItemImpl(entryInterfaceFactory$EntryInterface2, databaseDescriptorFactory$DatabaseDescriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()), DatabaseDescriptorFactory$DatabaseDescriptor.class);
        if (databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.JKS) || databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.JCEKS)) {
            KeyStoreItemFactory.doJks(keyStoreProxyCreatorFactory$KeyStoreProxy.getKeyStore(), databaseDescriptorFactory$DatabaseDescriptor.getPassword());
            keyStoreItemFactory$KeyStoreItemImpl.refresh();
        }
        return keyStoreItemFactory$KeyStoreItemImpl;
    }

    private static void doJks(KeyStore keyStore, String string) throws KeyManagerException {
        String string2 = null;
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            ArrayList<String> arrayList = Collections.list(enumeration);
            for (String string3 : arrayList) {
                if (!keyStore.isCertificateEntry(string3) || !string3.trim().isEmpty()) continue;
                Certificate certificate = keyStore.getCertificate(string3);
                keyStore.deleteEntry(string3);
                string2 = keyStore.getCertificateAlias(certificate);
                if (string2 == null || keyStore.isCertificateEntry(string2)) {
                    keyStore.setCertificateEntry(string3, certificate);
                    continue;
                }
                Key key = keyStore.getKey(string2, string.toCharArray());
                Certificate[] certificateArray = keyStore.getCertificateChain(string2);
                keyStore.deleteEntry(string2);
                keyStore.setKeyEntry(string2, key, string.toCharArray(), certificateArray);
                if (certificateArray == null || certificateArray.length <= 1) continue;
                for (int i = certificateArray.length - 1; i > 0; --i) {
                    String string4 = keyStore.getCertificateAlias(certificateArray[i]);
                    if (string4 != null) continue;
                    String string5 = ((X509Certificate)certificateArray[i]).getSubjectX500Principal().toString();
                    if (keyStore.containsAlias(string5)) {
                        keyStore.deleteEntry(string5);
                    }
                    keyStore.setCertificateEntry(string5, certificateArray[i]);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.UNRECOVERABLE_ENTRY, unrecoverableKeyException, new String[]{string2});
        }
    }

    public static KeyStoreItem newCMSKeyStoreItem(DatabaseDescriptorFactory$CMSDatabaseDescriptor databaseDescriptorFactory$CMSDatabaseDescriptor, Collection collection, boolean bl) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{databaseDescriptorFactory$CMSDatabaseDescriptor, collection});
        KeyStoreItemFactory.validateFileName(databaseDescriptorFactory$CMSDatabaseDescriptor);
        KeyStoreItem keyStoreItem = KeyStoreItemFactory.getCMSKeyStoreItem(databaseDescriptorFactory$CMSDatabaseDescriptor, true);
        keyStoreItem.clear();
        if (collection != null) {
            keyStoreItem.addAll(collection, false, true, KeyStoreItem$ValidationMode.ADD);
        }
        if (bl) {
            KeyStoreItemFactory.addDefaultCACerts(keyStoreItem);
        }
        keyStoreItem.save();
        Debug.exiting(keyStoreItem);
        return keyStoreItem;
    }

    public static KeyStoreItem newCMSKeyStoreItem(DatabaseDescriptorFactory$CMSDatabaseDescriptor databaseDescriptorFactory$CMSDatabaseDescriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getCMSKeyStoreItem(databaseDescriptorFactory$CMSDatabaseDescriptor, false);
    }

    private static KeyStoreItem getCMSKeyStoreItem(DatabaseDescriptorFactory$CMSDatabaseDescriptor databaseDescriptorFactory$CMSDatabaseDescriptor, boolean bl) throws CancelledException, KeyManagerException {
        KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy = databaseDescriptorFactory$CMSDatabaseDescriptor.getType().getCreater().create(databaseDescriptorFactory$CMSDatabaseDescriptor, bl);
        keyStoreProxyCreatorFactory$KeyStoreProxy.getKeyStore();
        int n = databaseDescriptorFactory$CMSDatabaseDescriptor.isPQC() ? 6 : 4;
        CMSCertificateRequestFile cMSCertificateRequestFile = bl ? CMSCertificateRequestFile.createRequestFile(databaseDescriptorFactory$CMSDatabaseDescriptor.getFileName(), databaseDescriptorFactory$CMSDatabaseDescriptor.getPassword(), n) : CMSCertificateRequestFile.loadRequestFile(databaseDescriptorFactory$CMSDatabaseDescriptor.getFileName(), databaseDescriptorFactory$CMSDatabaseDescriptor.getPassword(), n);
        EntryBagFactory$EntryBag entryBagFactory$EntryBag = EntryBagFactory.newCMSKeyStoreCertificateBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), databaseDescriptorFactory$CMSDatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag2 = EntryBagFactory.newCMSKeyStoreKeyBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), databaseDescriptorFactory$CMSDatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag3 = EntryBagFactory.newBagCollection(new EntryBagFactory$EntryBag[]{entryBagFactory$EntryBag, entryBagFactory$EntryBag2});
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(entryBagFactory$EntryBag3, databaseDescriptorFactory$CMSDatabaseDescriptor, keyStoreProxyCreatorFactory$KeyStoreProxy);
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface2 = EntryInterfaceFactory.newCompoundEntryInterface(databaseDescriptorFactory$CMSDatabaseDescriptor, new EntryInterfaceFactory$EntryInterface[]{entryInterfaceFactory$EntryInterface, cMSCertificateRequestFile});
        KeyStoreItemFactory$CMSKeyStoreItemImpl keyStoreItemFactory$CMSKeyStoreItemImpl = new KeyStoreItemFactory$CMSKeyStoreItemImpl(entryInterfaceFactory$EntryInterface2, databaseDescriptorFactory$CMSDatabaseDescriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()));
        return keyStoreItemFactory$CMSKeyStoreItemImpl;
    }

    public static KeyStoreItem newPKCS12KeyStoreItem(DatabaseDescriptorFactory$PKCS12DatabaseDescriptor databaseDescriptorFactory$PKCS12DatabaseDescriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getPKCS12KeyStoreItem(databaseDescriptorFactory$PKCS12DatabaseDescriptor, false);
    }

    private static KeyStoreItem getPKCS12KeyStoreItem(DatabaseDescriptorFactory$PKCS12DatabaseDescriptor databaseDescriptorFactory$PKCS12DatabaseDescriptor, boolean bl) throws CancelledException, KeyManagerException {
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface;
        KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy = databaseDescriptorFactory$PKCS12DatabaseDescriptor.getType().getCreater().create(databaseDescriptorFactory$PKCS12DatabaseDescriptor, bl);
        keyStoreProxyCreatorFactory$KeyStoreProxy.getKeyStore();
        EntryBagFactory$EntryBag entryBagFactory$EntryBag = EntryBagFactory.newKeyStoreCertificateBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), databaseDescriptorFactory$PKCS12DatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag2 = EntryBagFactory.newKeyStoreKeyBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), databaseDescriptorFactory$PKCS12DatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag3 = EntryBagFactory.newPKCS11CertRequestBag(keyStoreProxyCreatorFactory$KeyStoreProxy, null, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), null, databaseDescriptorFactory$PKCS12DatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag4 = EntryBagFactory.newBagCollection(new EntryBagFactory$EntryBag[]{entryBagFactory$EntryBag, entryBagFactory$EntryBag2, entryBagFactory$EntryBag3});
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface2 = entryInterfaceFactory$EntryInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(entryBagFactory$EntryBag4, databaseDescriptorFactory$PKCS12DatabaseDescriptor, keyStoreProxyCreatorFactory$KeyStoreProxy);
        KeyStoreItemFactory$KeyStoreItemImpl keyStoreItemFactory$KeyStoreItemImpl = new KeyStoreItemFactory$KeyStoreItemImpl(entryInterfaceFactory$EntryInterface2, databaseDescriptorFactory$PKCS12DatabaseDescriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()), DatabaseDescriptorFactory$PKCS12DatabaseDescriptor.class);
        if (databaseDescriptorFactory$PKCS12DatabaseDescriptor.isPfxFile() || databaseDescriptorFactory$PKCS12DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12) || databaseDescriptorFactory$PKCS12DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12S2)) {
            KeyStoreItemFactory.doPfx(keyStoreProxyCreatorFactory$KeyStoreProxy.getKeyStore(), databaseDescriptorFactory$PKCS12DatabaseDescriptor.getPassword());
            keyStoreItemFactory$KeyStoreItemImpl.refresh();
        }
        return keyStoreItemFactory$KeyStoreItemImpl;
    }

    private static void doPfx(KeyStore keyStore, String string) throws KeyManagerException {
        String string2 = null;
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            ArrayList<String> arrayList = Collections.list(enumeration);
            for (String string3 : arrayList) {
                if (!keyStore.isCertificateEntry(string3)) continue;
                Certificate certificate = keyStore.getCertificate(string3);
                keyStore.deleteEntry(string3);
                string2 = keyStore.getCertificateAlias(certificate);
                if (string2 == null || keyStore.isCertificateEntry(string2)) {
                    keyStore.setCertificateEntry(string3, certificate);
                    continue;
                }
                Key key = keyStore.getKey(string2, string.toCharArray());
                Certificate[] certificateArray = keyStore.getCertificateChain(string2);
                keyStore.deleteEntry(string2);
                if (!string3.trim().isEmpty()) {
                    keyStore.setKeyEntry(string3, key, string.toCharArray(), certificateArray);
                    continue;
                }
                keyStore.setKeyEntry(string2, key, string.toCharArray(), certificateArray);
                if (certificateArray == null || certificateArray.length <= 1) continue;
                for (int i = certificateArray.length - 1; i > 0; --i) {
                    String string4 = keyStore.getCertificateAlias(certificateArray[i]);
                    if (string4 != null) continue;
                    String string5 = ((X509Certificate)certificateArray[i]).getSubjectX500Principal().toString();
                    if (keyStore.containsAlias(string5)) {
                        keyStore.deleteEntry(string5);
                    }
                    keyStore.setCertificateEntry(string5, certificateArray[i]);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.UNRECOVERABLE_ENTRY, unrecoverableKeyException, new String[]{string2});
        }
    }

    public static KeyStoreItem newPKCS12KeyStoreItem(DatabaseDescriptorFactory$PKCS12DatabaseDescriptor databaseDescriptorFactory$PKCS12DatabaseDescriptor, Collection collection, boolean bl) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{databaseDescriptorFactory$PKCS12DatabaseDescriptor, collection, bl});
        KeyStoreItemFactory.validateFileName(databaseDescriptorFactory$PKCS12DatabaseDescriptor);
        KeyStoreItem keyStoreItem = KeyStoreItemFactory.getPKCS12KeyStoreItem(databaseDescriptorFactory$PKCS12DatabaseDescriptor, true);
        if (collection != null) {
            keyStoreItem.addAll(collection, false, true, KeyStoreItem$ValidationMode.ADD);
        }
        if (bl) {
            KeyStoreItemFactory.addDefaultCACerts(keyStoreItem);
        }
        keyStoreItem.save();
        Debug.exiting(keyStoreItem);
        return keyStoreItem;
    }

    public static KeyStoreItem newPKCS11ImplKeyStoreItem(DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptor databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getPKCS11ImplKeyStoreItem(databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor);
    }

    private static KeyStoreItem getPKCS11ImplKeyStoreItem(DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptor databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor) throws CancelledException, KeyManagerException {
        KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy = databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getType().getCreater().create(databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor, false);
        KeyStoreItemFactory$KeyStoreItemImpl keyStoreItemFactory$KeyStoreItemImpl = null;
        if (databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getSecondaryDescriptor() != null) {
            keyStoreItemFactory$KeyStoreItemImpl = (KeyStoreItemFactory$KeyStoreItemImpl)KeyStoreItemFactory.loadKeystore(databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getSecondaryDescriptor());
        }
        TypeDisplayerFactory$TypeDisplayer typeDisplayerFactory$TypeDisplayer = databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor instanceof DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig ? TypeDisplayerFactory.newPKCS11EntryDisplayer(((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig)databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor).getTokenLabel()) : TypeDisplayerFactory.newPKCS11EntryDisplayer(((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect)databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor).getSlotNumber() + "");
        EntryBagFactory$EntryBag entryBagFactory$EntryBag = EntryBagFactory.newPKCS11CertificateBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), typeDisplayerFactory$TypeDisplayer, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag2 = EntryBagFactory.newPKCS11KeyBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), typeDisplayerFactory$TypeDisplayer, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag3 = EntryBagFactory.newPKCS11CertRequestBag(keyStoreProxyCreatorFactory$KeyStoreProxy, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getProvider(), ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), typeDisplayerFactory$TypeDisplayer, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag4 = EntryBagFactory.newPKCS11SecretKeyBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), typeDisplayerFactory$TypeDisplayer, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag5 = EntryBagFactory.newBagCollection(new EntryBagFactory$EntryBag[]{entryBagFactory$EntryBag, entryBagFactory$EntryBag2, entryBagFactory$EntryBag3, entryBagFactory$EntryBag4});
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(entryBagFactory$EntryBag5, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor, keyStoreProxyCreatorFactory$KeyStoreProxy);
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface2 = keyStoreItemFactory$KeyStoreItemImpl != null ? EntryInterfaceFactory.newPrimarySecondaryInterface(databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor, entryInterfaceFactory$EntryInterface, keyStoreItemFactory$KeyStoreItemImpl.entryInterface) : entryInterfaceFactory$EntryInterface;
        KeyStoreItemFactory$KeyStoreItemImpl keyStoreItemFactory$KeyStoreItemImpl2 = new KeyStoreItemFactory$KeyStoreItemImpl(entryInterfaceFactory$EntryInterface2, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor, KeyCreatorFactory.getPKCS11KeyCreator(databaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.getProvider()), DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptor.class);
        return keyStoreItemFactory$KeyStoreItemImpl2;
    }

    public static KeyStoreItem newMSCAPIKeyStoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getMSCAPIKeyStoreItem(databaseDescriptorFactory$DatabaseDescriptor);
    }

    private static KeyStoreItem getMSCAPIKeyStoreItem(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws CancelledException, KeyManagerException {
        databaseDescriptorFactory$DatabaseDescriptor.setPassword("");
        KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy = databaseDescriptorFactory$DatabaseDescriptor.getType().getCreater().create(databaseDescriptorFactory$DatabaseDescriptor, false);
        KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy2 = KeyStoreProxyCreatorFactory.newMSCapiKeyStoreCreater(KeyStoreProxyCreatorFactory$MSCapiType.MY).create(databaseDescriptorFactory$DatabaseDescriptor, false);
        EntryBagFactory$EntryBag entryBagFactory$EntryBag = EntryBagFactory.newKeyStoreCertificateBag(keyStoreProxyCreatorFactory$KeyStoreProxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), databaseDescriptorFactory$DatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag2 = EntryBagFactory.newKeyStoreKeyBag(keyStoreProxyCreatorFactory$KeyStoreProxy2, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), databaseDescriptorFactory$DatabaseDescriptor.getPassword());
        EntryBagFactory$EntryBag entryBagFactory$EntryBag3 = EntryBagFactory.newBagCollection(new EntryBagFactory$EntryBag[]{entryBagFactory$EntryBag, entryBagFactory$EntryBag2});
        EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(entryBagFactory$EntryBag3, databaseDescriptorFactory$DatabaseDescriptor, keyStoreProxyCreatorFactory$KeyStoreProxy);
        KeyStoreItemFactory$KeyStoreItemImpl keyStoreItemFactory$KeyStoreItemImpl = new KeyStoreItemFactory$KeyStoreItemImpl(entryInterfaceFactory$EntryInterface, databaseDescriptorFactory$DatabaseDescriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()), DatabaseDescriptorFactory$DatabaseDescriptor.class);
        return keyStoreItemFactory$KeyStoreItemImpl;
    }

    private static boolean outputFilesExist(String string) {
        return new File(string).exists();
    }
}

