/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$1;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$CertificateParser;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$UnsuitableParserException;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;

class CertificateParserFactory$ASCIIParser
implements CertificateParserFactory$CertificateParser {
    private CertificateParserFactory$ASCIIParser() {
    }

    public Collection getCertificates(byte[] byArray, String string) throws KeyManagerException {
        String string2 = new String(byArray);
        if (!string2.contains("-----BEGIN CERTIFICATE-----")) {
            throw new CertificateParserFactory$UnsuitableParserException(null);
        }
        try {
            int n = 0;
            int n2 = 0;
            CertificateFactory certificateFactory = null;
            if (KeymanUtil.isIBMJCE()) {
                try {
                    certificateFactory = CertificateFactory.getInstance(KeymanUtil.getX509FormatIBM(), string);
                }
                catch (CertificateException certificateException) {
                    String string3 = null;
                    if (KeymanUtil.isIBMJCEPlusModeOn() && (string3 = KeymanUtil.getJCEProviderNameLegacy()) != null) {
                        certificateFactory = CertificateFactory.getInstance(KeymanUtil.getX509FormatIBM(), string3);
                    }
                    throw certificateException;
                }
            } else {
                certificateFactory = CertificateFactory.getInstance(KeymanUtil.getX509FormatOracle());
            }
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            while ((n = string2.indexOf("-----BEGIN CERTIFICATE-----", n2)) != -1) {
                n2 = string2.indexOf("-----END CERTIFICATE-----", n);
                String string4 = string2.substring(n, n2 + "-----END CERTIFICATE-----".length());
                arrayList.addAll(certificateFactory.generateCertificates(new ByteArrayInputStream(string4.getBytes())));
            }
            return arrayList;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{KeymanUtil.getJCEProviderName()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CORRUPT_CERTIFICATE, (Throwable)certificateException);
        }
    }

    public Collection getCertificates(Object object, String string) throws KeyManagerException {
        return this.getCertificates((byte[])object, string);
    }

    CertificateParserFactory$ASCIIParser(CertificateParserFactory$1 certificateParserFactory$1) {
        this();
    }
}

