/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.panels.KeymanPanel;
import com.ibm.gsk.ikeyman.gui.panels.SanDetailsPanel;
import com.ibm.gsk.ikeyman.keystore.ext.Details$DetailIdentifier;
import com.ibm.gsk.ikeyman.keystore.ext.Displayable;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CertificateDetailsPanel
extends KeymanPanel {
    private static final long serialVersionUID = 1L;
    private JLabel jLabel = null;
    private JLabel keySizeLabel = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel versionLabel = null;
    private JLabel jLabel5 = null;
    private JLabel serialNumberLabel = null;
    private JLabel jLabel7 = null;
    private JTextArea issuedToArea = null;
    private JLabel jLabel8 = null;
    private JTextArea issuedByArea = null;
    private JLabel jLabel9 = null;
    private JLabel validityLabel = null;
    private JLabel jLabel11 = null;
    private JLabel fingerprintLabel = null;
    private JLabel jLabel13 = null;
    private JLabel signatureAlgorithmLabel = null;
    private SanDetailsPanel sanDetailsPanel = null;
    private JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1 = null;

    private CertificateDetailsPanel() {
        this.initialize();
    }

    public CertificateDetailsPanel(Displayable displayable) throws KeyManagerException {
        this();
        this.populatePanel(displayable);
    }

    private void initialize() {
        this.signatureAlgorithmLabel = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel13.setText(Messages.getString("Label.SigAlg") + KeymanUtil.getLocalisedColon());
        this.jLabel13.setName(ControlNames.CertificateDetailsPanelSigAlgLabel.toString());
        this.fingerprintLabel = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel11.setText(Messages.getString("Label.Fingerprint"));
        this.jLabel11.setName(ControlNames.CertificateDetailsPanelFingerprintDigestLabel.toString());
        this.validityLabel = new JLabel();
        this.validityLabel.setName(ControlNames.CertificateDetailsPanelValidityDataLabel.toString());
        this.jLabel9 = new JLabel();
        this.jLabel9.setText(Messages.getString("Label.Validity") + KeymanUtil.getLocalisedColon());
        this.jLabel9.setName(ControlNames.CertificateDetailsPanelValidityLabel.toString());
        this.jLabel8 = new JLabel();
        this.jLabel8.setText(Messages.getString("Label.IssuedBy") + " ");
        this.jLabel8.setName(ControlNames.CertificateDetailsPanelIssuedByLabel.toString());
        this.jLabel7 = new JLabel();
        this.jLabel7.setText(Messages.getString("Label.IssuedTo") + " ");
        this.jLabel7.setName(ControlNames.CertificateDetailsPanelIssuedToLabel.toString());
        this.serialNumberLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel5.setText(Messages.getString("Label.SerialNumber") + KeymanUtil.getLocalisedColon());
        this.jLabel5.setName(ControlNames.CertificateDetailsPanelSerialNumberLabel.toString());
        this.versionLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel3.setText(Messages.getString("Label.Version") + KeymanUtil.getLocalisedColon());
        this.jLabel3.setName(ControlNames.CertificateDetailsPanelVersionLabel.toString());
        this.jLabel2 = new JLabel();
        this.jLabel2.setText(Messages.getString("Label.CertificateProperties"));
        this.jLabel2.setName(ControlNames.CertificateDetailsPanelCertificatePropertiesLabel.toString());
        this.keySizeLabel = new JLabel();
        this.jLabel = new JLabel();
        this.jLabel.setText(Messages.getString("Label.KeySize") + KeymanUtil.getLocalisedColon());
        this.jLabel.setName(ControlNames.CertificateDetailsPanelKeySizeLabel.toString());
        this.setSize(348, 499);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createBevelBorder(1)));
        this.setName(ControlNames.CertificateDetailsPanel.toString());
        this.addComponent(this, this.jLabel, 0, 0, new Insets(5, 5, 0, 0), 1, 17, 0);
        this.addComponent(this, this.keySizeLabel, 1, 0, new Insets(5, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel2, 0, 1, new Insets(1, 5, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel3, 0, 2, new Insets(1, 15, 0, 0), 1, 17, 0);
        this.addComponent(this, this.versionLabel, 1, 2, new Insets(1, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel5, 0, 3, new Insets(1, 15, 0, 0), 1, 17, 0);
        this.addComponent(this, this.serialNumberLabel, 1, 3, new Insets(1, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel7, 0, 4, new Insets(1, 15, 0, 0), 1, 17, 0);
        this.addComponent(this, this.getJScrollPane(), 0, 5, new Insets(2, 25, 0, 10), 2, 17, 1, 1.0, 1.0);
        this.addComponent(this, this.jLabel8, 0, 7, new Insets(5, 15, 0, 0), 1, 17, 0);
        this.addComponent(this, this.getJScrollPane1(), 0, 8, new Insets(2, 25, 0, 10), 2, 17, 1, 1.0, 1.0);
        this.addComponent(this, this.jLabel9, 0, 10, new Insets(5, 15, 0, 0), 1, 17, 0);
        this.addComponent(this, this.validityLabel, 1, 10, new Insets(1, 10, 0, 10), 1, 17, 0);
        this.addComponent(this, this.jLabel11, 0, 11, new Insets(1, 15, 0, 0), 2, 17, 0);
        this.addComponent(this, this.fingerprintLabel, 0, 12, new Insets(1, 25, 0, 0), 2, 17, 0);
        this.addComponent(this, this.jLabel13, 0, 13, new Insets(1, 15, 0, 0), 1, 17, 0);
        this.addComponent(this, this.signatureAlgorithmLabel, 1, 13, new Insets(1, 10, 0, 0), 1, 17, 0);
        if (KeymanSettings$Setting.SANEnabled.getBoolean().booleanValue()) {
            this.addComponent(this, this.getSanDetailsPanel(), 0, 14, new Insets(0, 15, 0, 0), 2, 17, 2);
        }
    }

    private JTextArea getIssuedToArea() {
        if (this.issuedToArea == null) {
            this.issuedToArea = new JTextArea();
            this.issuedToArea.setRows(5);
            this.issuedToArea.setLineWrap(true);
            this.issuedToArea.setColumns(40);
            this.issuedToArea.setEditable(false);
        }
        return this.issuedToArea;
    }

    private JTextArea getIssuedByArea() {
        if (this.issuedByArea == null) {
            this.issuedByArea = new JTextArea();
            this.issuedByArea.setRows(5);
            this.issuedByArea.setEditable(false);
            this.issuedByArea.setColumns(40);
            this.issuedByArea.setLineWrap(true);
        }
        return this.issuedByArea;
    }

    private void populatePanel(Displayable displayable) throws KeyManagerException {
        this.keySizeLabel.setText("" + displayable.get(Details$DetailIdentifier.KeySize));
        this.versionLabel.setText(displayable.get(Details$DetailIdentifier.Version));
        this.serialNumberLabel.setText(displayable.get(Details$DetailIdentifier.SerialNumber));
        this.issuedToArea.setText(displayable.get(Details$DetailIdentifier.Subject));
        this.issuedToArea.setCaretPosition(0);
        this.issuedByArea.setText(displayable.get(Details$DetailIdentifier.IssuedBy));
        this.issuedByArea.setCaretPosition(0);
        this.validityLabel.setText(displayable.get(Details$DetailIdentifier.Valid));
        this.fingerprintLabel.setText(this.formatFingerprintWithHTML(displayable.get(Details$DetailIdentifier.Fingerprint)));
        this.signatureAlgorithmLabel.setText(displayable.get(Details$DetailIdentifier.SignatureAlgorithm));
        if (KeymanSettings$Setting.SANEnabled.getBoolean().booleanValue()) {
            this.sanDetailsPanel.setEmail(displayable.get(Details$DetailIdentifier.EmailAddress));
            this.sanDetailsPanel.setIp(displayable.get(Details$DetailIdentifier.IpAddress));
            this.sanDetailsPanel.setDns(displayable.get(Details$DetailIdentifier.DnsName));
        }
    }

    private SanDetailsPanel getSanDetailsPanel() {
        if (this.sanDetailsPanel == null) {
            this.sanDetailsPanel = new SanDetailsPanel();
        }
        return this.sanDetailsPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getIssuedToArea());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getIssuedByArea());
        }
        return this.jScrollPane1;
    }

    private String formatFingerprintWithHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(0, "<html>");
        stringBuffer.append("</html>");
        return stringBuffer.toString().replaceAll("\n", "<br>");
    }
}

