/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.File;
import java.util.ArrayList;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.utils.AttList;
import org.apache.xml.serializer.utils.DOM2Helper;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public final class TreeWalker {
    private final ContentHandler m_contentHandler;
    private final SerializationHandler m_Serializer;
    protected final DOM2Helper m_dh;
    private final LocatorImpl m_locator = new LocatorImpl();
    private final NamedNodeMapImpl m_attrs_no_NS = new NamedNodeMapImpl();
    boolean nextIsRaw = false;

    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public TreeWalker(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public TreeWalker(ContentHandler contentHandler, String string) {
        this.m_contentHandler = contentHandler;
        this.m_Serializer = this.m_contentHandler instanceof SerializationHandler ? (SerializationHandler)this.m_contentHandler : null;
        if (this.m_contentHandler != null) {
            this.m_contentHandler.setDocumentLocator(this.m_locator);
        }
        if (string != null) {
            this.m_locator.setSystemId(string);
        } else {
            try {
                this.m_locator.setSystemId(System.getProperty("user.dir") + File.separator + "dummy.xsl");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.m_dh = new DOM2Helper();
    }

    public void traverse(Node node) throws SAXException {
        this.m_contentHandler.startDocument();
        Node node2 = node;
        while (null != node) {
            this.startNode(node);
            Node node3 = node.getFirstChild();
            while (null == node3) {
                this.endNode(node);
                if (node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (null != node3 || null != (node = node.getParentNode()) && !node2.equals(node)) continue;
                if (null != node) {
                    this.endNode(node);
                }
                node3 = null;
                break;
            }
            node = node3;
        }
        this.m_contentHandler.endDocument();
    }

    public void traverse(Node node, Node node2) throws SAXException {
        this.m_contentHandler.startDocument();
        while (null != node) {
            this.startNode(node);
            Node node3 = node.getFirstChild();
            while (null == node3) {
                this.endNode(node);
                if (null != node2 && node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (null != node3 || null != (node = node.getParentNode()) && (null == node2 || !node2.equals(node))) continue;
                node3 = null;
                break;
            }
            node = node3;
        }
        this.m_contentHandler.endDocument();
    }

    private final void dispatachChars(Node node) throws SAXException {
        if (this.m_Serializer != null) {
            this.m_Serializer.characters(node);
        } else {
            String string = ((Text)node).getData();
            this.m_contentHandler.characters(string.toCharArray(), 0, string.length());
        }
    }

    protected void startNode(Node node) throws SAXException {
        Object object;
        if (node instanceof Locator) {
            object = (Locator)((Object)node);
            this.m_locator.setColumnNumber(object.getColumnNumber());
            this.m_locator.setLineNumber(object.getLineNumber());
            this.m_locator.setPublicId(object.getPublicId());
            this.m_locator.setSystemId(object.getSystemId());
        } else {
            this.m_locator.setColumnNumber(0);
            this.m_locator.setLineNumber(0);
        }
        switch (node.getNodeType()) {
            case 8: {
                object = ((Comment)node).getData();
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_contentHandler);
                lexicalHandler.comment(((String)object).toCharArray(), 0, ((String)object).length());
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                object = (Element)node;
                Object object2 = object.getNamespaceURI();
                if (object2 != null) {
                    String string = object.getPrefix();
                    if (string == null) {
                        string = "";
                    }
                    this.m_contentHandler.startPrefixMapping(string, (String)object2);
                }
                object2 = object.getAttributes();
                int n = object2.getLength();
                for (int i = 0; i < n; ++i) {
                    String string;
                    Node node2 = object2.item(i);
                    String string2 = node2.getNodeName();
                    int n2 = string2.indexOf(58);
                    if (string2.equals("xmlns") || string2.startsWith("xmlns:")) {
                        string = n2 < 0 ? "" : string2.substring(n2 + 1);
                        this.m_contentHandler.startPrefixMapping(string, node2.getNodeValue());
                        continue;
                    }
                    if (n2 > 0) {
                        string = string2.substring(0, n2);
                        String string3 = node2.getNamespaceURI();
                        if (string3 != null) {
                            this.m_contentHandler.startPrefixMapping(string, string3);
                        }
                    }
                    this.m_attrs_no_NS.append(node2);
                }
                String string = this.m_dh.getNamespaceOfNode(node);
                if (null == string) {
                    string = "";
                }
                this.m_contentHandler.startElement(string, this.m_dh.getLocalNameOfNode(node), node.getNodeName(), new AttList(this.m_attrs_no_NS, this.m_dh));
                this.m_attrs_no_NS.reset();
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                String string = processingInstruction.getNodeName();
                if (string.equals("xslt-next-is-raw")) {
                    this.nextIsRaw = true;
                    break;
                }
                this.m_contentHandler.processingInstruction(processingInstruction.getNodeName(), processingInstruction.getData());
                break;
            }
            case 4: {
                LexicalHandler lexicalHandler;
                boolean bl = this.m_contentHandler instanceof LexicalHandler;
                LexicalHandler lexicalHandler2 = lexicalHandler = bl ? (LexicalHandler)((Object)this.m_contentHandler) : null;
                if (bl) {
                    lexicalHandler.startCDATA();
                }
                this.dispatachChars(node);
                if (!bl) break;
                lexicalHandler.endCDATA();
                break;
            }
            case 3: {
                if (this.nextIsRaw) {
                    this.nextIsRaw = false;
                    this.m_contentHandler.processingInstruction("javax.xml.transform.disable-output-escaping", "");
                    this.dispatachChars(node);
                    this.m_contentHandler.processingInstruction("javax.xml.transform.enable-output-escaping", "");
                    break;
                }
                this.dispatachChars(node);
                break;
            }
            case 5: {
                EntityReference entityReference = (EntityReference)node;
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                ((LexicalHandler)((Object)this.m_contentHandler)).startEntity(entityReference.getNodeName());
                break;
            }
        }
    }

    protected void endNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                break;
            }
            case 1: {
                Object object;
                String string = this.m_dh.getNamespaceOfNode(node);
                if (null == string) {
                    string = "";
                }
                this.m_contentHandler.endElement(string, this.m_dh.getLocalNameOfNode(node), node.getNodeName());
                if (this.m_Serializer != null) break;
                Element element = (Element)node;
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = n - 1; 0 <= i; --i) {
                    String string2;
                    object = namedNodeMap.item(i);
                    String string3 = object.getNodeName();
                    int n2 = string3.indexOf(58);
                    if (string3.equals("xmlns") || string3.startsWith("xmlns:")) {
                        string2 = n2 < 0 ? "" : string3.substring(n2 + 1);
                        this.m_contentHandler.endPrefixMapping(string2);
                        continue;
                    }
                    if (n2 <= 0) continue;
                    string2 = string3.substring(0, n2);
                    this.m_contentHandler.endPrefixMapping(string2);
                }
                String string4 = element.getNamespaceURI();
                if (string4 == null) break;
                object = element.getPrefix();
                if (object == null) {
                    object = "";
                }
                this.m_contentHandler.endPrefixMapping((String)object);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                EntityReference entityReference = (EntityReference)node;
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_contentHandler);
                lexicalHandler.endEntity(entityReference.getNodeName());
                break;
            }
        }
    }

    private class NamedNodeMapImpl
    implements NamedNodeMap {
        final ArrayList m_nodes = new ArrayList();
        int m_node_count = 0;

        NamedNodeMapImpl() {
        }

        private void reset() {
            for (int i = 0; i < this.m_node_count; ++i) {
                this.m_nodes.set(i, null);
            }
            this.m_node_count = 0;
        }

        public void append(Node node) {
            int n = this.m_nodes.size();
            if (this.m_node_count < n) {
                this.m_nodes.set(this.m_node_count, node);
            } else {
                this.m_nodes.add(node);
            }
            ++this.m_node_count;
        }

        @Override
        public Node getNamedItem(String string) {
            Node node = null;
            if (string != null) {
                for (int i = 0; node == null && i < this.m_node_count; ++i) {
                    Node node2 = (Node)this.m_nodes.get(i);
                    if (!string.equals(node2.getNodeName())) continue;
                    node = node2;
                }
            }
            return node;
        }

        @Override
        public Node setNamedItem(Node node) throws DOMException {
            return null;
        }

        @Override
        public Node removeNamedItem(String string) throws DOMException {
            return null;
        }

        @Override
        public Node item(int n) {
            Node node = null;
            if (n < this.m_node_count) {
                node = (Node)this.m_nodes.get(n);
            }
            return node;
        }

        @Override
        public int getLength() {
            return this.m_node_count;
        }

        @Override
        public Node getNamedItemNS(String string, String string2) throws DOMException {
            Node node = null;
            if (string2 != null) {
                for (int i = 0; node == null && i < this.m_node_count; ++i) {
                    Node node2 = (Node)this.m_nodes.get(i);
                    if (!string2.equals(node2.getLocalName())) continue;
                    String string3 = node2.getNamespaceURI();
                    if (string == null) {
                        if (string != string3) continue;
                        node = node2;
                        continue;
                    }
                    if (!string.equals(string3)) continue;
                    node = node2;
                }
            }
            return node;
        }

        @Override
        public Node setNamedItemNS(Node node) throws DOMException {
            return null;
        }

        @Override
        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            return null;
        }
    }
}

