/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import com.ibm.xml.jaxp.util.HashtableFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.utils.Utils;
import org.apache.xml.serializer.utils.WrappedRuntimeException;

public final class OutputPropertiesFactory {
    private static final String S_BUILTIN_EXTENSIONS_URL = "http://xml.apache.org/xalan";
    private static final String S_BUILTIN_OLD_EXTENSIONS_URL = "http://xml.apache.org/xslt";
    private static final String S_BUILTIN_XLTXE_EXTENSIONS_URL = "http://www.ibm.com/xmlns/prod/xltxe-j";
    private static final String[] s_xml_expected = new String[]{"method", "xml", "version", "1.0", "encoding", "UTF-8", "indent", "no", "omit-xml-declaration", "no", "standalone", "no", "media-type", "text/xml", "{http://xml.apache.org/xalan}indent-amount", "0", "{http://xml.apache.org/xalan}content-handler", "org.apache.xml.serializer.ToXMLStream", "{http://xml.apache.org/xalan}entities", "org/apache/xml/serializer/XMLEntities"};
    private static final String[] s_text_expected = new String[]{"method", "text", "media-type", "text/plain", "{http://xml.apache.org/xalan}content-handler", "org.apache.xml.serializer.ToTextStream"};
    private static final String[] s_html_expected = new String[]{"method", "html", "indent", "yes", "media-type", "text/html", "version", "4.0", "encoding", "UTF-8", "{http://xml.apache.org/xalan}indent-amount", "0", "{http://xml.apache.org/xalan}content-handler", "org.apache.xml.serializer.ToHTMLStream", "{http://xml.apache.org/xalan}entities", "org/apache/xml/serializer/HTMLEntities", "{http://xml.apache.org/xalan}use-url-escaping", "yes", "{http://xml.apache.org/xalan}omit-meta-tag", "no"};
    private static final String[] s_unknown_expected = new String[]{"method", "xml", "version", "1.0", "encoding", "UTF-8", "indent", "no", "omit-xml-declaration", "no", "standalone", "no", "media-type", "text/xml", "{http://xml.apache.org/xalan}indent-amount", "0", "{http://xml.apache.org/xalan}content-handler", "org.apache.xml.serializer.ToUnknownStream"};
    private static final String[] s_xhtml_expected = new String[]{"method", "xhtml", "indent", "yes", "media-type", "text/html", "version", "4.0", "encoding", "UTF-8", "omit-xml-declaration", "no", "standalone", "no", "{http://xml.apache.org/xalan}indent-amount", "0", "{http://xml.apache.org/xalan}content-handler", "org.apache.xml.serializer.ToXHTMLStream", "{http://xml.apache.org/xalan}entities", "org/apache/xml/serializer/XMLEntities", "{http://xml.apache.org/xalan}use-url-escaping", "yes", "{http://xml.apache.org/xalan}omit-meta-tag", "no"};
    public static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xalan}";
    public static final String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    public static final String S_KEY_LINE_SEPARATOR = "{http://xml.apache.org/xalan}line-separator";
    public static final String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xalan}content-handler";
    public static final String S_KEY_ENTITIES = "{http://xml.apache.org/xalan}entities";
    public static final String S_USE_URL_ESCAPING = "{http://xml.apache.org/xalan}use-url-escaping";
    public static final String S_OMIT_META_TAG = "{http://xml.apache.org/xalan}omit-meta-tag";
    public static final String S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    public static final int S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN = "{http://xml.apache.org/xslt}".length();
    public static final String S_BUILTIN_XLTXE_EXTENSIONS_UNIVERSAL = "{http://www.ibm.com/xmlns/prod/xltxe-j}";
    public static final int S_BUILTIN_XLTXE_EXTENSIONS_UNIVERSAL_LEN = "{http://www.ibm.com/xmlns/prod/xltxe-j}".length();
    private static final String S_XSLT_PREFIX = "xslt.output.";
    private static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    private static final String S_XALAN_PREFIX = "org.apache.xslt.";
    private static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    private static Integer m_synch_object = new Integer(1);
    private static final String PROP_DIR = SerializerBase.PKG_PATH + '/';
    private static final String PROP_FILE_XML = "output_xml.properties";
    private static final String PROP_FILE_TEXT = "output_text.properties";
    private static final String PROP_FILE_HTML = "output_html.properties";
    private static final String PROP_FILE_UNKNOWN = "output_unknown.properties";
    private static final String PROP_FILE_XHTML = "output_xhtml.properties";
    private static SerializerProps s_xml_properties = null;
    private static SerializerProps s_html_properties = null;
    private static SerializerProps s_text_properties = null;
    private static SerializerProps s_unknown_properties = null;
    private static Properties s_xhtml_properties = null;
    private static final Class ACCESS_CONTROLLER_CLASS = OutputPropertiesFactory.findAccessControllerClass();

    private static Class findAccessControllerClass() {
        try {
            return Class.forName("java.security.AccessController");
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Properties getDefaultMethodProperties(String string) {
        String string2 = null;
        Properties properties = null;
        try {
            Integer n = m_synch_object;
            synchronized (n) {
                if (null == s_xml_properties) {
                    string2 = PROP_FILE_XML;
                    s_xml_properties = OutputPropertiesFactory.loadPropertiesFile(string2, null);
                    boolean bl = OutputPropertiesFactory.hasExactlyGivenProperties(s_xml_properties, s_xml_expected);
                    s_xml_properties.setHasStandardDefaults(bl);
                }
            }
            if (string.equals("xml")) {
                properties = s_xml_properties;
            } else if (string.equals("html")) {
                if (null == s_html_properties) {
                    string2 = PROP_FILE_HTML;
                    s_html_properties = OutputPropertiesFactory.loadPropertiesFile(string2, s_xml_properties);
                    boolean bl = OutputPropertiesFactory.hasExactlyGivenProperties(s_html_properties, s_html_expected);
                    s_html_properties.setHasStandardDefaults(bl);
                }
                properties = s_html_properties;
            } else if (string.equals("xhtml")) {
                if (null == s_xhtml_properties) {
                    string2 = PROP_FILE_XHTML;
                    s_xhtml_properties = OutputPropertiesFactory.loadPropertiesFile(string2, s_xml_properties);
                }
                properties = s_xhtml_properties;
            } else if (string.equals("text")) {
                if (null == s_text_properties) {
                    string2 = PROP_FILE_TEXT;
                    s_text_properties = OutputPropertiesFactory.loadPropertiesFile(string2, s_xml_properties);
                    boolean bl = OutputPropertiesFactory.hasExactlyGivenProperties(s_text_properties, s_text_expected);
                    s_text_properties.setHasStandardDefaults(bl);
                    if (null == s_text_properties.getProperty("encoding")) {
                        String string3 = Encodings.getMimeEncoding(null);
                        s_text_properties.put("encoding", string3);
                    }
                }
                properties = s_text_properties;
            } else if (string.equals("")) {
                if (null == s_unknown_properties) {
                    string2 = PROP_FILE_UNKNOWN;
                    s_unknown_properties = OutputPropertiesFactory.loadPropertiesFile(string2, s_xml_properties);
                    boolean bl = OutputPropertiesFactory.hasExactlyGivenProperties(s_unknown_properties, s_unknown_expected);
                    s_unknown_properties.setHasStandardDefaults(bl);
                }
                properties = s_unknown_properties;
            } else {
                properties = s_xml_properties;
            }
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(Utils.messages.createMessage("ER_COULD_NOT_LOAD_METHOD_PROPERTY", new Object[]{string2, string}), iOException);
        }
        return new SerializerProps(properties);
    }

    private static SerializerProps loadPropertiesFile(final String string, Properties properties) throws IOException {
        SerializerProps serializerProps = new SerializerProps(properties);
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            inputStream = ACCESS_CONTROLLER_CLASS != null ? (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return OutputPropertiesFactory.class.getResourceAsStream(string);
                }
            }) : OutputPropertiesFactory.class.getResourceAsStream(string);
            bufferedInputStream = new BufferedInputStream(inputStream);
            serializerProps.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            if (properties == null) {
                throw iOException;
            }
            throw new WrappedRuntimeException(Utils.messages.createMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), iOException);
        }
        catch (SecurityException securityException) {
            if (properties == null) {
                throw securityException;
            }
            throw new WrappedRuntimeException(Utils.messages.createMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), securityException);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        Object object = serializerProps.clone();
        Enumeration<Object> enumeration = ((Properties)object).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = null;
            try {
                string3 = System.getProperty(string2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string3 == null) {
                string3 = (String)serializerProps.get(string2);
            }
            String string4 = OutputPropertiesFactory.fixupPropertyString(string2, true);
            String string5 = null;
            try {
                string5 = System.getProperty(string4);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string5 = string5 == null ? OutputPropertiesFactory.fixupPropertyString(string3, false) : OutputPropertiesFactory.fixupPropertyString(string5, false);
            if (string2 == string4 && string3 == string5) continue;
            serializerProps.remove(string2);
            serializerProps.put(string4, string5);
        }
        return serializerProps;
    }

    private static String fixupPropertyString(String string, boolean bl) {
        int n;
        if (bl && string.startsWith(S_XSLT_PREFIX)) {
            string = string.substring(S_XSLT_PREFIX_LEN);
        }
        if (string.startsWith(S_XALAN_PREFIX)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_XALAN_PREFIX_LEN);
        }
        if ((n = string.indexOf("\\u003a")) > 0) {
            String string2 = string.substring(n + 6);
            string = string.substring(0, n) + ":" + string2;
        }
        return string;
    }

    private static boolean hasExactlyGivenProperties(Properties properties, String[] stringArray) {
        boolean bl = true;
        Enumeration<Object> enumeration = properties.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        int n2 = stringArray.length;
        if (n * 2 != n2) {
            bl = false;
        } else {
            int n3 = n2 - 1;
            for (int i = 0; i < n3 && bl; i += 2) {
                String string = stringArray[i + 1];
                String string2 = stringArray[i];
                String string3 = properties.getProperty(string2);
                if (string.equals(string3)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static class SerializerProps
    extends Properties {
        private Hashtable m_htable2;
        private final Properties m_defaults;
        boolean m_hasOnlyStandardDefaults;
        private static final long serialVersionUID = 1145778903354235522L;

        private Hashtable getHashtable() {
            if (this.m_htable2 == null) {
                this.m_htable2 = HashtableFactory.newHashtable();
            }
            return this.m_htable2;
        }

        SerializerProps() {
            this.m_defaults = null;
        }

        public SerializerProps(Properties properties) {
            this.m_defaults = properties;
            if (properties instanceof SerializerProps) {
                boolean bl;
                SerializerProps serializerProps = (SerializerProps)properties;
                this.m_hasOnlyStandardDefaults = bl = serializerProps.hasOnlyStandardDefaults();
            }
        }

        boolean hasOnlyStandardDefaults() {
            return this.m_hasOnlyStandardDefaults;
        }

        boolean setHasStandardDefaults(boolean bl) {
            boolean bl2 = this.m_hasOnlyStandardDefaults;
            this.m_hasOnlyStandardDefaults = bl;
            return bl2;
        }

        @Override
        public int size() {
            return this.getHashtable().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getHashtable().isEmpty();
        }

        @Override
        public synchronized Enumeration keys() {
            return this.getHashtable().keys();
        }

        @Override
        public synchronized Enumeration elements() {
            return this.getHashtable().elements();
        }

        @Override
        public synchronized boolean contains(Object object) {
            return this.getHashtable().contains(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.getHashtable().containsValue(object);
        }

        @Override
        public synchronized boolean containsKey(Object object) {
            return this.getHashtable().containsKey(object);
        }

        @Override
        public synchronized Object get(Object object) {
            return this.getHashtable().get(object);
        }

        @Override
        public synchronized Object put(Object object, Object object2) {
            if (this.m_defaults != null) {
                if (object instanceof String) {
                    String string = this.m_defaults.getProperty((String)object);
                    if (!object2.equals(string)) {
                        this.m_hasOnlyStandardDefaults = false;
                    }
                } else {
                    Object object3 = this.m_defaults.get(object);
                    if (!object2.equals(object3)) {
                        this.m_hasOnlyStandardDefaults = false;
                    }
                }
            } else {
                this.m_hasOnlyStandardDefaults = false;
            }
            return this.getHashtable().put(object, object2);
        }

        @Override
        public synchronized Object remove(Object object) {
            return this.getHashtable().remove(object);
        }

        @Override
        public synchronized void putAll(Map map) {
            this.getHashtable().putAll(map);
        }

        @Override
        public synchronized void clear() {
            this.getHashtable().clear();
        }

        @Override
        public synchronized Object clone() {
            Hashtable hashtable = null;
            if (this.m_htable2 != null) {
                hashtable = (Hashtable)this.m_htable2.clone();
            }
            Properties properties = null;
            if (this.m_defaults != null) {
                properties = (Properties)this.m_defaults.clone();
            }
            SerializerProps serializerProps = properties == null ? new SerializerProps() : new SerializerProps(properties);
            serializerProps.m_htable2 = hashtable;
            serializerProps.m_hasOnlyStandardDefaults = this.m_hasOnlyStandardDefaults;
            return serializerProps;
        }

        @Override
        public synchronized String toString() {
            return this.getHashtable().toString();
        }

        @Override
        public Set keySet() {
            return this.getHashtable().keySet();
        }

        @Override
        public Set entrySet() {
            return this.getHashtable().entrySet();
        }

        @Override
        public Collection values() {
            return this.getHashtable().values();
        }

        @Override
        public synchronized boolean equals(Object object) {
            return this.getHashtable().equals(object);
        }

        @Override
        public synchronized int hashCode() {
            return this.getHashtable().hashCode();
        }

        @Override
        public synchronized Object setProperty(String string, String string2) {
            return this.put(string, string2);
        }

        @Override
        public synchronized void load(InputStream inputStream) throws IOException {
            Properties properties = new Properties();
            properties.load(inputStream);
            SerializerProps.propsIntoHashtable(properties, this.getHashtable());
        }

        private static void propsIntoHashtable(Properties properties, Hashtable hashtable) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = properties.get(object);
                hashtable.put(object, object2);
            }
        }

        private void hashtableIntoProps(Hashtable hashtable, Properties properties) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object object = properties.get(k);
                properties.put(k, object);
            }
        }

        @Override
        public synchronized void save(OutputStream outputStream, String string) {
            Properties properties = new Properties();
            this.hashtableIntoProps(this.getHashtable(), properties);
            try {
                properties.store(outputStream, string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void store(OutputStream outputStream, String string) throws IOException {
            Properties properties = new Properties();
            this.hashtableIntoProps(this.getHashtable(), properties);
            properties.store(outputStream, string);
        }

        @Override
        public String getProperty(String string) {
            Object v = this.getHashtable().get(string);
            if (v instanceof String) {
                return (String)v;
            }
            if (this.m_defaults != null) {
                return this.m_defaults.getProperty(string);
            }
            return null;
        }

        @Override
        public String getProperty(String string, String string2) {
            String string3 = this.getProperty(string);
            return string3 == null ? string2 : string3;
        }

        public Enumeration propertyNames() {
            Object object;
            Enumeration<Object> enumeration;
            Hashtable hashtable = HashtableFactory.newHashtable();
            if (this.m_defaults != null) {
                enumeration = this.m_defaults.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    hashtable.put(object, object);
                }
            }
            if (this.m_htable2 != null) {
                enumeration = this.m_htable2.keys();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    hashtable.put(object, object);
                }
            }
            return hashtable.keys();
        }
    }
}

