/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import com.ibm.xml.jaxp.util.HashtableFactory;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.TemplateSubPatternAssociation;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.QName;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;

public class TemplateList
implements Serializable {
    static final long serialVersionUID = 5803675288911728791L;
    static final boolean DEBUG = false;
    private Hashtable m_namedTemplates = HashtableFactory.newHashtable(89);
    private Hashtable m_patternTable = HashtableFactory.newHashtable(89);
    private TemplateSubPatternAssociation m_wildCardPatterns = null;
    private TemplateSubPatternAssociation m_textPatterns = null;
    private TemplateSubPatternAssociation m_docPatterns = null;
    private TemplateSubPatternAssociation m_commentPatterns = null;

    public void setTemplate(ElemTemplate elemTemplate) {
        ExpressionNode expressionNode;
        XPath xPath = elemTemplate.getMatch();
        if (null == elemTemplate.getName() && null == xPath) {
            elemTemplate.error("ER_NEED_NAME_OR_MATCH_ATTRIB", new Object[]{"xsl:template"});
        }
        if (null != elemTemplate.getName()) {
            expressionNode = (ElemTemplate)this.m_namedTemplates.get(elemTemplate.getName());
            if (null == expressionNode) {
                this.m_namedTemplates.put(elemTemplate.getName(), elemTemplate);
            } else {
                int n = ((ElemTemplate)expressionNode).getStylesheetComposed().getImportCountComposed();
                int n2 = elemTemplate.getStylesheetComposed().getImportCountComposed();
                if (n2 > n) {
                    this.m_namedTemplates.put(elemTemplate.getName(), elemTemplate);
                } else if (n2 == n) {
                    elemTemplate.error("ER_DUPLICATE_NAMED_TEMPLATE", new Object[]{elemTemplate.getName()});
                }
            }
        }
        if (null != xPath) {
            expressionNode = xPath.getExpression();
            if (expressionNode instanceof StepPattern) {
                this.insertPatternInTable((StepPattern)expressionNode, elemTemplate);
            } else if (expressionNode instanceof UnionPattern) {
                UnionPattern unionPattern = (UnionPattern)expressionNode;
                StepPattern[] stepPatternArray = unionPattern.getPatterns();
                int n = stepPatternArray.length;
                for (int i = 0; i < n; ++i) {
                    this.insertPatternInTable(stepPatternArray[i], elemTemplate);
                }
            }
        }
    }

    void dumpAssociationTables() {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        Enumeration enumeration = this.m_patternTable.elements();
        while (enumeration.hasMoreElements()) {
            for (templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement(); null != templateSubPatternAssociation; templateSubPatternAssociation = templateSubPatternAssociation.getNext()) {
                System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
            }
            System.out.println("\n.....");
        }
        System.out.print("wild card list: ");
        for (templateSubPatternAssociation = this.m_wildCardPatterns; null != templateSubPatternAssociation; templateSubPatternAssociation = templateSubPatternAssociation.getNext()) {
            System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
        }
        System.out.println("\n.....");
    }

    public void compose(StylesheetRoot stylesheetRoot) {
        if (null != this.m_wildCardPatterns) {
            Enumeration enumeration = this.m_patternTable.elements();
            while (enumeration.hasMoreElements()) {
                TemplateSubPatternAssociation templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement();
                for (TemplateSubPatternAssociation templateSubPatternAssociation2 = this.m_wildCardPatterns; null != templateSubPatternAssociation2; templateSubPatternAssociation2 = templateSubPatternAssociation2.getNext()) {
                    try {
                        templateSubPatternAssociation = this.insertAssociationIntoList(templateSubPatternAssociation, (TemplateSubPatternAssociation)templateSubPatternAssociation2.clone(), true);
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private TemplateSubPatternAssociation insertAssociationIntoList(TemplateSubPatternAssociation templateSubPatternAssociation, TemplateSubPatternAssociation templateSubPatternAssociation2, boolean bl) {
        boolean bl2;
        double d;
        TemplateSubPatternAssociation templateSubPatternAssociation3;
        double d2 = this.getPriorityOrScore(templateSubPatternAssociation2);
        int n = templateSubPatternAssociation2.getImportLevel();
        int n2 = templateSubPatternAssociation2.getDocOrderPos();
        TemplateSubPatternAssociation templateSubPatternAssociation4 = templateSubPatternAssociation;
        while (null != (templateSubPatternAssociation3 = templateSubPatternAssociation4.getNext())) {
            d = this.getPriorityOrScore(templateSubPatternAssociation3);
            if (n > templateSubPatternAssociation3.getImportLevel()) break;
            if (n < templateSubPatternAssociation3.getImportLevel()) {
                templateSubPatternAssociation4 = templateSubPatternAssociation3;
                continue;
            }
            if (d2 > d) break;
            if (d2 < d) {
                templateSubPatternAssociation4 = templateSubPatternAssociation3;
                continue;
            }
            if (n2 >= templateSubPatternAssociation3.getDocOrderPos()) break;
            templateSubPatternAssociation4 = templateSubPatternAssociation3;
        }
        if (null == templateSubPatternAssociation3 || templateSubPatternAssociation4 == templateSubPatternAssociation) {
            d = this.getPriorityOrScore(templateSubPatternAssociation4);
            bl2 = n > templateSubPatternAssociation4.getImportLevel() ? true : (n < templateSubPatternAssociation4.getImportLevel() ? false : (d2 > d ? true : (d2 < d ? false : n2 >= templateSubPatternAssociation4.getDocOrderPos())));
        } else {
            bl2 = false;
        }
        if (bl) {
            if (bl2) {
                templateSubPatternAssociation2.setNext(templateSubPatternAssociation4);
                String string = templateSubPatternAssociation4.getTargetString();
                templateSubPatternAssociation2.setTargetString(string);
                this.putHead(string, templateSubPatternAssociation2);
                return templateSubPatternAssociation2;
            }
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
            templateSubPatternAssociation4.setNext(templateSubPatternAssociation2);
            return templateSubPatternAssociation;
        }
        if (bl2) {
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation4);
            if (templateSubPatternAssociation4.isWild() || templateSubPatternAssociation2.isWild()) {
                this.m_wildCardPatterns = templateSubPatternAssociation2;
            } else {
                this.putHead(templateSubPatternAssociation2.getTargetString(), templateSubPatternAssociation2);
            }
            return templateSubPatternAssociation2;
        }
        templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
        templateSubPatternAssociation4.setNext(templateSubPatternAssociation2);
        return templateSubPatternAssociation;
    }

    private void insertPatternInTable(StepPattern stepPattern, ElemTemplate elemTemplate) {
        String string = stepPattern.getTargetString();
        if (null != string) {
            TemplateSubPatternAssociation templateSubPatternAssociation;
            String string2 = elemTemplate.getMatch().getPatternString();
            TemplateSubPatternAssociation templateSubPatternAssociation2 = new TemplateSubPatternAssociation(elemTemplate, stepPattern, string2);
            boolean bl = templateSubPatternAssociation2.isWild();
            TemplateSubPatternAssociation templateSubPatternAssociation3 = templateSubPatternAssociation = bl ? this.m_wildCardPatterns : this.getHead(string);
            if (null == templateSubPatternAssociation) {
                if (bl) {
                    this.m_wildCardPatterns = templateSubPatternAssociation2;
                } else {
                    this.putHead(string, templateSubPatternAssociation2);
                }
            } else {
                this.insertAssociationIntoList(templateSubPatternAssociation, templateSubPatternAssociation2, false);
            }
        }
    }

    private double getPriorityOrScore(TemplateSubPatternAssociation templateSubPatternAssociation) {
        StepPattern stepPattern;
        double d = templateSubPatternAssociation.getTemplate().getPriority();
        if (d == Double.NEGATIVE_INFINITY && (stepPattern = templateSubPatternAssociation.getStepPattern()) instanceof NodeTest) {
            return ((NodeTest)stepPattern).getDefaultScore();
        }
        return d;
    }

    public ElemTemplate getTemplate(QName qName) {
        return (ElemTemplate)this.m_namedTemplates.get(qName);
    }

    public TemplateSubPatternAssociation getHead(XPathContext xPathContext, int n, DTM dTM) {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        short s = dTM.getNodeType(n);
        switch (s) {
            case 1: 
            case 2: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalName(n));
                break;
            }
            case 3: 
            case 4: {
                templateSubPatternAssociation = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n));
                break;
            }
            case 7: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalName(n));
                break;
            }
            case 8: {
                templateSubPatternAssociation = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                templateSubPatternAssociation = this.m_docPatterns;
                break;
            }
            default: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n));
            }
        }
        return null == templateSubPatternAssociation ? this.m_wildCardPatterns : templateSubPatternAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElemTemplate getTemplateFast(XPathContext xPathContext, int n, int n2, QName qName, int n3, boolean bl, DTM dTM) throws TransformerException {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        switch (dTM.getNodeType(n)) {
            case 1: 
            case 2: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalNameFromExpandedNameID(n2));
                break;
            }
            case 3: 
            case 4: {
                templateSubPatternAssociation = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n));
                break;
            }
            case 7: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalName(n));
                break;
            }
            case 8: {
                templateSubPatternAssociation = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                templateSubPatternAssociation = this.m_docPatterns;
                break;
            }
            default: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n));
            }
        }
        if (null == templateSubPatternAssociation && null == (templateSubPatternAssociation = this.m_wildCardPatterns)) {
            return null;
        }
        xPathContext.pushNamespaceContextNull();
        try {
            do {
                if (n3 > -1 && templateSubPatternAssociation.getImportLevel() > n3) continue;
                ElemTemplate elemTemplate = templateSubPatternAssociation.getTemplate();
                xPathContext.setNamespaceContext(elemTemplate);
                if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext, n, dTM, n2) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                if (bl) {
                    this.checkConflicts(templateSubPatternAssociation, xPathContext, n, qName);
                }
                ElemTemplate elemTemplate2 = elemTemplate;
                return elemTemplate2;
            } while (null != (templateSubPatternAssociation = templateSubPatternAssociation.getNext()));
        }
        finally {
            xPathContext.popNamespaceContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElemTemplate getTemplate(XPathContext xPathContext, int n, QName qName, boolean bl, DTM dTM) throws TransformerException {
        TemplateSubPatternAssociation templateSubPatternAssociation = this.getHead(xPathContext, n, dTM);
        if (null != templateSubPatternAssociation) {
            xPathContext.pushNamespaceContextNull();
            xPathContext.pushCurrentNodeAndExpression(n, n);
            try {
                do {
                    ElemTemplate elemTemplate = templateSubPatternAssociation.getTemplate();
                    xPathContext.setNamespaceContext(elemTemplate);
                    if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext, n) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                    if (bl) {
                        this.checkConflicts(templateSubPatternAssociation, xPathContext, n, qName);
                    }
                    ElemTemplate elemTemplate2 = elemTemplate;
                    return elemTemplate2;
                } while (null != (templateSubPatternAssociation = templateSubPatternAssociation.getNext()));
            }
            finally {
                xPathContext.popCurrentNodeAndExpression();
                xPathContext.popNamespaceContext();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElemTemplate getTemplate(XPathContext xPathContext, int n, QName qName, int n2, int n3, boolean bl, DTM dTM) throws TransformerException {
        TemplateSubPatternAssociation templateSubPatternAssociation = this.getHead(xPathContext, n, dTM);
        if (null != templateSubPatternAssociation) {
            xPathContext.pushNamespaceContextNull();
            xPathContext.pushCurrentNodeAndExpression(n, n);
            try {
                do {
                    ElemTemplate elemTemplate;
                    if (n2 > -1 && templateSubPatternAssociation.getImportLevel() > n2) continue;
                    if (templateSubPatternAssociation.getImportLevel() <= n2 - n3) {
                        elemTemplate = null;
                        return elemTemplate;
                    }
                    elemTemplate = templateSubPatternAssociation.getTemplate();
                    xPathContext.setNamespaceContext(elemTemplate);
                    if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext, n) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                    if (bl) {
                        this.checkConflicts(templateSubPatternAssociation, xPathContext, n, qName);
                    }
                    ElemTemplate elemTemplate2 = elemTemplate;
                    return elemTemplate2;
                } while (null != (templateSubPatternAssociation = templateSubPatternAssociation.getNext()));
            }
            finally {
                xPathContext.popCurrentNodeAndExpression();
                xPathContext.popNamespaceContext();
            }
        }
        return null;
    }

    public TemplateWalker getWalker() {
        return new TemplateWalker();
    }

    private void checkConflicts(TemplateSubPatternAssociation templateSubPatternAssociation, XPathContext xPathContext, int n, QName qName) {
    }

    private void addObjectIfNotFound(Object object, Vector vector) {
        int n = vector.size();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (vector.elementAt(i) != object) continue;
            bl = false;
            break;
        }
        if (bl) {
            vector.addElement(object);
        }
    }

    private Hashtable getNamedTemplates() {
        return this.m_namedTemplates;
    }

    private void setNamedTemplates(Hashtable hashtable) {
        this.m_namedTemplates = hashtable;
    }

    private TemplateSubPatternAssociation getHead(String string) {
        return (TemplateSubPatternAssociation)this.m_patternTable.get(string);
    }

    private void putHead(String string, TemplateSubPatternAssociation templateSubPatternAssociation) {
        if (string.equals("#text")) {
            this.m_textPatterns = templateSubPatternAssociation;
        } else if (string.equals("/")) {
            this.m_docPatterns = templateSubPatternAssociation;
        } else if (string.equals("#comment")) {
            this.m_commentPatterns = templateSubPatternAssociation;
        }
        this.m_patternTable.put(string, templateSubPatternAssociation);
    }

    public class TemplateWalker {
        private Enumeration hashIterator;
        private boolean inPatterns;
        private TemplateSubPatternAssociation curPattern;
        private Hashtable m_compilerCache = HashtableFactory.newHashtable();

        private TemplateWalker() {
            this.hashIterator = TemplateList.this.m_patternTable.elements();
            this.inPatterns = true;
            this.curPattern = null;
        }

        public ElemTemplate next() {
            ElemTemplate elemTemplate;
            ElemTemplateElement elemTemplateElement = null;
            do {
                if (this.inPatterns) {
                    if (null != this.curPattern) {
                        this.curPattern = this.curPattern.getNext();
                    }
                    if (null != this.curPattern) {
                        elemTemplateElement = this.curPattern.getTemplate();
                    } else if (this.hashIterator.hasMoreElements()) {
                        this.curPattern = (TemplateSubPatternAssociation)this.hashIterator.nextElement();
                        elemTemplateElement = this.curPattern.getTemplate();
                    } else {
                        this.inPatterns = false;
                        this.hashIterator = TemplateList.this.m_namedTemplates.elements();
                    }
                }
                if (this.inPatterns) continue;
                if (this.hashIterator.hasMoreElements()) {
                    elemTemplateElement = (ElemTemplate)this.hashIterator.nextElement();
                    continue;
                }
                return null;
            } while (null != (elemTemplate = (ElemTemplate)this.m_compilerCache.get(new Integer(elemTemplateElement.getUid()))));
            this.m_compilerCache.put(new Integer(elemTemplateElement.getUid()), elemTemplateElement);
            return elemTemplateElement;
        }
    }
}

