/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.Constants;
import com.ibm.xtq.bcel.generic.ClassGenException;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.generic.TypeConstants;

public final class BasicType
extends Type {
    BasicType(byte type) {
        super(type, Constants.SHORT_TYPE_NAMES[type]);
        if (type < 4 || type > 12) {
            throw new ClassGenException("Invalid type: " + type);
        }
    }

    public static final BasicType getType(byte type) {
        switch (type) {
            case 12: {
                return TypeConstants.VOID;
            }
            case 4: {
                return TypeConstants.BOOLEAN;
            }
            case 8: {
                return TypeConstants.BYTE;
            }
            case 9: {
                return TypeConstants.SHORT;
            }
            case 5: {
                return TypeConstants.CHAR;
            }
            case 10: {
                return TypeConstants.INT;
            }
            case 11: {
                return TypeConstants.LONG;
            }
            case 7: {
                return TypeConstants.DOUBLE;
            }
            case 6: {
                return TypeConstants.FLOAT;
            }
        }
        throw new ClassGenException("Invalid type: " + type);
    }

    public boolean equals(Object type) {
        return type instanceof BasicType ? ((BasicType)type).type == this.type : false;
    }
}

