/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.sax.impl;

import com.ibm.xml.xlxp.api.sax.impl.SAX2ParserCallbacks;
import com.ibm.xml.xlxp.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp.api.util.SymbolStringMappings;
import com.ibm.xml.xlxp.scan.DTDScanner;
import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.util.DTDParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;

public class SAX2DTDScanner
extends DTDScanner {
    private SAX2ParserCallbacks fParser;
    protected SymbolStringMappings fSymbolStringMappings;
    private XMLStringBuffer fStringBuffer;
    private int fEnumerationStartOffset;
    private XMLString fEnumeration;
    private boolean fSeenEnumeration;
    private boolean fDuplicateAttDef;
    private DTDHandler fDTDHandler;
    private DeclHandler fDeclHandler;
    private XMLString fTempString;

    public SAX2DTDScanner(DTDScannerHelper dTDScannerHelper, DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, SymbolTable symbolTable, DTDParsedEntityFactory dTDParsedEntityFactory, SAX2ParserCallbacks sAX2ParserCallbacks, SymbolStringMappings symbolStringMappings) {
        super(dTDScannerHelper, documentEntityScanner, dataBufferFactory, symbolTable, dTDParsedEntityFactory);
        this.fParser = sAX2ParserCallbacks;
        this.fSymbolStringMappings = symbolStringMappings;
        this.fStringBuffer = new XMLStringBuffer(dataBufferFactory);
        this.fEnumeration = new XMLString();
        this.fTempString = new XMLString();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.fDeclHandler = declHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.fDeclHandler;
    }

    @Override
    protected void nextStateProlog() {
        super.nextStateProlog();
        this.fParser.endDTD();
    }

    @Override
    protected boolean extSubsetPEReference(XMLString xMLString) {
        this.fParser.startPE(xMLString);
        boolean bl = super.extSubsetPEReference(xMLString);
        this.fParser.endPE(xMLString);
        return bl;
    }

    @Override
    protected boolean intSubsetPEReference(XMLString xMLString) {
        this.fParser.startPE(xMLString);
        boolean bl = super.intSubsetPEReference(xMLString);
        this.fParser.endPE(xMLString);
        return bl;
    }

    @Override
    protected boolean scanExternalSubset1() {
        this.fParser.startDTDEntity();
        boolean bl = super.scanExternalSubset1();
        this.fParser.endDTDEntity();
        return bl;
    }

    @Override
    protected boolean skippedExternalSubsetEntity() {
        return this.fParser.skippedExternalSubsetEntity();
    }

    @Override
    protected void endElementDecl() {
        super.endElementDecl();
        if (this.fDeclHandler != null) {
            try {
                this.fDeclHandler.elementDecl(this.fSymbolStringMappings.toString(this.fDeclElementType.handle), this.fContentModel.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    @Override
    protected void startEnumerationType() {
        super.startEnumerationType();
        this.fEnumerationStartOffset = this.fStringBuffer.getOffset();
        if (this.fDeclAttType != null) {
            this.fStringBuffer.appendString("NOTATION");
            this.fStringBuffer.appendChar(32);
        }
        this.fStringBuffer.appendChar(40);
        this.fSeenEnumeration = false;
    }

    @Override
    protected void enumerationType(XMLString xMLString) {
        super.enumerationType(xMLString);
        if (this.fSeenEnumeration) {
            this.fStringBuffer.appendChar(124);
        } else {
            this.fSeenEnumeration = true;
        }
        this.fStringBuffer.appendXMLString(xMLString);
    }

    @Override
    protected void endEnumerationType() {
        super.endEnumerationType();
        this.fStringBuffer.appendChar(41);
        this.fStringBuffer.setStringValues(this.fEnumerationStartOffset, this.fStringBuffer.getOffset(), this.fEnumeration);
    }

    @Override
    protected void duplicateAttDef(QName qName, QName qName2) {
        this.fDuplicateAttDef = true;
        super.duplicateAttDef(qName, qName2);
    }

    @Override
    protected void endAttDef(XMLString xMLString) {
        this.fDuplicateAttDef = false;
        super.endAttDef(xMLString);
        if (!this.fDuplicateAttDef && this.fDeclHandler != null) {
            QName qName = this.fDeclElementType;
            QName qName2 = this.fDeclAttrName;
            XMLString xMLString2 = this.fDeclAttType;
            XMLString xMLString3 = this.fSeenEnumeration ? this.fEnumeration : xMLString2;
            int n = this.fDTDGrammar.lookupAttDef(qName, qName2);
            XMLString xMLString4 = n != -1 ? this.fDTDGrammar.attDefAttValue(n) : null;
            try {
                this.fDeclHandler.attributeDecl(this.fSymbolStringMappings.toString(qName.handle), this.fSymbolStringMappings.toString(qName2.handle), xMLString3.toString(), xMLString == null ? null : xMLString.toString(), xMLString4 == null ? null : xMLString4.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    @Override
    protected void internalEntityDecl(XMLString xMLString) {
        if (this.fDeclHandler == null) {
            super.internalEntityDecl(xMLString);
        } else {
            int n = this.fEntityDeclPool.lookupEntity(this.fSymbolTable.addSymbol(xMLString));
            super.internalEntityDecl(xMLString);
            if (n == -1) {
                try {
                    this.fDeclHandler.internalEntityDecl(xMLString.toString(), this.fInternalEntityValue.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    @Override
    protected void externalEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        if (this.fDeclHandler == null) {
            super.externalEntityDecl(xMLString, xMLString2, xMLString3);
        } else {
            int n = this.fEntityDeclPool.lookupEntity(this.fSymbolTable.addSymbol(xMLString));
            super.externalEntityDecl(xMLString, xMLString2, xMLString3);
            if (n == -1) {
                try {
                    this.fDeclHandler.externalEntityDecl(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    @Override
    protected void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
        if (this.fDTDHandler == null) {
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
        } else {
            int n = this.fEntityDeclPool.lookupEntity(this.fSymbolTable.addSymbol(xMLString));
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
            if (n == -1) {
                try {
                    this.fDTDHandler.unparsedEntityDecl(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString(), xMLString4.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    @Override
    protected void internalPEDecl(XMLString xMLString) {
        if (this.fDeclHandler == null) {
            super.internalPEDecl(xMLString);
        } else {
            int n = this.fEntityDeclPool.lookupPE(this.fSymbolTable.addSymbol(xMLString));
            super.internalPEDecl(xMLString);
            if (n == -1) {
                int n2 = this.fStringBuffer.getOffset();
                this.fStringBuffer.appendChar(37);
                this.fStringBuffer.appendXMLString(xMLString);
                this.fStringBuffer.setStringValues(n2, this.fStringBuffer.getOffset(), this.fTempString);
                try {
                    this.fDeclHandler.internalEntityDecl(this.fTempString.toString(), this.fInternalEntityValue.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    @Override
    protected void externalPEDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        if (this.fDeclHandler == null) {
            super.externalPEDecl(xMLString, xMLString2, xMLString3);
        } else {
            int n = this.fEntityDeclPool.lookupPE(this.fSymbolTable.addSymbol(xMLString));
            super.externalPEDecl(xMLString, xMLString2, xMLString3);
            if (n == -1) {
                int n2 = this.fStringBuffer.getOffset();
                this.fStringBuffer.appendChar(37);
                this.fStringBuffer.appendXMLString(xMLString);
                this.fStringBuffer.setStringValues(n2, this.fStringBuffer.getOffset(), this.fTempString);
                try {
                    this.fDeclHandler.externalEntityDecl(this.fTempString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString());
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
        }
    }

    @Override
    protected void notationDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        super.notationDecl(xMLString, xMLString2, xMLString3);
        if (this.fDTDHandler != null) {
            try {
                this.fDTDHandler.notationDecl(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3 == null ? null : xMLString3.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    @Override
    protected boolean processingInstructionInDTD(XMLString xMLString, XMLString xMLString2) {
        this.fParser.processingInstructionInDTD(xMLString, xMLString2);
        return super.processingInstructionInDTD(xMLString, xMLString2);
    }

    @Override
    protected boolean commentInDTD(XMLString xMLString) {
        this.fParser.commentInDTD(xMLString);
        return super.commentInDTD(xMLString);
    }
}

