/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.ReasonFlags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class DistributionPoint {
    private DistributionPointName dpName = null;
    private ReasonFlags reasons = null;
    private GeneralNames issuer = null;
    private byte TAG_DPNAME = 0;
    private byte TAG_REASONS = 1;
    private byte TAG_ISSUER = (byte)2;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.DistributionPoint";
    private volatile int cachedHashVal = 0;

    public DistributionPoint(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DistributionPoint", (Object)der);
        }
        this.decode(new DerValue(der));
        if (debug != null) {
            debug.exit(16384L, className, "DistributionPoint");
        }
    }

    public DistributionPoint(DistributionPointName distributionPoint, ReasonFlags reasons, GeneralNames cRLIssuer) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{distributionPoint, reasons, cRLIssuer};
            debug.entry(16384L, (Object)className, "DistributionPoint", parms);
        }
        if (distributionPoint != null) {
            this.dpName = distributionPoint instanceof GeneralNames ? (GeneralNames)((GeneralNames)distributionPoint).clone() : distributionPoint;
        }
        if (reasons != null) {
            DerOutputStream derout = new DerOutputStream();
            reasons.encode(derout);
            DerInputStream derin = new DerInputStream(derout.toByteArray());
            this.reasons = new ReasonFlags(derin);
        }
        if (cRLIssuer != null) {
            this.issuer = (GeneralNames)cRLIssuer.clone();
        }
        if (debug != null) {
            debug.exit(16384L, className, "DistributionPoint");
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        ByteArrayOutputStream tmpout = new ByteArrayOutputStream();
        DerOutputStream tmp1 = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        if (this.dpName != null) {
            this.dpName.encode(tmpout);
            tmp1.write(tmpout.toByteArray());
            if (this.dpName instanceof GeneralNames) {
                tmp2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmp1);
            } else {
                tmp2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp1);
            }
            bytes.write(DerValue.createTag((byte)-128, true, this.TAG_DPNAME), tmp2);
        }
        if (this.reasons != null) {
            tmp1 = new DerOutputStream();
            this.reasons.encode(tmp1);
            bytes.writeImplicit(DerValue.createTag((byte)-128, false, this.TAG_REASONS), tmp1);
        }
        if (this.issuer != null) {
            tmpout = new ByteArrayOutputStream();
            tmp1 = new DerOutputStream();
            this.issuer.encode(tmpout);
            tmp1.write(tmpout.toByteArray());
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, this.TAG_ISSUER), tmp1);
        }
        tmp1 = new DerOutputStream();
        tmp1.write((byte)48, bytes);
        out.write(tmp1.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof DistributionPoint)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((DistributionPoint)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e2);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "";
        out = out + "\nDistribution Point: [";
        out = this.dpName == null ? out + "\r\n\tDistribution Point Name: null" : out + "\r\n\tDistribution Point Name: " + this.dpName.toString();
        out = this.reasons == null ? out + "\r\n\tReason Flags: null" : out + "\r\n\t" + this.reasons.toString();
        out = this.issuer == null ? out + "\r\n\tIssuer: null" : out + "\r\n\tIssuer: " + this.issuer.toString() + "\n";
        out = out + "\n]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public DistributionPointName getName() throws IOException, GeneralNamesException {
        DistributionPointName retval = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        if (this.dpName == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getName_1", null);
            }
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.dpName.encode(out);
        if (this.dpName instanceof GeneralNames) {
            retval = new GeneralNames(new DerValue(out.toByteArray()));
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getName_2", retval);
            }
            return retval;
        }
        retval = new RDN(new DerValue(out.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName_3", retval);
        }
        return retval;
    }

    public ReasonFlags getReasons() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getReasons");
        }
        if (this.reasons == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getReasons_1", null);
            }
            return null;
        }
        DerOutputStream out = new DerOutputStream();
        this.reasons.encode(out);
        ReasonFlags result = new ReasonFlags(new DerValue(out.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getReasons_2", result);
        }
        return result;
    }

    public GeneralNames getIssuer() throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuer");
        }
        if (this.issuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuer_1", null);
            }
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.issuer.encode(out);
        GeneralNames result = new GeneralNames(new DerValue(out.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIssuer_2", result);
        }
        return result;
    }

    void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DistributionPoint parsing error: not a SEQUENCE.");
            }
            throw new IOException("DistributionPoint parsing error: not a SEQUENCE.");
        }
        if (encoding.getData().available() == 0) {
            return;
        }
        DerValue derVal = encoding.getData().getDerValue();
        if (derVal.isContextSpecific(this.TAG_DPNAME) && derVal.isConstructed()) {
            DerValue derVal2 = derVal.getData().getDerValue();
            if (derVal2.isContextSpecific((byte)0) && derVal2.isConstructed()) {
                derVal2.resetTag((byte)48);
                try {
                    this.dpName = new GeneralNames(derVal2);
                }
                catch (GeneralNamesException e2) {
                    if (debug != null) {
                        debug.text(16384L, className, "decode", "Error constructing distribution point name.");
                    }
                    throw new IOException("Error constructing distribution point name.");
                }
            } else if (derVal2.isContextSpecific((byte)1) && derVal2.isConstructed()) {
                derVal2.resetTag((byte)49);
                this.dpName = new RDN(derVal2);
            } else {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "DistributionPoint parsing error.");
                }
                throw new IOException("DistributionPoint parsing error.");
            }
            if (encoding.getData().available() == 0) {
                if (debug != null) {
                    debug.exit(16384L, className, "decode_1");
                }
                return;
            }
            derVal = encoding.getData().getDerValue();
        }
        if (derVal.isContextSpecific(this.TAG_REASONS) && !derVal.isConstructed()) {
            derVal.resetTag((byte)3);
            this.reasons = new ReasonFlags(derVal);
            if (encoding.getData().available() == 0) {
                if (debug != null) {
                    debug.exit(16384L, className, "decode_2");
                }
                return;
            }
            derVal = encoding.getData().getDerValue();
        }
        if (derVal.isContextSpecific(this.TAG_ISSUER) && derVal.isConstructed()) {
            derVal.resetTag((byte)48);
            try {
                this.issuer = new GeneralNames(derVal);
            }
            catch (GeneralNamesException e3) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", e3);
                }
                throw new IOException("Error constructing issuer name.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DistributionPoint parsing error.");
            }
            throw new IOException("DistributionPoint parsing error.");
        }
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DistributionPoint parsing error: data overrun.");
            }
            throw new IOException("DistributionPoint parsing error: data overrun.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode_3");
        }
    }
}

