/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.ObjectIdentifier;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;

public class oid2der {
    public static void main(String[] argv) {
        if (argv.length != 2) {
            System.out.println("Usage: oid2der <oid_to_convert> <outputfile_prefix>");
            System.out.println("  where <oid_to_convert> is in dot-notation");
            System.out.println("        <outputfile_prefix> is the prefix for the output files");
            System.exit(1);
        }
        try {
            System.out.println("Creating ObjectIdentifier object");
            ObjectIdentifier oid = new ObjectIdentifier(argv[0]);
            String filename = argv[1] + ".der";
            System.out.println("Writing DER-encoding to " + filename);
            FileOutputStream fos = new FileOutputStream(filename);
            DerOutputStream derout = new DerOutputStream();
            derout.putOID(oid);
            fos.write(derout.toByteArray());
            fos.close();
            filename = argv[1] + ".hexdump";
            System.out.println("Writing hex dump to " + filename);
            String str = "HexDumpEncoder output of OID " + argv[0] + "\r\n\r\n";
            HexDumpEncoder hd = new HexDumpEncoder();
            fos = new FileOutputStream(filename);
            try {
                fos.write(str.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e2) {
                fos.write(str.getBytes());
            }
            String hexdump = hd.encodeBuffer(derout.toByteArray());
            try {
                fos.write(hexdump.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e3) {
                fos.write(hexdump.getBytes());
            }
            fos.close();
        }
        catch (Exception e4) {
            System.out.println("ERROR: " + e4.toString());
            e4.printStackTrace();
        }
    }
}

