/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.smime.jmail.PKCS10MimeDataSource;
import com.ibm.security.smime.jmail.SMIMEMimeMessage;
import com.ibm.security.smime.jmail.SMIMEUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePartDataSource;

public class PKCS10MimeHandler
implements DataContentHandler {
    private static String PKCS10MIMEDATASOURCE_CLASSNAME = "com.ibm.security.smime.jmail.PKCS10MimeDataSource";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS10MimeHandler";

    public PKCS10MimeHandler() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS10MimeHandler");
            debug.exit(16384L, className, "PKCS10MimeHandler");
        }
    }

    public PKCS10MimeHandler(String provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS10MimeHandler", provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10MimeHandler");
        }
    }

    public Object getContent(DataSource ds) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getContent", ds);
        }
        if (ds instanceof PKCS10MimeDataSource) {
            PKCS10MimeDataSource mimeds = (PKCS10MimeDataSource)ds;
            CertificationRequest cr = mimeds.getCertificationRequest();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent_1", cr);
            }
            return cr;
        }
        if (ds instanceof MimePartDataSource) {
            MimePartDataSource mpds = (MimePartDataSource)ds;
            MessageContext msgcontext = mpds.getMessageContext();
            Session session = msgcontext.getSession();
            Message orgmsg = msgcontext.getMessage();
            if (orgmsg instanceof SMIMEMimeMessage) {
                SMIMEMimeMessage msg = (SMIMEMimeMessage)msgcontext.getMessage();
                byte[] content = SMIMEUtils.getMessageBodyRemoveTrailer(msg.getContentBytes());
                PKCS10MimeDataSource p10ds = new PKCS10MimeDataSource(content, true, this.provider);
                CertificationRequest retobj = p10ds.getCertificationRequest();
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getContent_2", retobj);
                }
                return retobj;
            }
            if (orgmsg instanceof MimeMessage) {
                try {
                    MimeMessage mimemsg = (MimeMessage)orgmsg;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    mimemsg.writeTo((OutputStream)baos);
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    SMIMEMimeMessage smimemsg = new SMIMEMimeMessage(session, (InputStream)bais, this.provider);
                    CertificationRequest retobj = smimemsg.getCertificationRequest();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getContent_3", retobj);
                    }
                    return retobj;
                }
                catch (MessagingException e2) {
                    if (debug != null) {
                        debug.exception(16384L, className, "getContent", e2);
                    }
                    throw new IOException(e2.toString());
                }
            }
        }
        if (debug != null) {
            debug.text(16384L, className, "getContent", "Only PKCS10MimeDataSource supported.  DataSource class was " + ds.getClass().getName());
        }
        throw new IOException("Only PKCS10MimeDataSource supported.  DataSource class was " + ds.getClass().getName());
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors;
        block4: {
            if (debug != null) {
                debug.entry(16384L, className, "getTransferDataFlavors");
            }
            flavors = new DataFlavor[2];
            try {
                flavors[0] = new ActivationDataFlavor(Class.forName("java.lang.String"), "application/x-pkcs10", "PKCS10 MIME");
            }
            catch (Exception e2) {
                if (debug == null) break block4;
                debug.exception(16384L, className, "getTransferDataFlavors", e2);
            }
        }
        flavors[1] = new DataFlavor("application/x-pkcs10", "PKCS10 MIME");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getTransferDataFlavors", flavors);
        }
        return flavors;
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getTransferData", df, ds);
        }
        if (df == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataFlavor is null");
            }
            throw new IOException("DataFlavor is null");
        }
        if (ds == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataSource is null");
            }
            throw new IOException("DataSource is null");
        }
        if (!df.getMimeType().equals("application/x-pkcs10")) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", df.getMimeType() + " not supported by PKCS10MimeHandler.");
            }
            throw new IOException(df.getMimeType() + " not supported by PKCS10MimeHandler.");
        }
        if (!df.getRepresentationClass().getName().equals(PKCS10MIMEDATASOURCE_CLASSNAME)) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", df.getRepresentationClass().getName() + " not supported by PKCS10MimeHandler.");
            }
            throw new IOException(df.getRepresentationClass().getName() + " not supported by PKCS10MimeHandler.");
        }
        try {
            CertificationRequest cr = null;
            if (ds instanceof PKCS10MimeDataSource) {
                cr = ((PKCS10MimeDataSource)ds).getCertificationRequest();
            } else {
                ByteArrayInputStream bais = (ByteArrayInputStream)ds.getInputStream();
                int i2 = bais.available();
                byte[] bytes = new byte[i2];
                int read = bais.read(bytes, 0, i2);
                cr = new CertificationRequest(bytes, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_1", cr);
            }
            return cr;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getTransferData", e2);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_2", null);
            }
            return null;
        }
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{obj, mimeType, os};
            debug.entry(16384L, (Object)className, "writeTo", parms);
        }
        if (obj instanceof CertificationRequest) {
            CertificationRequest cr = (CertificationRequest)obj;
            cr.encode(os);
            if (debug != null) {
                debug.exit(16384L, className, "writeTo");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "writeTo", "obj must be of type CertificationRequest.  Instead obj is of class " + obj.getClass().getName());
        }
        throw new IOException("obj must be of type CertificationRequest.  Instead obj is of class " + obj.getClass().getName());
    }

    public String toString() {
        String out = "PKCS10MimeHandler";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

