/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedChars;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class ChallengePassword
extends PKCS9DerObject
implements Cloneable {
    private SmudgedChars pwd;
    private byte type = (byte)19;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ChallengePassWord";
    private volatile int cachedHashVal = 0;

    public ChallengePassword(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ChallengePassword", (Object)der);
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", der, provider);
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] password) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ChallengePassword", (Object)password);
        }
        this.setPasswordValue((char[])password.clone());
        this.type = (byte)19;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] password, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", password, provider);
        }
        this.setPasswordValue((char[])password.clone());
        this.type = (byte)19;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] password, byte type) {
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", password, new Byte(type));
        }
        this.setPasswordValue((char[])this.getPasswordValue().clone());
        if (type != 20 || type != 19) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "ChallengePassword", "tag " + type + " not valid.");
            }
            throw new IllegalArgumentException("tag " + type + " not valid.");
        }
        this.type = type;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] password, byte type, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{password, new Byte(type), provider};
            debug.entry(16384L, (Object)className, "ChallengePassword", parms);
        }
        this.setPasswordValue((char[])this.getPasswordValue().clone());
        if (type != 20 || type != 19) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "ChallengePassword", "tag " + type + " not valid.");
            }
            throw new IllegalArgumentException("tag " + type + " not valid.");
        }
        this.type = type;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", filename, new Boolean(base64));
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "ChallengePassword", parms);
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            ChallengePassword result = new ChallengePassword(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof ChallengePassword) {
            boolean result = this.equals((ChallengePassword)obj);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(result));
            }
            return result;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.CHALLENGE_PASSWORD_OID);
        }
        return PKCSOID.CHALLENGE_PASSWORD_OID;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.getPasswordValue() == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Password not specified.");
            }
            throw new IOException("Password not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        if (this.type == 20) {
            tmpout2.putPrintableString(this.getPasswordValue());
        } else {
            tmpout2.putPrintableString(this.getPasswordValue());
        }
        tmpout.write((byte)49, tmpout2.toByteArray());
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public char[] getPassword() {
        if (debug != null) {
            debug.entry(16384L, className, "getPassword");
            debug.exit(16384L, (Object)className, "getPassword", this.getPasswordValue().clone());
        }
        return (char[])this.getPasswordValue().clone();
    }

    public byte getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", new Byte(this.type));
        }
        return this.type;
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getPasswordValue");
            debug.exit(16384L, (Object)className, "getPasswordValue", this.getPasswordValue());
        }
        return this.getPasswordValue();
    }

    @Override
    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 19 || tag == 20) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    @Override
    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    @Override
    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "ChallengePassword");
        }
        return "ChallengePassword";
    }

    @Override
    public String toString() {
        String out = "PKCS9 ChallengePassword:\r\n";
        out = this.getPasswordValue() != null ? out + "\t<NOT SHOWN>\r\n" : out + "\tnull\r\n";
        out = this.type == 20 ? out + "\tEncoded in T61String\r\n" : out + "\tEncoded in PrintableString\r\n";
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        if (elems[0].getTag() == 20) {
            this.setPasswordValue(elems[0].getAsString().toCharArray());
            this.type = (byte)20;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (elems[0].getTag() == 19) {
            this.setPasswordValue(elems[0].getAsString().toCharArray());
            this.type = (byte)19;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "decode", "tag " + elems[0].getTag() + " not valid.");
        }
        throw new IOException("tag " + elems[0].getTag() + " not valid.");
    }

    private void setPasswordValue(char[] chars) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setPasswordValue", (Object)chars);
            debug.exit(8192L, className, "setPasswordValue");
        }
        this.pwd = new SmudgedChars(chars, this.provider);
    }

    private char[] getPasswordValue() {
        if (debug != null) {
            debug.entry(8192L, className, "getPasswordValue");
        }
        if (this.pwd == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPasswordValue", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getPasswordValue", "password in clear text");
        }
        return this.pwd.getClearText();
    }

    protected void finalize() {
        this.pwd = null;
    }

    private boolean equals(ChallengePassword other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e2);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

