/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.security.util.KeyUtil;
import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.Policy;
import com.ibm.xml.crypto.dsig.dom.ReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.TransformContext;
import com.ibm.xml.crypto.dsig.dom.Utils;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import com.ibm.xml.crypto.spi.SignatureEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.w3c.dom.Node;

class SignedInfoImpl
extends XMLStructureImpl
implements SignedInfo {
    private static final int FETCH_BUFFER_SIZE = 4096;
    List content;
    private String id;
    private CanonicalizationMethod c14nMethod;
    private SignatureMethod signatureMethod;
    private byte[] canonicalized;
    private KeySelectorResult keyResult;
    private boolean validated;
    private boolean cachedResult;
    private Node node;

    SignedInfoImpl(AlgorithmFactory f, CanonicalizationMethod cm, SignatureMethod sm, List references, String id) {
        super(f);
        if (cm == null) {
            throw new NullPointerException("CanonicalizationMethod must not be null.");
        }
        this.c14nMethod = cm;
        if (sm == null) {
            throw new NullPointerException("SignatureMethod must not be null.");
        }
        this.signatureMethod = sm;
        if (references == null) {
            throw new NullPointerException("Reference List must not be null.");
        }
        if (references.size() == 0) {
            throw new IllegalArgumentException("Reference List is empty.");
        }
        this.content = new ArrayList(references.size());
        for (Reference obj : references) {
            this.content.add(obj);
        }
        this.id = id;
        this.canonicalized = null;
        this.node = null;
        this.keyResult = null;
        this.validated = false;
        this.cachedResult = false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.c14nMethod;
    }

    @Override
    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    @Override
    public InputStream getCanonicalizedData() {
        if (this.canonicalized == null) {
            return null;
        }
        return new ByteArrayInputStream(this.canonicalized);
    }

    KeySelectorResult getKeySelectorResult() {
        return this.keyResult;
    }

    void setSignatureNode(Node n) {
        for (int i = 0; i < this.content.size(); ++i) {
            ReferenceImpl ref = (ReferenceImpl)this.content.get(i);
            ref.setSignatureNode(n);
        }
    }

    void setNode(Node n) {
        this.node = n;
    }

    byte[] sign(XMLSignContext scontext, KeyInfo ki) throws XMLSignatureException {
        byte[] result;
        KeySelector selector = scontext.getKeySelector();
        try {
            this.keyResult = selector.select(ki, KeySelector.Purpose.SIGN, this.signatureMethod, scontext);
        }
        catch (KeySelectorException kse) {
            throw new XMLSignatureException(kse);
        }
        Key key = this.keyResult.getKey();
        SignedInfoImpl.checkKeySize(scontext, key);
        boolean saveCanonicalized = true;
        ByteArrayOutputStream baos = null;
        OctetStreamData data = this.canonicalize(scontext);
        SignatureEngine signer = null;
        InputStream is = null;
        try {
            signer = this.afactory.getSignatureEngine(this.signatureMethod.getAlgorithm());
            signer.setParameter(this.signatureMethod.getParameterSpec());
            signer.initSign(key);
            if (data instanceof BinaryData) {
                this.canonicalized = ((BinaryData)data).getData();
                signer.update(this.canonicalized);
            } else {
                int readLength;
                is = data.getOctetStream();
                if (saveCanonicalized) {
                    baos = new ByteArrayOutputStream();
                }
                byte[] buffer = new byte[4096];
                while ((readLength = is.read(buffer)) != -1) {
                    signer.update(buffer, 0, readLength);
                    if (baos == null) continue;
                    baos.write(buffer, 0, readLength);
                }
                if (baos != null) {
                    baos.close();
                    this.canonicalized = baos.toByteArray();
                }
            }
            result = signer.sign();
        }
        catch (GeneralSecurityException gse) {
            throw new XMLSignatureException(gse);
        }
        catch (IOException ioe) {
            throw new XMLSignatureException(ioe);
        }
        finally {
            if (signer != null) {
                this.afactory.releaseSignatureEngine(signer);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    boolean validate(XMLValidateContext vcontext, KeyInfo ki, byte[] sv) throws XMLSignatureException {
        if (this.validated) {
            return this.cachedResult;
        }
        KeySelector selector = vcontext.getKeySelector();
        try {
            this.keyResult = selector.select(ki, KeySelector.Purpose.VERIFY, this.signatureMethod, vcontext);
        }
        catch (KeySelectorException kse) {
            throw new XMLSignatureException(kse);
        }
        Key key = this.keyResult.getKey();
        SignedInfoImpl.checkKeySize(vcontext, key);
        boolean saveCanonicalized = true;
        ByteArrayOutputStream baos = null;
        OctetStreamData data = this.canonicalize(vcontext);
        SignatureEngine signer = null;
        InputStream is = null;
        try {
            signer = this.afactory.getSignatureEngine(this.signatureMethod.getAlgorithm());
            signer.setParameter(this.signatureMethod.getParameterSpec());
            signer.initVerify(key);
            if (data instanceof BinaryData) {
                this.canonicalized = ((BinaryData)data).getData();
                signer.update(this.canonicalized);
            } else {
                int readLength;
                is = data.getOctetStream();
                if (saveCanonicalized) {
                    baos = new ByteArrayOutputStream();
                }
                byte[] buffer = new byte[4096];
                while ((readLength = is.read(buffer)) != -1) {
                    signer.update(buffer, 0, readLength);
                    if (baos == null) continue;
                    baos.write(buffer, 0, readLength);
                }
                if (baos != null) {
                    baos.close();
                    this.canonicalized = baos.toByteArray();
                }
            }
            this.cachedResult = signer.verify(sv);
            this.validated = true;
        }
        catch (GeneralSecurityException gse) {
            signer = null;
            throw new XMLSignatureException(gse);
        }
        catch (IOException ioe) {
            throw new XMLSignatureException(ioe);
        }
        finally {
            if (signer != null) {
                this.afactory.releaseSignatureEngine(signer);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.cachedResult;
    }

    private OctetStreamData canonicalize(XMLCryptoContext context) throws XMLSignatureException {
        Data data;
        if (this.node == null) {
            throw new XMLSignatureException("This SignedInfo is not signed yet.");
        }
        Node signedInfo = this.node;
        TransformContext tcontext = new TransformContext(this.afactory, null);
        context.put(TransformContext.class, tcontext);
        try {
            NodeSetData nodes = TransformUtil.toNodeSet(signedInfo, true);
            data = this.c14nMethod.transform(nodes, context);
            if (!(data instanceof OctetStreamData)) {
                throw new XMLSignatureException("Internal Error: The result of c14n must be OctetStreamData");
            }
        }
        catch (Exception e) {
            throw new XMLSignatureException(e);
        }
        finally {
            context.put(TransformContext.class, null);
        }
        return (OctetStreamData)data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignedInfo)) {
            return false;
        }
        SignedInfo osi = (SignedInfo)o;
        boolean idEqual = this.id == null ? osi.getId() == null : this.id.equals(osi.getId());
        boolean c14nMethodEqual = this.c14nMethod.equals(osi.getCanonicalizationMethod());
        boolean signatureMethodEqual = this.signatureMethod.equals(osi.getSignatureMethod());
        boolean referencesEqual = this.content.equals(osi.getReferences());
        return c14nMethodEqual && signatureMethodEqual && referencesEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + this.c14nMethod.hashCode();
        result = 31 * result + this.signatureMethod.hashCode();
        result = 31 * result + this.content.hashCode();
        return result;
    }

    private static void checkKeySize(XMLCryptoContext context, Key key) throws XMLSignatureException {
        if (Utils.secureValidation(context)) {
            int size = KeyUtil.getKeySize((Key)key);
            if (size == -1) {
                return;
            }
            if (Policy.restrictKey(key.getAlgorithm(), size)) {
                throw new XMLSignatureException(key.getAlgorithm() + " keys less than " + Policy.minKeySize(key.getAlgorithm()) + " bits are forbidden when secure validation is enabled");
            }
        }
    }
}

