/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.xml.crypto.dsig.keyinfo.KeyValue;

class KeyValueImpl
extends XMLStructureImpl
implements KeyValue {
    private PublicKey key;

    KeyValueImpl(AlgorithmFactory f, PublicKey key) throws KeyException {
        super(f);
        if (key == null) {
            throw new NullPointerException("The key must not be null.");
        }
        if (!(key instanceof RSAPublicKey || key instanceof DSAPublicKey || key instanceof ECPublicKey)) {
            throw new KeyException("This type of key is not supported: " + key.getAlgorithm());
        }
        this.key = key;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyValue)) {
            return false;
        }
        try {
            KeyValue kv = (KeyValue)obj;
            if (this.key == null ? kv.getPublicKey() != null : !this.key.equals(kv.getPublicKey())) {
                return false;
            }
        }
        catch (KeyException ke) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        if (this.key != null) {
            result = 31 * result + this.key.hashCode();
        }
        return result;
    }
}

