/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCInitialContextFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslRMIClientSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslRMIServerSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.NetworkAddressFinder;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.TransportType;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class HCLaunchMBean {
    private static final String START_MBEAN_SERVER_METHOD = "startMBeanServer";
    private static final String MBEAN_OBJECT_NAME = "IBM:type=HCMBeanServer";
    public static final String JMX_URL_TEMPLATE = "service:jmx:{0}://{1}:{2}/jndi/rmi://{3}:{4}/jmxrmi";
    private static final String JMX_REMOTE_X_ACCESS_FILE = "jmx.remote.x.access.file";
    private static final String JMX_REMOTE_X_PASSWORD_FILE = "jmx.remote.x.password.file";
    private static final int MAX_PORTS_TO_TRY = 100;
    private static final int MILLISECONDS_IN_A_SECOND = 1000;
    private int port = -1;
    private int pid = 0;
    private String className = this.getClass().getName();
    private boolean jmxBuilderSet = false;
    private HealthCenterOptionHandler handler;
    private Logger logger;
    private final NetworkAddressFinder networkAddressFinder;
    private boolean useSSL = false;
    private static final int ERROR_CODE_GENERIC_JMX_STARTUP_FAILURE = -1;
    private static final int ERROR_CODE_MISSING_SSLPARM = -2;
    private static final int ERROR_CODE_TRIED_ALL_PORT_IN_RANGE = -3;
    private static final int ERROR_CODE_BEAN_REGISTRATION_FAILED = -4;
    private static final int ERROR_CODE_BAD_AUTHENTICATION_FILE = -5;
    private static final int ERROR_CODE_SSL_KEYSTORE_NOT_FOUND = -6;

    private boolean isCORBAKeepAlive(Thread thread) {
        StackTraceElement[] ste = thread.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            if (!"com.ibm.CORBA.iiop.KeepAlive".equals(ste[i].getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        if (System.getProperty("jzos.launcher") != null) {
            try {
                Class<?> c = Class.forName("com.ibm.jzos.ZUtil");
                Method m = c.getMethod("redirectStandardStreams", new Class[0]);
                m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                System.err.println("jzos.launcher specified but com.ibm.jzos.ZUtil.redirectStandardStreams() not invoked");
                System.err.println("stdout/stderr redirection to JZOS datasets not performed");
                e.printStackTrace();
            }
        }
        HealthCenterOptionHandler handler = new HealthCenterOptionHandler(args);
        HCLaunchMBean launcher = new HCLaunchMBean(handler);
        DataCollectionLevel level = handler.getDataCollectionLevel();
        if (level.ordinal() != DataCollectionLevel.NONE.ordinal()) {
            int port = launcher.startAgent();
            handler.setAgentPort(port);
            System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "true");
        }
    }

    public HCLaunchMBean(HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.pid = handler.getPid();
        if (this.logger == null) {
            AgentLogFactory.setPid(this.pid);
            this.logger = AgentLogFactory.setUpLogging(this.getClass());
        }
        this.networkAddressFinder = new NetworkAddressFinder();
        String formattedMessage = MessageFormat.format(Messages.getString("HCLaunchMBean.agent.version"), "3.0.20.20210611");
        this.logger.info(formattedMessage);
    }

    public int startAgent() {
        this.logger.fine("Starting Health Center agent initialization.");
        JmxStarterThread startThread = new JmxStarterThread(Messages.getString("HCLaunchMBean.jmx.starter.thread.name"), this.pid);
        this.logger.fine("Starting MBean starter thread.");
        startThread.start();
        while (startThread.isAlive()) {
            try {
                startThread.join();
            }
            catch (Exception e) {
                this.logger.fine("Interrupted joining Agent starter thread");
            }
        }
        this.port = startThread.getPort();
        if (this.port < 0) {
            this.logger.info(Messages.getString("HCLaunchMBean.agent.did.not.start.correctly"));
        } else {
            DataCollectionLevel level = this.handler.getDataCollectionLevel();
            if (level.ordinal() == DataCollectionLevel.OFF.ordinal()) {
                this.logger.info(Messages.getString("HCLaunchMBean.agent.pseudo.lateattach"));
            }
            if (this.useSSL) {
                String formattedMessage = MessageFormat.format(Messages.getString("HCLaunchMBean.agent.started.ssl"), Integer.toString(this.port));
                this.logger.info(formattedMessage);
            } else {
                String formattedMessage = MessageFormat.format(Messages.getString("HCLaunchMBean.agent.started"), Integer.toString(this.port));
                this.logger.info(formattedMessage);
            }
        }
        return this.port;
    }

    public int startMBeanServer(int port, int pid) {
        this.logger.entering(this.className, START_MBEAN_SERVER_METHOD);
        Registry registry = null;
        boolean isLoadableBuilder = true;
        String originalBuilder = null;
        if (this.handler.isTryOverrideBuilder()) {
            originalBuilder = System.getProperty("javax.management.builder.initial");
            this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.original.builder"), originalBuilder));
            if (originalBuilder != null) {
                this.jmxBuilderSet = true;
                try {
                    Class.forName(originalBuilder);
                }
                catch (ClassNotFoundException e) {
                    isLoadableBuilder = false;
                    this.logger.fine("Clearing builder");
                    System.clearProperty("javax.management.builder.initial");
                }
                if (isLoadableBuilder) {
                    String template = "Loaded class {0} OK";
                    String message = MessageFormat.format("Loaded class {0} OK", originalBuilder);
                    this.logger.fine(message);
                }
            }
        }
        MBeanServer mbs = null;
        if (this.handler.isUsePlatformMBeanServer()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Getting platform MBean server");
            }
            mbs = ManagementFactory.getPlatformMBeanServer();
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Creating a new MBean server");
            }
            mbs = MBeanServerFactory.createMBeanServer();
        }
        this.logger.fine(MessageFormat.format("MBean server: {0}", mbs));
        if (this.jmxBuilderSet && !isLoadableBuilder) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(MessageFormat.format("Restoring builder to {0}", originalBuilder));
            }
            System.setProperty("javax.management.builder.initial", originalBuilder);
        }
        this.logger.fine(MessageFormat.format("Registering our MBean (PID: {0})", Integer.toString(pid)));
        try {
            HealthCenter mbean = new HealthCenter(pid, this.handler);
            ObjectName name = new ObjectName(MBEAN_OBJECT_NAME);
            mbs.registerMBean(mbean, name);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, Messages.getString("HCLaunchMBean.agent.did.not.start"), e);
            e.printStackTrace();
            return -4;
        }
        return this.createJMXConnector(port, registry, mbs);
    }

    private int createJMXConnector(int port, Registry registry, MBeanServer mbs) {
        String template;
        this.ensureNetworkAddressIsSensible();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Initialize the environment map");
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        String sslKeystore = this.handler.getSslKeystore();
        String sslKeystorePassword = this.handler.getSslKeystorePassword();
        String sslKeystoreCertificatePassword = this.handler.getSslKeystoreCertificatePassword();
        String sslTruststore = this.handler.getSslTruststore();
        String sslTruststorePassword = this.handler.getSslTruststorePassword();
        String sslTruststoreCertificatePassword = this.handler.getSslTruststoreCertificatePassword();
        if (sslKeystore != null || sslKeystorePassword != null) {
            String message;
            boolean missingSslParm = false;
            if (sslKeystore == null) {
                template = Messages.getString("HCLaunchMBean.bad.ssl.definition.missing.parameter");
                message = MessageFormat.format(template, "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStore");
                this.logger.warning(message);
                missingSslParm = true;
            }
            if (sslKeystorePassword == null) {
                template = Messages.getString("HCLaunchMBean.bad.ssl.definition.missing.parameter");
                message = MessageFormat.format(template, "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStorePassword");
                this.logger.warning(message);
                missingSslParm = true;
            }
            if (missingSslParm) {
                return -2;
            }
            this.useSSL = true;
            if (!new File(sslKeystore).exists()) {
                this.useSSL = false;
                template = Messages.getString("HCLaunchMBean.bad.ssl.definition.keystore.not.found");
                message = MessageFormat.format(template, sslKeystore);
                this.logger.warning(message);
            }
            if (!sslKeystore.equals(sslTruststore) && !new File(sslTruststore).exists()) {
                this.useSSL = false;
                template = Messages.getString("HCLaunchMBean.bad.ssl.definition.keystore.not.found");
                message = MessageFormat.format(template, sslTruststore);
                this.logger.warning(message);
            }
            if (!this.useSSL) {
                return -6;
            }
        }
        try {
            if (this.useSSL) {
                HCSslSocketFactory.setSSLValues(sslTruststore, sslTruststorePassword, sslTruststoreCertificatePassword);
                HCSslRMIClientSocketFactory hcCsf = new HCSslRMIClientSocketFactory();
                HCSslRMIServerSocketFactory hcSsf = new HCSslRMIServerSocketFactory(sslKeystore, sslKeystorePassword, sslKeystoreCertificatePassword);
                this.logger.fine(MessageFormat.format("Creating RMI registry on port {0} using SSL", Integer.toString(port)));
                registry = LocateRegistry.createRegistry(port, hcCsf, hcSsf);
                env.put("jmx.remote.rmi.client.socket.factory", hcCsf);
                env.put("jmx.remote.rmi.server.socket.factory", hcSsf);
                env.put("com.sun.jndi.rmi.factory.socket", hcCsf);
            } else {
                this.logger.fine(MessageFormat.format("Creating RMI registry on port {0}", Integer.toString(port)));
                registry = LocateRegistry.createRegistry(port);
            }
        }
        catch (Exception e) {
            template = Messages.getString("HCLaunchMBean.failed.to.create.rmi.registry");
            String formattedMessage = MessageFormat.format(template, Integer.toString(port), e.toString());
            try {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            catch (NoSuchObjectException e1) {
                // empty catch block
            }
            this.logger.log(Level.WARNING, formattedMessage);
            if (port > this.handler.getStartPort() + 100) {
                return -3;
            }
            return this.startMBeanServer(++port, this.pid);
        }
        this.logger.fine(MessageFormat.format("RMI registry created on port {0}", Integer.toString(port)));
        boolean auth = false;
        String autheFile = this.handler.getAutheFile();
        String authoFile = this.handler.getAuthoFile();
        if (autheFile != null && authoFile != null) {
            if (new File(autheFile).exists() && new File(authoFile).exists()) {
                env.put(JMX_REMOTE_X_PASSWORD_FILE, autheFile);
                env.put(JMX_REMOTE_X_ACCESS_FILE, authoFile);
                auth = true;
            } else {
                String template2 = Messages.getString("HCLaunchMBean.bad.authentication.file");
                String message = MessageFormat.format(template2, autheFile, authoFile);
                this.logger.warning(message);
                return -5;
            }
        }
        env.put("java.naming.factory.initial", HCInitialContextFactory.class.getName());
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Creating an RMI connector server");
        }
        try {
            String hostname;
            if (this.networkAddressFinder.defaultAddressIsUnreliable()) {
                hostname = this.networkAddressFinder.getLocalAddress();
                if (hostname == null) {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
            } else {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            hostname = System.getProperty("java.rmi.server.hostname", hostname);
            String portString = Integer.toString(port);
            String transportString = this.handler.getTransportType().getJMXType();
            String savedIIOPPortSystemProperty = null;
            if (this.handler.getTransportType() == TransportType.IIOP) {
                String message;
                String template3;
                String specifiedIIOPPort = this.handler.getAgentIIOPPort();
                if (specifiedIIOPPort != null) {
                    savedIIOPPortSystemProperty = System.setProperty("com.ibm.CORBA.ListenerPort", specifiedIIOPPort);
                    template3 = Messages.getString("HCLaunchMBean.iiop.port.specified");
                    message = MessageFormat.format(template3, specifiedIIOPPort);
                    this.logger.info(message);
                } else {
                    template3 = Messages.getString("HCLaunchMBean.iiop.port.not.specified");
                    message = MessageFormat.format(template3, "com.ibm.java.diagnostics.healthcenter.agent.iiop.port");
                    this.logger.info(message);
                }
            }
            JMXServiceURL url = new JMXServiceURL(MessageFormat.format(JMX_URL_TEMPLATE, transportString, hostname, portString, hostname, portString));
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(MessageFormat.format("Starting the RMI connector server ({0})", url));
            }
            cs.start();
            if (this.handler.getTransportType() == TransportType.IIOP) {
                if (savedIIOPPortSystemProperty == null) {
                    System.clearProperty("com.ibm.CORBA.ListenerPort");
                } else {
                    System.setProperty("com.ibm.CORBA.ListenerPort", savedIIOPPortSystemProperty);
                }
            }
            StopJMXConnectorThread stopJMXConnector = new StopJMXConnectorThread(cs);
            stopJMXConnector.start();
            String authWithWord = auth ? "with" : "without";
            this.logger.fine(MessageFormat.format("RMI connector server started {0} authentication.", authWithWord));
        }
        catch (Throwable e) {
            try {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            catch (NoSuchObjectException e1) {
                // empty catch block
            }
            this.logger.log(Level.SEVERE, Messages.getString("HCLaunchMBean.agent.failed.to.start"), e);
            return -1;
        }
        return port;
    }

    private void ensureNetworkAddressIsSensible() {
        if (this.networkAddressFinder.defaultAddressIsUnreliable()) {
            String message;
            String template;
            String hostAddress;
            String localAddress = this.networkAddressFinder.getLocalAddress();
            try {
                hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostAddress = Messages.getString("HCLaunchMBean.unknown.host");
            }
            if (this.handler.getTransportType() == TransportType.JRMP && System.getProperty("java.rmi.server.hostname") == null && localAddress != null) {
                template = Messages.getString("HCLaunchMBean.overriding.network.address.warning");
                message = MessageFormat.format(template, localAddress, hostAddress, "java.rmi.server.hostname");
                this.logger.warning(message);
                System.setProperty("java.rmi.server.hostname", localAddress);
            }
            if (this.handler.getTransportType() == TransportType.IIOP && System.getProperty("com.ibm.CORBA.LocalHost") == null && localAddress != null) {
                template = Messages.getString("HCLaunchMBean.overriding.orb.network.address.warning");
                message = MessageFormat.format(template, localAddress, hostAddress, "com.ibm.CORBA.LocalHost");
                this.logger.warning(message);
                System.setProperty("com.ibm.CORBA.LocalHost", localAddress);
            }
        }
    }

    public boolean stopMBeanServer(int port) {
        boolean stopped = false;
        try {
            Registry registry = LocateRegistry.getRegistry(port);
            stopped = UnicastRemoteObject.unexportObject(registry, true);
        }
        catch (Throwable e) {
            String template = Messages.getString("HCLaunchMBean.failed.to.stop.registry");
            String message = MessageFormat.format(template, port, e.toString());
            this.logger.log(Level.WARNING, message);
        }
        return stopped;
    }

    private static void loadNativeLibrary() {
        try {
            HealthCenter.isLoaded();
        }
        catch (UnsatisfiedLinkError e) {
            try {
                File[] libs;
                File libdir;
                String sysAgentPath = System.getProperty("com.ibm.system.agent.path");
                String hcAgentPath = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.path");
                String agentPath = hcAgentPath != null ? (sysAgentPath != null && sysAgentPath.indexOf("/lib") != -1 ? hcAgentPath + sysAgentPath.substring(sysAgentPath.indexOf("/lib")) : sysAgentPath) : sysAgentPath;
                if (agentPath != null && (libdir = new File(agentPath)) != null && (libs = libdir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.equals("healthcenter.dll") || name.equals("libhealthcenter.so");
                    }
                })) != null && libs.length > 0) {
                    System.load(libs[0].getAbsolutePath());
                }
                HealthCenter.isLoaded();
            }
            catch (UnsatisfiedLinkError ule) {
                try {
                    System.loadLibrary("healthcenter");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
        }
    }

    static {
        HCLaunchMBean.loadNativeLibrary();
    }

    private class JmxStarterThread
    extends Thread {
        protected int port;
        protected int pid;

        public JmxStarterThread(String name, int pid) {
            super(name);
            this.port = -1;
            this.pid = 0;
            this.pid = pid;
        }

        public int getPort() {
            return this.port;
        }

        public void run() {
            int startDelaySeconds = HCLaunchMBean.this.handler.getStartDelaySeconds();
            if (startDelaySeconds > 0) {
                try {
                    Thread.sleep(startDelaySeconds * 1000);
                }
                catch (Exception e) {
                    HCLaunchMBean.this.logger.fine(MessageFormat.format(Messages.getString("HCLaunchMBean.thread.interrupted"), this.getName()));
                }
            }
            HCLaunchMBean.this.logger.fine("Calling startMBeanServer");
            this.port = HCLaunchMBean.this.startMBeanServer(HCLaunchMBean.this.handler.getStartPort(), this.pid);
            HCLaunchMBean.this.logger.fine("startMBeanServer returned");
        }
    }

    public class StopJMXConnectorThread
    extends Thread {
        private final JMXConnectorServer cs;

        public StopJMXConnectorThread(JMXConnectorServer cs) {
            super(Messages.getString("HCLaunchMBean.thread.name"));
            this.cs = cs;
            this.setDaemon(true);
        }

        public void run() {
            this.stopJMXConnectorOnceNoThreadsRemain();
        }

        private void stopJMXConnectorOnceNoThreadsRemain() {
            this.blockUntilNoThreadsRemain();
            if (!HCLaunchMBean.this.handler.isKeepAlive()) {
                try {
                    String shutdownMessage = Messages.getString("HCLaunchMBean.stopping.jmx.connector.server");
                    HCLaunchMBean.this.logger.log(Level.FINE, shutdownMessage);
                    this.cs.stop();
                }
                catch (Throwable ex) {
                    String message = Messages.getString("HCLaunchMBean.problem.stopping.server");
                    HCLaunchMBean.this.logger.log(Level.WARNING, message, ex);
                }
                finally {
                    try {
                        this.cs.stop();
                    }
                    catch (Throwable ex) {
                        System.exit(-1);
                    }
                }
            }
        }

        private void blockUntilNoThreadsRemain() {
            boolean threadsRemaining;
            do {
                threadsRemaining = false;
                Thread[] currentThreads = new Thread[Thread.activeCount()];
                Thread.enumerate(currentThreads);
                if (Thread.activeCount() > currentThreads.length) {
                    threadsRemaining = true;
                }
                for (Thread thread : currentThreads) {
                    if (thread == null || !thread.isAlive() || thread.isDaemon() || thread.getName().startsWith("RMI Reaper") || thread.getName().startsWith("DestroyJavaVM helper thread") || HCLaunchMBean.this.isCORBAKeepAlive(thread)) continue;
                    threadsRemaining = true;
                    try {
                        HCLaunchMBean.this.logger.fine("blockUntilNoThreadsRemain() Joining " + thread.getName());
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            } while (threadsRemaining);
        }
    }
}

