/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateWriter$OutputMode;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractEntry;
import com.ibm.gsk.ikeyman.keystore.entry.ByteArray;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$AlgorithmItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$DNItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$DisplayItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$TreeDisplayItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.Details$DetailIdentifier;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree$KeymanTreeNode;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class CertificateRequestItemImpl
extends AbstractEntry
implements CertificateRequestItem {
    private final DisplayItemFactory$TreeDisplayItem version;
    private final DisplayItemFactory$DNItem subjectDN;
    private final int keySize;
    private final DisplayItemFactory$DisplayItem fingerprint;
    private final PublicKey publicKey;
    private final DisplayItemFactory$TreeDisplayItem publicKeyAlgorithm;
    private final Collection attributes;
    private final DisplayItemFactory$AlgorithmItem signatureAlgorithm;
    private final ByteArray signature;
    private final CertificationRequest request;
    private PublicKey pubKey;
    private CertificateKeyItem ca_signer;
    private CertificateExtensions ext;

    protected CertificateRequestItemImpl(String string, CertificationRequest certificationRequest) throws KeyManagerException {
        super(string);
        this.request = certificationRequest;
        CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
        this.version = DisplayItemFactory.getCertificateRequestVersion(certificationRequestInfo.getVersion());
        this.subjectDN = DisplayItemFactory.getDNItem(certificationRequestInfo.getSubjectName());
        PublicKey publicKey = null;
        try {
            publicKey = certificationRequestInfo.getSubjectPublicKeyInfo();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PUBLIC_KEY_COPY_ERROR, (Throwable)invalidKeyException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        this.keySize = CertificateRequestItemImpl.computeKeySize(publicKey);
        this.fingerprint = DisplayItemFactory.getFinterprintItem(certificationRequestInfo);
        this.publicKeyAlgorithm = DisplayItemFactory.getAlgorithmItem(publicKey);
        this.publicKey = publicKey;
        this.attributes = DisplayItemFactory.getAttributeItems(certificationRequestInfo.getAttributes().getAttributes());
        this.signature = new ByteArray(certificationRequest.getSignature());
        this.signatureAlgorithm = DisplayItemFactory.getAlgorithmItem(certificationRequest.getSignatureAlgorithm());
        this.ext = null;
    }

    public CertificateRequestItemImpl(String string, CertificationRequest certificationRequest, CommandParameters commandParameters) throws KeyManagerException, IOException {
        this(string, certificationRequest);
        KeyUsageExtension keyUsageExtension;
        Vector vector;
        CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
        Object object = certificationRequestInfo.getAttributes().getAttribute(PKCSOID.EXTENSION_REQUEST_OID);
        if (object != null) {
            this.ext = (CertificateExtensions)((PKCSAttribute)object).getAttributeValue();
            try {
                this.ext.delete("ExtKeyUsage");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ext.delete("KeyUsage");
            }
            catch (Exception exception) {}
        } else {
            this.ext = new CertificateExtensions();
        }
        DisplayItemFactory$DNItem displayItemFactory$DNItem = commandParameters.isParameterPresent(Constants$Parameter.DN) ? commandParameters.getDn() : DisplayItemFactory.getDNItem("");
        CertAttrSet certAttrSet = commandParameters.getSan().toExtension(displayItemFactory$DNItem.isEmpty());
        if (certAttrSet != null) {
            this.ext.set(certAttrSet.getName(), (Object)certAttrSet);
        }
        if (commandParameters.isParameterPresent(Constants$Parameter.CA) && commandParameters.isCa()) {
            this.ext.set("BasicConstraints", (Object)new BasicConstraintsExtension(true, Integer.MAX_VALUE));
        }
        if ((vector = commandParameters.getExtendedKeyUsage()).size() > 0) {
            this.ext.set("ExtKeyUsage", (Object)new ExtKeyUsageExtension(vector));
        }
        if ((keyUsageExtension = commandParameters.getKeyUsage()) != null) {
            this.ext.set("KeyUsage", (Object)keyUsageExtension);
        }
        if (this.ext.getAllExtensions().size() > 0 && certificationRequestInfo.getAttributes().size() > 0) {
            certificationRequestInfo.getAttributes().addAttribute(new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, (Object)this.ext));
        }
    }

    private static int computeKeySize(PublicKey publicKey) {
        int n = 0;
        if (publicKey instanceof RSAPublicKey) {
            n = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            n = ((DSAPublicKey)publicKey).getY().bitLength();
        } else if (publicKey instanceof ECPublicKey) {
            n = ((ECPublicKey)publicKey).getParams().getCurve().getA().bitLength();
        }
        if (n % 2 != 0) {
            ++n;
        }
        return n;
    }

    public void extract(String string, CertificateWriter$OutputMode certificateWriter$OutputMode) throws KeyManagerException {
        try {
            this.request.writeBASE64(string);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, iOException, new String[]{string});
        }
    }

    public int getKeySize() {
        return this.keySize;
    }

    public DisplayItemFactory$DNItem getSubjectDN() {
        return this.subjectDN;
    }

    public CertificationRequest getRequest() {
        return this.request;
    }

    protected X509Certificate createCertificate(X500Name x500Name, int n, Integer n2, AlgorithmId algorithmId, Extension extension, String string) throws KeyManagerException {
        Object object;
        Object object2;
        PKCS9DerObject pKCS9DerObject;
        PKCSAttribute pKCSAttribute2;
        X509CertInfo x509CertInfo = new X509CertInfo(string);
        CertificateVersion certificateVersion = KeymanSettings.DEFAULT_CERTIFICATE_VERSION;
        CertificateSerialNumber certificateSerialNumber = n2 != null ? new CertificateSerialNumber(n2.intValue()) : new CertificateSerialNumber((int)(Calendar.getInstance().getTime().getTime() / 1000L));
        AlgorithmId algorithmId2 = algorithmId;
        X500Name x500Name2 = null;
        X500Name x500Name3 = null;
        try {
            x500Name2 = new X500Name(x500Name.toString());
            x500Name3 = new X500Name(this.subjectDN.toString());
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_DN, (Throwable)iOException);
        }
        CertificationRequest certificationRequest = this.request;
        CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
        PKCSAttributes pKCSAttributes = certificationRequestInfo.getAttributes();
        PKCSAttribute[] pKCSAttributeArray = pKCSAttributes.getAttributes();
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        if (pKCSAttributes.size() != 0) {
            for (PKCSAttribute pKCSAttribute2 : pKCSAttributeArray) {
                pKCS9DerObject = pKCSAttribute2.getPKCS9DerObject();
                if (!(pKCS9DerObject.getValue() instanceof CertificateExtensions)) continue;
                certificateExtensions = (CertificateExtensions)pKCS9DerObject.getValue();
                break;
            }
        } else if (this.ext != null) {
            certificateExtensions = this.ext;
        }
        try {
            SubjectKeyIdentifierExtension subjectKeyIdentifierExtension;
            object2 = EntryFactory.getKeyIdentifier(this.publicKey);
            object = null;
            object = extension != null ? (SubjectKeyIdentifierExtension)extension : new SubjectKeyIdentifierExtension(new KeyIdentifier((byte[])object2).getIdentifier());
            certificateExtensions.set("SubjectKeyIdentifier", object);
            if (this.ca_signer != null && (subjectKeyIdentifierExtension = this.ca_signer.getSubjectKeyIdentifierExtension()) != null) {
                pKCSAttribute2 = subjectKeyIdentifierExtension.get("key_id");
                pKCS9DerObject = new AuthorityKeyIdentifierExtension((KeyIdentifier)pKCSAttribute2, null, null);
                certificateExtensions.set("AuthorityKeyIdentifier", (Object)pKCS9DerObject);
            }
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        object2 = Calendar.getInstance();
        object = ((Calendar)object2).getTime();
        ((Calendar)object2).add(6, n);
        Date date = ((Calendar)object2).getTime();
        pKCSAttribute2 = new CertificateValidity((Date)object, date);
        try {
            x509CertInfo.set("version", (Object)certificateVersion);
            x509CertInfo.set("serialNumber", (Object)certificateSerialNumber);
            x509CertInfo.set("algorithmID", (Object)algorithmId2);
            x509CertInfo.set("issuer", (Object)x500Name2);
            x509CertInfo.set("validity", (Object)pKCSAttribute2);
            x509CertInfo.set("subject", (Object)x500Name3);
            x509CertInfo.set("key", (Object)certificationRequest.getCertRequestInfo().getSubjectPublicKeyInfo());
            if (certificateExtensions != null && certificateExtensions.getAllExtensions().size() > 0) {
                x509CertInfo.set("extensions", (Object)certificateExtensions);
            }
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_CREATE_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PUBLIC_KEY_COPY_ERROR, (Throwable)invalidKeyException);
        }
        try {
            return new X509CertImpl(x509CertInfo, string);
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)certificateParsingException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)certificateEncodingException);
        }
    }

    public CertificateItemImpl sign(CertificateKeyItem certificateKeyItem, int n, Integer n2, String string) throws KeyManagerException {
        try {
            this.ca_signer = certificateKeyItem;
            String string2 = certificateKeyItem.getSignatureAlgorithm().getOID();
            AlgorithmId algorithmId = KeymanUtil.getSignatureAlgorithm(string2);
            X509CertImpl x509CertImpl = (X509CertImpl)this.createCertificate(certificateKeyItem.getSubjectDN().getX500Name(), n, n2, algorithmId, null, string);
            if (KeymanUtil.isIBMJCE()) {
                x509CertImpl.sign(certificateKeyItem.getPrivateKey(), string2, string);
            } else {
                x509CertImpl.sign(certificateKeyItem.getPrivateKey(), string2);
            }
            return new CertificateItemImpl(this.getLabel(), (X509Certificate)x509CertImpl);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_FOR_SIGNING, invalidKeyException, new String[]{this.getLabel()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{KeymanUtil.getJCEProviderName()});
        }
        catch (SignatureException signatureException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.SIGNATURE_ERROR, signatureException, new String[]{this.getLabel()});
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String toLongString() {
        return Messages.getString("Label.Label") + " " + this.getLabel() + "\n" + Messages.getString("Label.KeySize") + KeymanUtil.getLocalisedColon() + " " + this.keySize + "\n" + Messages.getString("Label.Subject") + KeymanUtil.getLocalisedColon() + " " + this.subjectDN.toString() + "\n" + Messages.getString("Label.Fingerprint") + " " + this.fingerprint + "\n" + Messages.getString("Label.SigAlg") + KeymanUtil.getLocalisedColon() + " " + this.signatureAlgorithm.toString() + "\n";
    }

    public KeymanTree toTree() {
        KeymanTree keymanTree = new KeymanTree(KeymanTree.newNode(this.getLabel()));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode = (KeymanTree$KeymanTreeNode)keymanTree.getRoot();
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode2 = keymanTree$KeymanTreeNode.addChild(KeymanTree.newNode(Messages.getString("Label.CertificationRequest")));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode3 = keymanTree$KeymanTreeNode2.addChild(KeymanTree.newNode(Messages.getString("Label.CertificationRequestInfo")));
        keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.Version"), this.version.toString()));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode4 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.Subject")));
        keymanTree$KeymanTreeNode4.addChildren(this.subjectDN.getTreeNodes());
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode5 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKeyInfo")));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode6 = keymanTree$KeymanTreeNode5.addChild(KeymanTree.newNode(Messages.getString("Label.Algorithm")));
        keymanTree$KeymanTreeNode6.addChildren(this.publicKeyAlgorithm.getTreeNodes());
        keymanTree$KeymanTreeNode5.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKey"), new ByteArray(this.publicKey.getEncoded()).toString()));
        if (this.attributes.size() > 0) {
            keymanTree$KeymanTreeNode6 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.Attributes")));
            for (DisplayItemFactory$TreeDisplayItem displayItemFactory$TreeDisplayItem : this.attributes) {
                keymanTree$KeymanTreeNode6.addChildren(displayItemFactory$TreeDisplayItem.getTreeNodes());
            }
        }
        keymanTree$KeymanTreeNode6 = keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.SigAlg")));
        keymanTree$KeymanTreeNode6.addChildren(this.signatureAlgorithm.getTreeNodes());
        keymanTree$KeymanTreeNode3.addChild(KeymanTree.newNode(Messages.getString("Label.SigVal"), this.signature.toString()));
        return keymanTree;
    }

    public void setLabel(String string) {
        throw new UnsupportedOperationException("A certificate request label cannot be changed.");
    }

    public KeyStore.Entry toKeyStoreEntry() {
        throw new UnsupportedOperationException("method toKeyStoreEntry");
    }

    public DisplayItemFactory$AlgorithmItem getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String get(Details$DetailIdentifier details$DetailIdentifier) throws KeyManagerException {
        switch (details$DetailIdentifier) {
            case KeySize: {
                return this.keySize + "";
            }
            case Subject: {
                return this.subjectDN.toString();
            }
            case Fingerprint: {
                return this.fingerprint.toString();
            }
            case SignatureAlgorithm: {
                return this.signatureAlgorithm.toString();
            }
        }
        return super.get(details$DetailIdentifier);
    }

    public boolean isValid() {
        return true;
    }

    public CertificateItem sign(CertificateKeyItem certificateKeyItem, int n, Integer n2, String string) throws KeyManagerException {
        return this.sign(certificateKeyItem, n, n2, string);
    }
}

