/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.gui.KeymanController;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.command.gui.KeymanView$UpdateType;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CertificateDetailsDialog;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$1;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$AddProviderAction;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$CheckboxMenuItemActionListener;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$CreateCertRequestAction;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$CreateSelfsignedCertAction;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$LookAndFeelAction;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$NewDatabaseAction;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$OpenDatabaseAction;
import com.ibm.gsk.ikeyman.gui.KeymanFrame$SaveAsAction;
import com.ibm.gsk.ikeyman.gui.panels.MainPanel;
import com.ibm.gsk.ikeyman.io.Logger;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.Displayable;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public final class KeymanFrame
extends JFrame
implements KeymanView {
    private static final String WIN_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String MAC_LOOK_AND_FEEL = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JMenuBar mainMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu createMenu = null;
    private JMenu viewMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem newMenuItem = null;
    private JMenuItem openMenuItem = null;
    private JMenuItem newProviderMenuItem = null;
    private JMenuItem closeMenuItem = null;
    private JMenuItem saveAsMenuItem = null;
    private JMenuItem changePasswordMenuItem = null;
    private JMenuItem stashPasswordMenuItem = null;
    private JMenuItem displayPasswordExpiryMenuItem = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem newCertRequestMenuItem = null;
    private JMenuItem newSelfSignedMenuItem = null;
    private JToolBar toolBar = null;
    private JPanel statusBar = null;
    private JLabel statusLabel = null;
    private MainPanel mainPanel = null;
    private JPanel centrePanel = null;
    private KeymanController controller;
    private final KeymanFrame$NewDatabaseAction newDatabaseAction;
    private final KeymanFrame$OpenDatabaseAction openDatabaseAction;
    private final KeymanFrame$CreateCertRequestAction createCertRequestAction;
    private final KeymanFrame$CreateSelfsignedCertAction createSelfSignedCertAction;
    private final KeymanFrame$SaveAsAction saveAsAction;
    private final KeymanFrame$AddProviderAction addProviderAction;
    private KeyStoreInfo keyStore;
    private JMenuItem aboutMenu = null;
    private JCheckBoxMenuItem toolbarMenuItem = null;
    private JCheckBoxMenuItem statusbarMenuItem = null;
    private JCheckBoxMenuItem tooltipsMenuItem = null;
    private JRadioButtonMenuItem metalLnFMenu = null;
    private final KeymanFrame$CheckboxMenuItemActionListener checkboxMenuItemListener = new KeymanFrame$CheckboxMenuItemActionListener(this, null);

    public KeymanFrame() {
        this((KeymanController)null);
    }

    public KeymanFrame(KeymanController keymanController) {
        UIManager.put("OptionPane.okButtonMnemonic", new Integer(79).toString());
        UIManager.put("OptionPane.cancelButtonMnemonic", new Integer(67).toString());
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        this.controller = keymanController == null ? new KeymanController(this, this) : keymanController;
        this.newDatabaseAction = new KeymanFrame$NewDatabaseAction(this.controller);
        this.openDatabaseAction = new KeymanFrame$OpenDatabaseAction(this.controller);
        this.createCertRequestAction = new KeymanFrame$CreateCertRequestAction(this.controller);
        this.createSelfSignedCertAction = new KeymanFrame$CreateSelfsignedCertAction(this.controller);
        this.saveAsAction = new KeymanFrame$SaveAsAction(this.controller);
        this.addProviderAction = new KeymanFrame$AddProviderAction(this.controller);
        this.initialize();
    }

    private void initialize() {
        this.setSize(1000, 705);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/ibm/gsk/ikeyman/data/ikeyman.gif")));
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getMainMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setName(ControlNames.KeymanFrame.toString());
        this.updateTitle(null);
        this.centerFrame();
        this.updateDatabase(null);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.updateMainActions(true);
    }

    private void setActionsEnabled(boolean bl) {
        this.createCertRequestAction.setEnabled(bl);
        this.createSelfSignedCertAction.setEnabled(bl);
        this.closeMenuItem.setEnabled(bl);
        if (this.keyStore != null) {
            DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor = this.keyStore.getDescriptor();
            this.saveAsAction.setEnabled(databaseDescriptorFactory$DatabaseDescriptor.allowsAction(Constants$CommandType.ConvertDB) ? bl : false);
            this.changePasswordMenuItem.setEnabled(databaseDescriptorFactory$DatabaseDescriptor.allowsAction(Constants$CommandType.ChangeDBPassword) ? bl : false);
            this.stashPasswordMenuItem.setEnabled(databaseDescriptorFactory$DatabaseDescriptor.allowsAction(Constants$CommandType.StashDBPassword) ? bl : false);
            this.displayPasswordExpiryMenuItem.setEnabled(databaseDescriptorFactory$DatabaseDescriptor.allowsAction(Constants$CommandType.DisplayDBPasswordExpiry) ? bl : false);
        } else {
            this.saveAsAction.setEnabled(bl);
            this.changePasswordMenuItem.setEnabled(bl);
            this.stashPasswordMenuItem.setEnabled(bl);
            this.displayPasswordExpiryMenuItem.setEnabled(bl);
        }
    }

    private void setMainActionsEnabled(boolean bl) {
        this.newDatabaseAction.setEnabled(bl);
        this.openDatabaseAction.setEnabled(bl);
    }

    private void centerFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)((dimension.getWidth() - (double)this.getWidth()) / 2.0);
        int n2 = (int)((dimension.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(n, n2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getToolBar(), "North");
            this.jContentPane.add((Component)this.getCentrePanel(), "Center");
            this.jContentPane.add((Component)this.getStatusBar(), "South");
        }
        return this.jContentPane;
    }

    private JMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new JMenuBar();
            this.mainMenuBar.add(this.getFileMenu());
            this.mainMenuBar.add(this.getCreateMenu());
            this.mainMenuBar.add(this.getViewMenu());
            this.mainMenuBar.add(this.getHelpMenu());
        }
        return this.mainMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.File"), this.fileMenu);
            this.fileMenu.add(this.getNewMenuItem());
            this.fileMenu.add(this.getOpenMenuItem());
            this.fileMenu.add(this.getNewProviderMenuItem());
            this.fileMenu.add(this.getCloseMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getSaveAsMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getChangePasswordMenuItem());
            this.fileMenu.add(this.getStashPasswordMenuItem());
            this.fileMenu.add(this.getDisplayPasswordExpiryMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExitMenuItem());
            this.fileMenu.setName(ControlNames.KeymanFrameFileMenu.toString());
        }
        return this.fileMenu;
    }

    private JMenu getCreateMenu() {
        if (this.createMenu == null) {
            this.createMenu = new JMenu();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Create"), this.createMenu);
            this.createMenu.add(this.getNewCertRequestMenuItem());
            this.createMenu.add(this.getNewSelfSignedMenuItem());
            this.createMenu.setName(ControlNames.KeymanFrameCreateMenu.toString());
        }
        return this.createMenu;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            ButtonGroup buttonGroup = new ButtonGroup();
            this.metalLnFMenu = new JRadioButtonMenuItem();
            this.metalLnFMenu.setAction(new KeymanFrame$LookAndFeelAction(this, UIManager.getCrossPlatformLookAndFeelClassName()));
            this.metalLnFMenu.setSelected(true);
            this.metalLnFMenu.setName(ControlNames.KeymanFrameMetalLnFMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.LnF.Metal"), this.metalLnFMenu);
            this.viewMenu.add(this.metalLnFMenu);
            buttonGroup.add(this.metalLnFMenu);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jRadioButtonMenuItem.setAction(new KeymanFrame$LookAndFeelAction(this, WIN_LOOK_AND_FEEL));
            jRadioButtonMenuItem.setName(ControlNames.KeymanFrameWindowsLnFMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.LnF.Windows"), jRadioButtonMenuItem);
            jRadioButtonMenuItem.getAccessibleContext().setAccessibleName(jRadioButtonMenuItem.getText());
            this.viewMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setVisible(KeymanUtil.isWindowsSystem());
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
            jRadioButtonMenuItem2.setAction(new KeymanFrame$LookAndFeelAction(this, MAC_LOOK_AND_FEEL));
            jRadioButtonMenuItem2.setName(ControlNames.KeymanFrameMacLnFMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.LnF.Mac"), jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.getAccessibleContext().setAccessibleName(jRadioButtonMenuItem2.getText());
            this.viewMenu.add(jRadioButtonMenuItem2);
            buttonGroup.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.setVisible(KeymanUtil.isMacSystem());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getToolbarMenuItem());
            this.viewMenu.add(this.getStatusbarMenuItem());
            this.viewMenu.add(this.getTooltipsMenuItem());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.View"), this.viewMenu);
            this.viewMenu.setName(ControlNames.KeymanFrameViewMenu.toString());
        }
        return this.viewMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Help"), this.helpMenu);
            this.helpMenu.add(this.getAboutMenu());
            this.helpMenu.setName(ControlNames.KeymanFrameHelpMenu.toString());
        }
        return this.helpMenu;
    }

    private JMenuItem getNewMenuItem() {
        if (this.newMenuItem == null) {
            this.newMenuItem = new JMenuItem();
            this.newMenuItem.setAction(this.newDatabaseAction);
            this.newMenuItem.setName(ControlNames.KeymanFrameNewMenuItem.toString());
        }
        return this.newMenuItem;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem();
            this.openMenuItem.setAction(this.openDatabaseAction);
            this.openMenuItem.setName(ControlNames.KeymanFrameOpenMenuItem.toString());
        }
        return this.openMenuItem;
    }

    private JMenuItem getNewProviderMenuItem() {
        if (this.newProviderMenuItem == null) {
            this.newProviderMenuItem = new JMenuItem();
            this.newProviderMenuItem.setAction(this.addProviderAction);
            this.newProviderMenuItem.setName(ControlNames.KeymanFrameNewProviderMenuItem.toString());
        }
        return this.newProviderMenuItem;
    }

    private JMenuItem getCloseMenuItem() {
        if (this.closeMenuItem == null) {
            this.closeMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Close"), this.closeMenuItem);
            this.closeMenuItem.addActionListener(this.controller);
            this.closeMenuItem.setActionCommand(Constants$CommandType.CloseDb.toString());
            this.closeMenuItem.setToolTipText(Messages.getString("Tooltip.CloseDb"));
            this.closeMenuItem.setName(ControlNames.KeymanFrameCloseMenuItem.toString());
        }
        return this.closeMenuItem;
    }

    private JMenuItem getSaveAsMenuItem() {
        if (this.saveAsMenuItem == null) {
            this.saveAsMenuItem = new JMenuItem();
            this.saveAsMenuItem.setAction(this.saveAsAction);
            this.saveAsMenuItem.setName(ControlNames.KeymanFrameSaveAsMenuItem.toString());
        }
        return this.saveAsMenuItem;
    }

    private JMenuItem getChangePasswordMenuItem() {
        if (this.changePasswordMenuItem == null) {
            this.changePasswordMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.ChangePassword"), this.changePasswordMenuItem);
            this.changePasswordMenuItem.addActionListener(this.controller);
            this.changePasswordMenuItem.setActionCommand(Constants$CommandType.ChangeDBPassword.toString());
            this.changePasswordMenuItem.setToolTipText(Messages.getString("Tooltip.ChangePassword"));
            this.changePasswordMenuItem.setName(ControlNames.KeymanFrameChangePasswordMenuItem.toString());
        }
        return this.changePasswordMenuItem;
    }

    private JMenuItem getStashPasswordMenuItem() {
        if (this.stashPasswordMenuItem == null) {
            this.stashPasswordMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.StashPassword"), this.stashPasswordMenuItem);
            this.stashPasswordMenuItem.addActionListener(this.controller);
            this.stashPasswordMenuItem.setActionCommand(Constants$CommandType.StashDBPassword.toString());
            this.stashPasswordMenuItem.setToolTipText(Messages.getString("Tooltip.StashPassword"));
            this.stashPasswordMenuItem.setName(ControlNames.KeymanFrameStashPasswordMenuItem.toString());
        }
        return this.stashPasswordMenuItem;
    }

    private JMenuItem getDisplayPasswordExpiryMenuItem() {
        if (this.displayPasswordExpiryMenuItem == null) {
            this.displayPasswordExpiryMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.DisplayPasswordExpiry"), this.displayPasswordExpiryMenuItem);
            this.displayPasswordExpiryMenuItem.addActionListener(this.controller);
            this.displayPasswordExpiryMenuItem.setActionCommand(Constants$CommandType.DisplayDBPasswordExpiry.toString());
            this.displayPasswordExpiryMenuItem.setToolTipText(Messages.getString("Tooltip.DisplayPasswordExpiry"));
            this.displayPasswordExpiryMenuItem.setName(ControlNames.KeymanFrameDisplayPasswordExpiryMenuItem.toString());
        }
        return this.displayPasswordExpiryMenuItem;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Exit"), this.exitMenuItem);
            this.exitMenuItem.addActionListener(new KeymanFrame$1(this));
            this.exitMenuItem.setToolTipText(Messages.getString("Tooltip.Exit"));
            this.exitMenuItem.setName(ControlNames.KeymanFrameExitMenuItem.toString());
        }
        return this.exitMenuItem;
    }

    private void exit() {
        System.exit(0);
    }

    private JMenuItem getNewCertRequestMenuItem() {
        if (this.newCertRequestMenuItem == null) {
            this.newCertRequestMenuItem = new JMenuItem();
            this.newCertRequestMenuItem.setAction(this.createCertRequestAction);
            this.newCertRequestMenuItem.setName(ControlNames.KeymanFrameNewCertRequestMenuItem.toString());
        }
        return this.newCertRequestMenuItem;
    }

    private JMenuItem getNewSelfSignedMenuItem() {
        if (this.newSelfSignedMenuItem == null) {
            this.newSelfSignedMenuItem = new JMenuItem();
            this.newSelfSignedMenuItem.setAction(this.createSelfSignedCertAction);
            this.newSelfSignedMenuItem.setName(ControlNames.KeymanFrameNewSelfSignedMenuItem.toString());
        }
        return this.newSelfSignedMenuItem;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            this.toolBar.setMargin(new Insets(5, 10, 5, 10));
            this.toolBar.addSeparator();
            this.toolBar.add(this.getNewBtn());
            this.toolBar.add(this.getOpenBtn());
            this.toolBar.add(this.getSaveBtn());
            this.toolBar.add(this.getNewProviderBtn());
            this.toolBar.add(this.getNewCertRequestBtn());
            this.toolBar.add(this.getNewSelfsignedBtn());
            this.toolBar.addSeparator();
        }
        return this.toolBar;
    }

    private JButton getNewBtn() {
        JButton jButton = new JButton();
        jButton.setAction(this.newDatabaseAction);
        jButton.getAccessibleContext().setAccessibleName(Messages.getString("Menu.Item.New"));
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setName(ControlNames.KeymanFrameNewButton.toString());
        jButton.registerKeyboardAction(this.controller, "CreateDB", KeyStroke.getKeyStroke(10, 0), 0);
        return jButton;
    }

    private JButton getOpenBtn() {
        JButton jButton = new JButton();
        jButton.setAction(this.openDatabaseAction);
        jButton.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.Open")));
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setName(ControlNames.KeymanFrameOpenButton.toString());
        jButton.registerKeyboardAction(this.controller, "LoadDB", KeyStroke.getKeyStroke(10, 0), 0);
        return jButton;
    }

    private JButton getSaveBtn() {
        JButton jButton = new JButton();
        jButton.setAction(this.saveAsAction);
        jButton.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.SaveAs")));
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setName(ControlNames.KeymanFrameSaveButton.toString());
        jButton.registerKeyboardAction(this.controller, "ConvertDB", KeyStroke.getKeyStroke(10, 0), 0);
        return jButton;
    }

    private JButton getNewProviderBtn() {
        JButton jButton = new JButton();
        jButton.setAction(this.addProviderAction);
        jButton.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.NewProvider")));
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setName(ControlNames.KeymanFrameNewProviderButton.toString());
        jButton.registerKeyboardAction(this.controller, "AddProvider", KeyStroke.getKeyStroke(10, 0), 0);
        return jButton;
    }

    private JButton getNewCertRequestBtn() {
        JButton jButton = new JButton();
        jButton.setAction(this.createCertRequestAction);
        jButton.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.NewCertReq")));
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setName(ControlNames.KeymanFrameNewCertRequestButton.toString());
        jButton.registerKeyboardAction(this.controller, "CreateCertRequest", KeyStroke.getKeyStroke(10, 0), 0);
        return jButton;
    }

    private JButton getNewSelfsignedBtn() {
        JButton jButton = new JButton();
        jButton.setAction(this.createSelfSignedCertAction);
        jButton.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.NewSelfsigned")));
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setName(ControlNames.KeymanFrameNewSelfsignedButton.toString());
        jButton.registerKeyboardAction(this.controller, "CreateSSCert", KeyStroke.getKeyStroke(10, 0), 0);
        return jButton;
    }

    private JPanel getStatusBar() {
        if (this.statusBar == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText(Messages.getString("Message.Start"));
            this.statusLabel.setName(ControlNames.KeymanFrameStatusbar.toString());
            this.statusBar = new JPanel();
            this.statusBar.setLayout(new BorderLayout());
            this.statusBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createBevelBorder(1)));
            this.statusBar.add((Component)this.statusLabel, "Center");
        }
        return this.statusBar;
    }

    private MainPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new MainPanel();
            this.mainPanel.addActionListener(this.controller);
        }
        return this.mainPanel;
    }

    private JPanel getCentrePanel() {
        if (this.centrePanel == null) {
            this.centrePanel = new JPanel();
            this.centrePanel.setLayout(new BorderLayout());
            this.centrePanel.setBorder(BorderFactory.createBevelBorder(1));
            this.centrePanel.add((Component)this.getMainPanel(), "Center");
        }
        return this.centrePanel;
    }

    public void updateProviders(String string) {
        this.updateMainActions(false);
    }

    public void updateDatabase(KeyStoreInfo keyStoreInfo, KeymanView$UpdateType keymanView$UpdateType) throws KeyManagerException {
        switch (keymanView$UpdateType) {
            case Changed: {
                if (!keyStoreInfo.equals(this.keyStore)) break;
                this.updateDatabase(keyStoreInfo);
                break;
            }
            case Closed: {
                this.updateDatabase(null);
                break;
            }
            case Opened: {
                this.updateDatabase(keyStoreInfo);
            }
        }
    }

    private void updateMainActions(boolean bl) {
        try {
            KeymanUtil.validateJCEProvider();
            this.setMainActionsEnabled(true);
        }
        catch (KeyManagerException keyManagerException) {
            if (bl) {
                Logger.showError(keyManagerException);
            }
            this.setMainActionsEnabled(false);
        }
    }

    private void updateDatabase(KeyStoreInfo keyStoreInfo) {
        this.mainPanel.refreshDatabase(keyStoreInfo);
        this.keyStore = keyStoreInfo;
        this.updateTitle(keyStoreInfo);
        this.setActionsEnabled(keyStoreInfo != null);
    }

    private void updateTitle(KeyStoreInfo keyStoreInfo) {
        this.setTitle(Messages.getString("GUI.Title") + (keyStoreInfo == null ? "" : " - [" + keyStoreInfo.getDescriptor().getFileNameString() + "]"));
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public void showMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 1);
    }

    public Entry getSelectedEntry() {
        return this.mainPanel.getSelectedEntry();
    }

    public Collection getSelectedEntries() {
        return this.mainPanel.getSelectedEntries();
    }

    public KeyStoreInfo getSelectedDatabase() {
        return this.keyStore;
    }

    public int showConfirmation(String string, String string2, int n) {
        return JOptionPane.showConfirmDialog(this, string, string2, n);
    }

    public void displayDetails(Displayable displayable) throws KeyManagerException {
        CertificateDetailsDialog certificateDetailsDialog = new CertificateDetailsDialog((Frame)this, displayable, this.keyStore.getDescriptor().getType().supportsCertModifications());
        certificateDetailsDialog.addCertificateChangeListener(this.controller);
        if (!displayable.isValid()) {
            JOptionPane.showMessageDialog(this, Messages.getString("Message.ExpiredCert"), Messages.getString("GUI.Title.Warning"), 2);
        }
        certificateDetailsDialog.setVisible(true);
        certificateDetailsDialog.dispose();
    }

    public void showStatusMessage(String string) {
        this.statusLabel.setText(string);
    }

    public String getInput(String string, String string2, String string3) throws CancelledException {
        String string4;
        do {
            if ((string4 = (String)JOptionPane.showInputDialog(this, string, string2, 3, null, null, string3)) != null) continue;
            throw new CancelledException();
        } while (string4.trim().length() <= 0);
        return string4.trim();
    }

    public void setWaitStatus(boolean bl) {
        Cursor cursor = new Cursor(bl ? 3 : 0);
        this.setCursor(cursor);
    }

    private JMenuItem getAboutMenu() {
        if (this.aboutMenu == null) {
            this.aboutMenu = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.About"), this.aboutMenu);
            this.aboutMenu.addActionListener(this.controller);
            this.aboutMenu.setActionCommand(Constants$CommandType.Version.toString());
            this.aboutMenu.setName(ControlNames.KeymanFrameAboutMenuItem.toString());
        }
        return this.aboutMenu;
    }

    private JCheckBoxMenuItem getToolbarMenuItem() {
        if (this.toolbarMenuItem == null) {
            this.toolbarMenuItem = new JCheckBoxMenuItem();
            this.toolbarMenuItem.setSelected(true);
            this.toolbarMenuItem.addActionListener(this.checkboxMenuItemListener);
            this.toolbarMenuItem.setName(ControlNames.KeymanFrameToolbarMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Toolbar"), this.toolbarMenuItem);
        }
        return this.toolbarMenuItem;
    }

    private static void setMenuItemTextAndMnemonic(String string, JMenuItem jMenuItem) {
        jMenuItem.setText(KeymanUtil.getMenuItemLabel(string));
        jMenuItem.setMnemonic(KeymanUtil.getHotKeyChar(string));
    }

    private JCheckBoxMenuItem getStatusbarMenuItem() {
        if (this.statusbarMenuItem == null) {
            this.statusbarMenuItem = new JCheckBoxMenuItem();
            this.statusbarMenuItem.setSelected(true);
            this.statusbarMenuItem.addActionListener(this.checkboxMenuItemListener);
            this.statusbarMenuItem.setName(ControlNames.KeymanFrameStatusbarMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Statusbar"), this.statusbarMenuItem);
        }
        return this.statusbarMenuItem;
    }

    private JCheckBoxMenuItem getTooltipsMenuItem() {
        if (this.tooltipsMenuItem == null) {
            this.tooltipsMenuItem = new JCheckBoxMenuItem();
            this.tooltipsMenuItem.setSelected(true);
            this.tooltipsMenuItem.addActionListener(this.checkboxMenuItemListener);
            this.tooltipsMenuItem.setName(ControlNames.KeymanFrameTooltipsMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Tooltip"), this.tooltipsMenuItem);
        }
        return this.tooltipsMenuItem;
    }

    static void access$100(KeymanFrame keymanFrame) {
        keymanFrame.exit();
    }

    static JRadioButtonMenuItem access$200(KeymanFrame keymanFrame) {
        return keymanFrame.metalLnFMenu;
    }

    static JCheckBoxMenuItem access$300(KeymanFrame keymanFrame) {
        return keymanFrame.toolbarMenuItem;
    }

    static JToolBar access$400(KeymanFrame keymanFrame) {
        return keymanFrame.toolBar;
    }

    static MainPanel access$500(KeymanFrame keymanFrame) {
        return keymanFrame.mainPanel;
    }

    static JCheckBoxMenuItem access$600(KeymanFrame keymanFrame) {
        return keymanFrame.statusbarMenuItem;
    }

    static JPanel access$700(KeymanFrame keymanFrame) {
        return keymanFrame.statusBar;
    }

    static JCheckBoxMenuItem access$800(KeymanFrame keymanFrame) {
        return keymanFrame.tooltipsMenuItem;
    }
}

