/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.ChangeLabelsDialog$1;
import com.ibm.gsk.ikeyman.gui.ChangeLabelsDialog$2;
import com.ibm.gsk.ikeyman.gui.ChangeLabelsDialog$3;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogResult;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel$Orientation;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class ChangeLabelsDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JScrollPane jScrollPane = null;
    private JList labelsList = null;
    private JLabel jLabel2 = null;
    private JTextField newLabelField = null;
    private JButton applyBtn = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private String[] oldLabels;
    private String[] initialLabels = null;
    private ListModel newLabels;

    protected ChangeLabelsDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    protected ChangeLabelsDialog(Frame frame, String[] stringArray) {
        super(frame);
        this.oldLabels = stringArray;
        this.initialize();
    }

    public ChangeLabelsDialog(Frame frame, LabelMap labelMap) {
        super(frame);
        this.oldLabels = labelMap.getOldLabels();
        this.initialLabels = labelMap.getNewLabels();
        this.initialize();
    }

    public static LabelMap getLabelMap(Frame frame, String[] stringArray) throws CancelledException {
        ChangeLabelsDialog changeLabelsDialog = new ChangeLabelsDialog(frame, stringArray);
        changeLabelsDialog.setVisible(true);
        try {
            if (changeLabelsDialog.getDialogResult() == GUIConstants$DialogResult.OK) {
                LabelMap labelMap = changeLabelsDialog.getLabelMap();
                return labelMap;
            }
            throw new CancelledException();
        }
        finally {
            changeLabelsDialog.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LabelMap getLabelMap(Frame frame, LabelMap labelMap) {
        ChangeLabelsDialog changeLabelsDialog = new ChangeLabelsDialog(frame, labelMap);
        changeLabelsDialog.setVisible(true);
        try {
            if (changeLabelsDialog.getDialogResult() == GUIConstants$DialogResult.OK) {
                LabelMap labelMap2 = changeLabelsDialog.getLabelMap();
                return labelMap2;
            }
            LabelMap labelMap3 = null;
            return labelMap3;
        }
        finally {
            changeLabelsDialog.dispose();
        }
    }

    private LabelMap getLabelMap() {
        LabelMap labelMap = new LabelMap();
        for (int i = 0; i < this.newLabels.getSize(); ++i) {
            labelMap.add(this.oldLabels[i], this.newLabels.getElementAt(i).toString());
        }
        return labelMap;
    }

    private void initialize() {
        this.setSize(662, 394);
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(Messages.getString("GUI.Title.ChangeLabels"));
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.getRootPane().setDefaultButton(this.getApplyBtn());
        this.setName(ControlNames.ChangeLabelsDialog.toString());
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 6;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(10, 20, 0, 5);
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.insets = new Insets(10, 5, 10, 0);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints3.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints4.gridx = 0;
            this.jLabel2 = new MnemonicLabel();
            this.jLabel2.setText(Messages.getStringWithMnemonics("Label.EnterNewLabel"));
            this.jLabel2.setName(ControlNames.ChangeLabelsDialogEnterNewLabelLabel.toString());
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints6.gridx = 0;
            this.jLabel1 = new MnemonicLabel();
            this.jLabel1.setText(Messages.getStringWithMnemonics("Label.SelectLabel"));
            this.jLabel1.setName(ControlNames.ChangeLabelsDialogSelectLabelLabel.toString());
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(10, 5, 10, 0);
            gridBagConstraints7.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(Messages.getString("Question.ChangeLabels"));
            this.jLabel.setName(ControlNames.ChangeLabelsDialogChangeLabelsQuestion.toString());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints7);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints6);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints5);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints4);
            this.jContentPane.add((Component)this.getNewLabelField(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getApplyBtn(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints);
            this.jLabel1.setLabelFor(this.getLabelsList());
            this.jLabel2.setLabelFor(this.getNewLabelField());
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getLabelsList());
        }
        return this.jScrollPane;
    }

    private JList getLabelsList() {
        if (this.labelsList == null) {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            String[] stringArray = this.initialLabels != null ? this.initialLabels : this.oldLabels;
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
            this.labelsList = new JList(defaultListModel);
            this.labelsList.addListSelectionListener(new ChangeLabelsDialog$1(this));
            this.labelsList.setToolTipText(Messages.getString("Tooltip.ChangeLabelList"));
            this.labelsList.setSelectionMode(0);
            this.labelsList.setName(ControlNames.ChangeLabelsDialogLabelsList.toString());
        }
        return this.labelsList;
    }

    private void listValueChangedHandler() {
        if (this.labelsList.getSelectedValue() != null) {
            this.newLabelField.setText(this.labelsList.getSelectedValue().toString());
            this.newLabelField.setEditable(true);
            this.newLabelField.requestFocusInWindow();
        } else {
            this.newLabelField.setEditable(false);
        }
    }

    private JTextField getNewLabelField() {
        if (this.newLabelField == null) {
            this.newLabelField = new JTextField();
            this.newLabelField.setEditable(false);
            this.newLabelField.setToolTipText(Messages.getString("Tooltip.ChangeLabelText"));
            this.newLabelField.setName(ControlNames.ChangeLabelsDialogNewLabelField.toString());
            this.newLabelField.getDocument().addDocumentListener(new ChangeLabelsDialog$2(this));
        }
        return this.newLabelField;
    }

    private void newLabelFieldChangedHandler() {
        String string = this.labelsList.getSelectedValue().toString();
        String string2 = this.newLabelField.getText();
        this.applyBtn.setEnabled(!string2.trim().equals("") && !string2.equals(string));
    }

    private JButton getApplyBtn() {
        if (this.applyBtn == null) {
            this.applyBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.Apply"), ControlNames.ChangeLabelsDialogApplyButton);
            this.applyBtn.addActionListener(new ChangeLabelsDialog$3(this));
            this.applyBtn.setEnabled(false);
        }
        return this.applyBtn;
    }

    private void applyHandler() {
        if (this.newLabelField.getText().length() > 0) {
            int n = this.labelsList.getSelectedIndex();
            DefaultListModel defaultListModel = (DefaultListModel)this.labelsList.getModel();
            defaultListModel.set(n, this.newLabelField.getText());
            this.labelsList.repaint();
        } else {
            this.newLabelField.setEditable(false);
        }
        this.applyBtn.setEnabled(false);
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(OKResetCancelButtonPanel$Orientation.Vertical, new GUIConstants$Actions[]{GUIConstants$Actions.OK, GUIConstants$Actions.Cancel});
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    protected void okHandler() {
        this.applyHandler();
        this.setDialogResult(GUIConstants$DialogResult.OK);
        this.newLabels = this.labelsList.getModel();
        this.setVisible(false);
    }

    protected void resetHandler() {
    }

    static void access$000(ChangeLabelsDialog changeLabelsDialog) {
        changeLabelsDialog.listValueChangedHandler();
    }

    static void access$100(ChangeLabelsDialog changeLabelsDialog) {
        changeLabelsDialog.newLabelFieldChangedHandler();
    }

    static void access$200(ChangeLabelsDialog changeLabelsDialog) {
        changeLabelsDialog.applyHandler();
    }
}

