/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.io.CertificateWriter$OutputMode$OutputModeParser;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

class CommandFactory$SignCertCommand
extends Command {
    private static final Map defaults = new HashMap();

    public CommandFactory$SignCertCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(Constants$Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Format, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.CA, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanDnsName, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanEmailAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanIpAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SerNum, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.EKU, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.KU, ValidatorFactory.always())}), defaults);
        Debug.entering();
        Debug.exiting();
    }

    public ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        KeyStoreItem keyStoreItem = this.getValidKeystoreItem(commandParameters.getSourceDescriptor(CommandFactory.access$200()));
        Entry entry = keyStoreItem.getItem(commandParameters.getLabel());
        CertificateRequestItem certificateRequestItem = EntryFactory.loadCertificateRequestItem("dummyLabel", commandParameters);
        if (entry instanceof CertificateKeyItem) {
            CertificateKeyItem certificateKeyItem = (CertificateKeyItem)entry;
            Integer n = commandParameters.isParameterPresent(Constants$Parameter.SerNum) ? commandParameters.getSerNum() : null;
            CertificateItem certificateItem = certificateRequestItem.sign(certificateKeyItem, commandParameters.getExpire(), n, keyStoreItem.getKeyCreator().getProvider());
            certificateItem.extract(commandParameters.getTarget(), commandParameters.getFormat());
            for (Certificate certificate : certificateKeyItem.getCertificateChain()) {
                CertificateItem certificateItem2 = EntryFactory.newCertificateItem("dummyLabel", (X509Certificate)certificate);
                certificateItem2.extractAppend(commandParameters.getTarget(), commandParameters.getFormat());
            }
        } else {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_KEY_FOR_LABEL, new String[]{commandParameters.getLabel()});
        }
        Debug.exiting(null);
        return null;
    }

    static {
        defaults.put(Constants$Parameter.Expire, KeymanSettings$Setting.DefaultCertExpire.getInteger());
        defaults.put(Constants$Parameter.Format, KeymanSettings$Setting.DefaultCertFormat.getValue(CertificateWriter.OutputMode.class, new CertificateWriter$OutputMode$OutputModeParser()));
        defaults.put(Constants$Parameter.Target, KeymanSettings.TARGET_DEFAULT);
    }
}

