/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.KDCReqBody;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class KDCReq {
    public KDCReqBody reqBody;
    private int a;
    private int b;
    public PAData[] pAData = null;
    private static final String z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KDCReq(PAData[] pADataArray, KDCReqBody kDCReqBody, int n2) throws IOException {
        this.a = 5;
        this.b = n2;
        if (pADataArray != null) {
            this.pAData = new PAData[pADataArray.length];
            for (int n3 = 0; n3 < pADataArray.length; ++n3) {
                if (pADataArray[n3] == null) {
                    throw new IOException(z);
                }
                this.pAData[n3] = (PAData)pADataArray[n3].clone();
            }
        }
        this.reqBody = kDCReqBody;
    }

    public KDCReq() {
    }

    public KDCReq(byte[] byArray, int n2) throws Asn1Exception, IOException, KrbException {
        this.a(new DerValue(byArray), n2);
    }

    public KDCReq(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        this.a(derValue, n2);
    }

    protected void a(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        DerValue derValue2;
        DerValue derValue3;
        block16: {
            BigInteger bigInteger;
            block15: {
                if ((derValue.getTag() & 0x1F) != n2) {
                    throw new Asn1Exception(906);
                }
                derValue3 = derValue.getData().getDerValue();
                if (derValue3.getTag() != 48) {
                    throw new Asn1Exception(906);
                }
                derValue2 = derValue3.getData().getDerValue();
                if ((derValue2.getTag() & 0x1F) == 1) {
                    bigInteger = derValue2.getData().getBigInteger();
                    this.a = bigInteger.intValue();
                    if (this.a != 5) {
                        throw new KrbApErrException(39);
                    }
                    break block15;
                }
                throw new Asn1Exception(906);
            }
            derValue2 = derValue3.getData().getDerValue();
            if ((derValue2.getTag() & 0x1F) == 2) {
                bigInteger = derValue2.getData().getBigInteger();
                this.b = bigInteger.intValue();
                if (this.b != n2) {
                    throw new KrbApErrException(40);
                }
                break block16;
            }
            throw new Asn1Exception(906);
        }
        this.pAData = PAData.parseSequence(derValue3.getData(), (byte)3, true);
        derValue2 = derValue3.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        DerValue derValue4 = derValue2.getData().getDerValue();
        this.reqBody = new KDCReqBody(derValue4, this.b);
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2;
        block5: {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putInteger(BigInteger.valueOf(this.a));
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream3);
            derOutputStream3 = new DerOutputStream();
            derOutputStream3.putInteger(BigInteger.valueOf(this.b));
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream3);
            if (this.pAData == null || this.pAData.length <= 0) break block5;
            derOutputStream3 = new DerOutputStream();
            for (int i2 = 0; i2 < this.pAData.length; ++i2) {
                derOutputStream3.write(this.pAData[i2].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream3);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.reqBody.asn1Encode(this.b));
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)((byte)this.b)), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public byte[] asn1EncodeReqBody() throws Asn1Exception, IOException {
        return this.reqBody.asn1Encode(this.b);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "0&PZM\u0007g]FG\u00123[\u0014CS\fzwp\u00167".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 115;
                            break;
                        }
                        case 1: {
                            n7 = 71;
                            break;
                        }
                        case 2: {
                            n7 = 62;
                            break;
                        }
                        case 3: {
                            n7 = 52;
                            break;
                        }
                        default: {
                            n7 = 34;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }
}

