/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;

public abstract class RSASignature
extends SignatureSpi {
    private static final int a = 8;
    private final ObjectIdentifier b;
    private final int c;
    private final MessageDigest d;
    private boolean e;
    private RSAPrivateKey f;
    private RSAPublicKey g;
    private RSAPadding h;
    private static final char[] i;
    private static final String[] z;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n2) {
        this.b = objectIdentifier;
        try {
            this.d = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.e = true;
        this.c = 8 + n2 + this.d.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.f = null;
        this.g = rSAPublicKey;
        this.a(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        this.f = rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.g = null;
        this.a(rSAPrivateKey, secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a();
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            RSAUtil.checkParamsAgainstType((RSAUtil.KeyType)RSAUtil.KeyType.RSA, (AlgorithmParameterSpec)rSAKey.getParams());
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(z[4], providerException);
        }
        try {
            this.h = RSAPadding.getInstance(1, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        int n3 = this.h.getMaxDataSize();
        if (this.c > n3) {
            throw new InvalidKeyException(z[3]);
        }
    }

    private void a() {
        if (!this.e) {
            this.d.reset();
            this.e = true;
        }
    }

    private byte[] b() {
        this.e = true;
        return this.d.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.d.update(by);
        this.e = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d.update(byArray, n2, n3);
        this.e = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.d.update(byteBuffer);
        this.e = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.f == null) {
            throw new SignatureException(z[12]);
        }
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.b, byArray);
            byte[] byArray3 = this.h.pad(byArray2);
            if (byArray3 != null) {
                return RSACore.rsa(byArray3, this.f, true);
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new SignatureException(z[11], exception);
        }
        throw new SignatureException(z[10]);
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.g == null) {
            throw new SignatureException(z[6]);
        }
        if (byArray.length != RSACore.getByteLength(this.g)) {
            throw new SignatureException(z[7] + byArray.length + z[5] + RSACore.getByteLength(this.g));
        }
        try {
            byte[] byArray2 = RSACore.rsa(byArray, this.g);
            byte[] byArray3 = this.b();
            byte[] byArray4 = RSASignature.encodeSignature(this.b, byArray3);
            byte[] byArray5 = this.h.pad(byArray4);
            if (MessageDigest.isEqual(byArray5, byArray2)) {
                return true;
            }
            byArray4 = RSASignature.a(this.b, byArray3);
            byArray5 = this.h.pad(byArray4);
            return MessageDigest.isEqual(byArray5, byArray2);
        }
        catch (IOException | BadPaddingException exception) {
            return false;
        }
    }

    public static String bytesToHex(byte[] byArray) {
        if (byArray == null) {
            return new String(z[13]);
        }
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = i[n2 >>> 4];
            cArray[i2 * 2 + 1] = i[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    static byte[] a(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(objectIdentifier);
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) throw new IOException(z[2]);
        if (derInputStream.available() != 0) {
            throw new IOException(z[2]);
        }
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValueArray[0]);
        if (!algorithmId.getOID().equals((Object)objectIdentifier)) {
            throw new IOException(z[1] + algorithmId.getOID());
        }
        if (algorithmId.getEncodedParams() == null) return derValueArray[1].getOctetString();
        throw new IOException(z[0]);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[8]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException(z[14]);
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[9]);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block36: {
            int n2;
            int n3;
            block35: {
                String string;
                String[] stringArray = new String[15];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n4 = 0;
                String string2 = "$}.\u0013\u0017\u0014p?\u000e\u0003QR'\f\b\u0003z?\u0003\n8wk\u001b\u0006\u0003r&\u000e\u0013\u0014a8";
                int n5 = -1;
                block28: while (true) {
                    char[] cArray2;
                    block34: {
                        int n6;
                        block33: {
                            char[] cArray3 = string2.toCharArray();
                            cArray2 = cArray3;
                            n6 = cArray3.length;
                            n3 = 0;
                            if (!true) break block33;
                            n6 = n6;
                            if (n6 <= n3) break block34;
                        }
                        do {
                            int n7;
                            cArray2 = cArray2;
                            int n8 = n3;
                            char c2 = cArray2[n8];
                            switch (n3 % 5) {
                                case 0: {
                                    n7 = 113;
                                    break;
                                }
                                case 1: {
                                    n7 = 19;
                                    break;
                                }
                                case 2: {
                                    n7 = 75;
                                    break;
                                }
                                case 3: {
                                    n7 = 107;
                                    break;
                                }
                                default: {
                                    n7 = 103;
                                }
                            }
                            cArray2[n8] = (char)(c2 ^ n7);
                            ++n3;
                            n6 = n6;
                        } while (n6 > n3);
                    }
                    string = new String(cArray2);
                    switch (n5) {
                        default: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 1;
                            string2 = ">q!\u000e\u0004\u0005Z/\u000e\t\u0005z-\u0002\u0002\u00033&\u0002\u0014\u001cr?\b\u000fK3";
                            n5 = 0;
                            continue block28;
                        }
                        case 0: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 2;
                            string2 = "\"V\u001a>\"?P\u000eK\u000b\u0014},\u001f\u000fQv9\u0019\b\u0003";
                            n5 = 1;
                            continue block28;
                        }
                        case 1: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 3;
                            string2 = ":v2K\u000e\u00023?\u0004\bQ`#\u0004\u0015\u00053-\u0004\u0015Qg#\u0002\u0014Q`\"\f\t\u0010g>\u0019\u0002Qr'\f\b\u0003z?\u0003\n";
                            n5 = 2;
                            continue block28;
                        }
                        case 2: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 4;
                            string2 = "8}=\n\u000b\u0018wk\u0000\u0002\b3-\u0004\u0015QA\u0018*G\u0002z,\u0005\u0006\u0005f9\u000e\u0014";
                            n5 = 3;
                            continue block28;
                        }
                        case 3: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 5;
                            string2 = "Qq>\u001fG\u0006r8K\u0002\tc.\b\u0013\u0018},K";
                            n5 = 4;
                            continue block28;
                        }
                        case 4: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 6;
                            string2 = "<z8\u0018\u000e\u001ftk\u001b\u0012\u0013\u007f\"\bG\u001av2";
                            n5 = 5;
                            continue block28;
                        }
                        case 5: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 7;
                            string2 = "3r/K\u0014\u0018t%\n\u0013\u0004a.K\u000b\u0014},\u001f\u000fK3,\u0004\u0013Q";
                            n5 = 6;
                            continue block28;
                        }
                        case 6: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 8;
                            string2 = "\u0002v?;\u0006\u0003r&\u000e\u0013\u0014acBG\u001f|?K\u0014\u0004c;\u0004\u0015\u0005v/";
                            n5 = 7;
                            continue block28;
                        }
                        case 7: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 9;
                            string2 = "\u0016v?;\u0006\u0003r&\u000e\u0013\u0014acBG\u001f|?K\u0014\u0004c;\u0004\u0015\u0005v/";
                            n5 = 8;
                            continue block28;
                        }
                        case 8: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 10;
                            string2 = "2|>\u0007\u0003Q}$\u001fG\u0002z,\u0005G\u0015r?\n";
                            n5 = 9;
                            continue block28;
                        }
                        case 9: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 11;
                            string2 = "2|>\u0007\u0003Q}$\u001fG\u0002z,\u0005G\u0015r?\n";
                            n5 = 10;
                            continue block28;
                        }
                        case 10: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 12;
                            string2 = "<z8\u0018\u000e\u001ftk\u001b\u0015\u0018e*\u001f\u0002Qx.\u0012";
                            n5 = 11;
                            continue block28;
                        }
                        case 11: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 13;
                            string2 = "\\}>\u0007\u000b\\";
                            n5 = 12;
                            continue block28;
                        }
                        case 12: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 14;
                            string2 = "?|k\u001b\u0006\u0003r&\u000e\u0013\u0014a8K\u0006\u0012p.\u001b\u0013\u0014w";
                            n5 = 13;
                            continue block28;
                        }
                        case 13: 
                    }
                    break;
                }
                stringArray2[n4] = string.intern();
                z = stringArray3;
                char[] cArray4 = "A\"yXSD%|S^0Q\b/\"7".toCharArray();
                cArray = cArray4;
                n2 = cArray4.length;
                n3 = 0;
                if (!true) break block35;
                n2 = n2;
                if (n2 <= n3) break block36;
            }
            do {
                int n9;
                cArray = cArray;
                int n10 = n3;
                char c3 = cArray[n10];
                switch (n3 % 5) {
                    case 0: {
                        n9 = 113;
                        break;
                    }
                    case 1: {
                        n9 = 19;
                        break;
                    }
                    case 2: {
                        n9 = 75;
                        break;
                    }
                    case 3: {
                        n9 = 107;
                        break;
                    }
                    default: {
                        n9 = 103;
                    }
                }
                cArray[n10] = (char)(c3 ^ n9);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        i = new String(cArray).intern().toCharArray();
    }
}

