/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.DestroyFailedException;

final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;
    private AlgorithmParameterSpec keyParams;
    private BigInteger publicExponent = BigInteger.ZERO;
    private BigInteger primeP = BigInteger.ZERO;
    private BigInteger primeQ = BigInteger.ZERO;
    private BigInteger primeExponentP = BigInteger.ZERO;
    private BigInteger primeExponentQ = BigInteger.ZERO;
    private BigInteger crtCoefficient = BigInteger.ZERO;
    private static final String[] z;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.a(this.algid, bigInteger, bigInteger2);
    }

    public RSAPrivateKey(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.a(algorithmId, bigInteger, bigInteger2);
    }

    public static RSAPrivateKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(byArray);
        return rSAPrivateKey;
    }

    public static RSAPrivateKey newKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(bigInteger, bigInteger2);
        return rSAPrivateKey;
    }

    private void a(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = algorithmId;
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
        RSAKeyFactory.b(this.modulus.bitLength(), null);
        try {
            this.key = RSAPrivateKey.a(bigInteger, bigInteger2);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    protected void parseKeyBits() throws IOException {
        block7: {
            try {
                block6: {
                    DerValue derValue = new DerValue(this.key);
                    int n2 = derValue.getData().getInteger().intValue();
                    if (n2 != 0) break block6;
                    this.modulus = derValue.getData().getPositiveBigInteger();
                    this.publicExponent = derValue.getData().getPositiveBigInteger();
                    this.privateExponent = derValue.getData().getPositiveBigInteger();
                    this.primeP = derValue.getData().getPositiveBigInteger();
                    this.primeQ = derValue.getData().getPositiveBigInteger();
                    this.primeExponentP = derValue.getData().getPositiveBigInteger();
                    this.primeExponentQ = derValue.getData().getPositiveBigInteger();
                    this.crtCoefficient = derValue.getData().getPositiveBigInteger();
                    if (derValue.getData().available() == 0) break block7;
                    throw new IOException(z[1]);
                }
                this.a();
            }
            catch (IOException iOException) {
                throw new IOException(z[2], iOException);
            }
        }
    }

    private void a() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[3]);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new InvalidObjectException(z[4]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = " ~6#?c\u007f,;{\u0007T\u0011o>-r,+>y1";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                block15: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block15;
                    n5 = n5;
                    if (n5 <= n4) break block16;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 67;
                            break;
                        }
                        case 1: {
                            n6 = 17;
                            break;
                        }
                        case 2: {
                            n6 = 67;
                            break;
                        }
                        case 3: {
                            n6 = 79;
                            break;
                        }
                        default: {
                            n6 = 91;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\n\u007f5.7*uc\u001d\b\u0002A1&-\"e&\u0004>:1&!8,u*!<o1'./\"1,9>1c6!";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\n\u007f5.7*uc\u001d\b\u000213=25p7*{(t:";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\n\u007f5.7*uc\u001d\b\u0002A1&-\"e&\u0004>:90?:1b&f{&\u007f  ?*\u007f$c{'p7.{,g&=)6\u007f";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0011B\u0002\u001f)*g\";>\bt:o0&h0o:1tc!471'&)&r7#\"cu&<>1x\"#29p!#>";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

