/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.AffineCurve;
import com.ibm.crypto.provider.GenericPrimeField;
import com.ibm.crypto.provider.JacobianCurve;
import com.ibm.crypto.provider.P256PrimeField;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.crypto.provider.be;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECUtils {
    public static final int EC_SIZE_192 = 192;
    public static final int EC_SIZE_224 = 224;
    public static final int EC_SIZE_256 = 256;
    public static final int EC_SIZE_384 = 384;
    public static final int EC_SIZE_521 = 521;
    public static final int EC_CURVE_COFACTOR_1_Y2_X3 = 1;
    public static final int EC_CURVE_KOBLITZ = 2;
    public static final int EC_CURVE_DEFAULT = 0;
    private static final String[] z;

    protected static String a(ECPoint eCPoint) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(eCPoint.getAffineX().toString());
        stringBuffer.append(",");
        stringBuffer.append(eCPoint.getAffineY().toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static String a(EllipticCurve ellipticCurve) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[6]);
        stringBuffer.append(ECUtils.a(ellipticCurve.getField()));
        stringBuffer.append(z[4] + ellipticCurve.getA());
        stringBuffer.append(z[5] + ellipticCurve.getB());
        stringBuffer.append("#");
        return stringBuffer.toString();
    }

    protected static String a(ECField eCField) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[1] + eCField.getFieldSize());
        if (eCField instanceof ECFieldFp) {
            ECFieldFp eCFieldFp = (ECFieldFp)eCField;
            stringBuffer.append(z[3] + eCFieldFp.getP());
        } else if (eCField instanceof ECFieldF2m) {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            stringBuffer.append(z[0] + eCFieldF2m.getM());
            stringBuffer.append(z[2] + eCFieldF2m.getReductionPolynomial());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static PrimeField getField(int n2, BigInteger bigInteger, boolean bl2) {
        switch (n2) {
            case 256: {
                if (!bl2) break;
                return new P256PrimeField();
            }
        }
        return new GenericPrimeField(bigInteger);
    }

    public static boolean isNistPrime(BigInteger bigInteger) {
        BigInteger bigInteger2 = null;
        switch (bigInteger.bitLength()) {
            case 192: {
                bigInteger2 = be.a;
                break;
            }
            case 224: {
                bigInteger2 = be.g;
                break;
            }
            case 256: {
                bigInteger2 = be.m;
                break;
            }
            case 384: {
                bigInteger2 = be.s;
                break;
            }
            case 521: {
                bigInteger2 = be.y;
                break;
            }
            default: {
                return false;
            }
        }
        return bigInteger2.compareTo(bigInteger) == 0;
    }

    public static PrimeCurve getCurve(PrimeField primeField, BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        if (n2 == 1) {
            return new JacobianCurve(primeField, bigInteger, bigInteger2);
        }
        return new AffineCurve(primeField, bigInteger, bigInteger2);
    }

    public static PrimeCurve getCurve(PrimeField primeField, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2) {
        if (n2 == 1) {
            return new JacobianCurve(primeField, bigInteger, bigInteger2, byArray);
        }
        return new AffineCurve(primeField, bigInteger, bigInteger2, byArray);
    }

    public static PrimeCurve getPrimeCurve(EllipticCurve ellipticCurve) {
        if (ellipticCurve instanceof PrimeCurve) {
            return (PrimeCurve)ellipticCurve;
        }
        BigInteger bigInteger = ((ECFieldFp)ellipticCurve.getField()).getP();
        int n2 = 0;
        if (ECUtils.isNistPrime(bigInteger)) {
            n2 = 1;
        }
        PrimeField primeField = ECUtils.getField(ellipticCurve.getField().getFieldSize(), bigInteger, ECUtils.isNistPrime(bigInteger));
        return ECUtils.getCurve(primeField, ellipticCurve.getA(), ellipticCurve.getB(), n2);
    }

    public static ECParameterSpec getPrimeParameterSpec(ECParameterSpec eCParameterSpec) {
        if (!(eCParameterSpec.getCurve() instanceof PrimeCurve)) {
            return new ECParameterSpec(ECUtils.getPrimeCurve(eCParameterSpec.getCurve()), eCParameterSpec.getGenerator(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor());
        }
        return eCParameterSpec;
    }

    public static boolean equals(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        if (eCParameterSpec == eCParameterSpec2) {
            return true;
        }
        if (eCParameterSpec == null || eCParameterSpec2 == null) {
            return false;
        }
        return eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor() && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder()) && eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\r\u0000\u0005_";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                block17: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block17;
                    n5 = n5;
                    if (n5 <= n4) break block18;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 4;
                            break;
                        }
                        case 1: {
                            n6 = 109;
                            break;
                        }
                        case 2: {
                            n6 = 63;
                            break;
                        }
                        case 3: {
                            n6 = 127;
                            break;
                        }
                        default: {
                            n6 = 41;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u007f(|9@a\u0001[_ w\u0004E\u001a\u0013$";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\r\u001fZ\u001b\\g\u0019V\u0010G$\u001dP\u0013Pj\u0002R\u0016HhW\u001f";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\r\u001d\u0005_";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\r\f\u0005_";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\r\u000f\u0005_";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "'(S\u0013@t\u0019V\u001cjq\u001fI\u001a\t";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

