/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.SharedAbstractHelperFactory;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassHelper;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassTokenHelper;
import com.ibm.oti.shared.SharedClassTokenHelperImpl;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import com.ibm.oti.shared.SharedClassURLClasspathHelperImpl;
import com.ibm.oti.shared.SharedClassURLHelper;
import com.ibm.oti.shared.SharedClassURLHelperImpl;
import com.ibm.oti.shared.SharedHelper;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.net.URL;
import java.util.WeakHashMap;

final class SharedClassHelperFactoryImpl
extends SharedAbstractHelperFactory
implements SharedClassHelperFactory {
    private static final WeakHashMap<ClassLoader, SharedHelper> helpers = new WeakHashMap();
    private static SharedClassFilter globalSharingFilter;
    private static final String GLOBAL_SHARING_FILTER = "com.ibm.oti.shared.SharedClassGlobalFilterClass";

    SharedClassHelperFactoryImpl() {
    }

    private static SharedClassFilter getGlobalSharingFilter() {
        if (globalSharingFilter == null) {
            try {
                String className = VM.internalGetProperties().getProperty(GLOBAL_SHARING_FILTER);
                if (null != className) {
                    Class<?> filterClass = Class.forName(className);
                    globalSharingFilter = (SharedClassFilter)SharedClassFilter.class.cast(filterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return globalSharingFilter;
    }

    @Override
    public SharedClassHelper findHelperForClassLoader(ClassLoader loader) {
        return (SharedClassHelper)helpers.get(loader);
    }

    @Override
    public SharedClassTokenHelper getTokenHelper(ClassLoader loader, SharedClassFilter filter) throws HelperAlreadyDefinedException {
        SharedClassTokenHelper helper = this.getTokenHelper(loader);
        if (helper != null) {
            helper.setSharingFilter(filter);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedClassTokenHelper getTokenHelper(ClassLoader loader) throws HelperAlreadyDefinedException {
        if (loader == null) {
            return null;
        }
        WeakHashMap<ClassLoader, SharedHelper> weakHashMap = helpers;
        synchronized (weakHashMap) {
            SharedClassHelper helper = this.findHelperForClassLoader(loader);
            if (helper != null) {
                if (helper instanceof SharedClassTokenHelper) {
                    return (SharedClassTokenHelper)helper;
                }
                throw new HelperAlreadyDefinedException(Msg.getString("K059d"));
            }
            boolean canFind = SharedClassHelperFactoryImpl.canFind(loader);
            boolean canStore = SharedClassHelperFactoryImpl.canStore(loader);
            if (canFind || canStore) {
                SharedClassTokenHelperImpl result = new SharedClassTokenHelperImpl(loader, SharedClassHelperFactoryImpl.getNewID(), canFind, canStore);
                SharedClassFilter filter = SharedClassHelperFactoryImpl.getGlobalSharingFilter();
                if (filter != null) {
                    result.setSharingFilter(filter);
                }
                helpers.put(loader, result);
                return result;
            }
            return null;
        }
    }

    @Override
    public SharedClassURLHelper getURLHelper(ClassLoader loader, SharedClassFilter filter) throws HelperAlreadyDefinedException {
        SharedClassURLHelper helper = this.getURLHelper(loader);
        if (helper != null) {
            helper.setSharingFilter(filter);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedClassURLHelper getURLHelper(ClassLoader loader) throws HelperAlreadyDefinedException {
        if (loader == null) {
            return null;
        }
        WeakHashMap<ClassLoader, SharedHelper> weakHashMap = helpers;
        synchronized (weakHashMap) {
            SharedClassHelper helper = this.findHelperForClassLoader(loader);
            if (helper != null) {
                if (helper instanceof SharedClassURLHelper) {
                    return (SharedClassURLHelper)helper;
                }
                throw new HelperAlreadyDefinedException(Msg.getString("K059d"));
            }
            boolean canFind = SharedClassHelperFactoryImpl.canFind(loader);
            boolean canStore = SharedClassHelperFactoryImpl.canStore(loader);
            if (canFind || canStore) {
                SharedClassURLHelperImpl result = new SharedClassURLHelperImpl(loader, SharedClassHelperFactoryImpl.getNewID(), canFind, canStore);
                SharedClassFilter filter = SharedClassHelperFactoryImpl.getGlobalSharingFilter();
                if (filter != null) {
                    result.setSharingFilter(filter);
                }
                helpers.put(loader, result);
                return result;
            }
            return null;
        }
    }

    @Override
    public SharedClassURLClasspathHelper getURLClasspathHelper(ClassLoader loader, URL[] classpath, SharedClassFilter filter) throws HelperAlreadyDefinedException {
        SharedClassURLClasspathHelper helper = this.getURLClasspathHelper(loader, classpath);
        if (helper != null) {
            helper.setSharingFilter(filter);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedClassURLClasspathHelper getURLClasspathHelper(ClassLoader loader, URL[] classpath) throws HelperAlreadyDefinedException {
        if (loader == null || classpath == null) {
            return null;
        }
        WeakHashMap<ClassLoader, SharedHelper> weakHashMap = helpers;
        synchronized (weakHashMap) {
            SharedClassHelper helper = this.findHelperForClassLoader(loader);
            boolean found = true;
            if (helper != null) {
                if (helper instanceof SharedClassURLClasspathHelper) {
                    SharedClassURLClasspathHelperImpl result = (SharedClassURLClasspathHelperImpl)helper;
                    URL[] testCP = result.getClasspath();
                    for (int j = 0; j < classpath.length; ++j) {
                        if (classpath[j].equals(testCP[j])) continue;
                        found = false;
                        break;
                    }
                    if (found) {
                        return result;
                    }
                    throw new HelperAlreadyDefinedException(Msg.getString("K059e"));
                }
                throw new HelperAlreadyDefinedException(Msg.getString("K059d"));
            }
            boolean canFind = SharedClassHelperFactoryImpl.canFind(loader);
            boolean canStore = SharedClassHelperFactoryImpl.canStore(loader);
            if (canFind || canStore) {
                SharedClassURLClasspathHelperImpl result = new SharedClassURLClasspathHelperImpl(loader, classpath, SharedClassHelperFactoryImpl.getNewID(), canFind, canStore);
                SharedClassFilter filter = SharedClassHelperFactoryImpl.getGlobalSharingFilter();
                if (filter != null) {
                    result.setSharingFilter(filter);
                }
                helpers.put(loader, result);
                return result;
            }
            return null;
        }
    }
}

