/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.AttributeEntry;
import com.ibm.idl.GenFileStream;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.toJavaPortable.Arguments;
import com.ibm.idl.toJavaPortable.AuxGen;
import com.ibm.idl.toJavaPortable.Compile;
import com.ibm.idl.toJavaPortable.MethodGen;
import com.ibm.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Skeleton
implements AuxGen {
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected String className = null;
    protected boolean tie = false;
    protected Vector methodList = null;
    protected String intfName = "";

    @Override
    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        ValueEntry valueEntry;
        if ((((Arguments)Compile.compiler.arguments).suppress & 8) != 0) {
            return;
        }
        if (symtabEntry instanceof ValueEntry && ((valueEntry = (ValueEntry)symtabEntry).supports().size() == 0 || ((InterfaceEntry)valueEntry.supports().elementAt(0)).isAbstract())) {
            return;
        }
        if (((InterfaceEntry)symtabEntry).isAbstract()) {
            return;
        }
        this.symbolTable = hashtable;
        this.i = (InterfaceEntry)symtabEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected abstract void init();

    protected abstract void openStream();

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)1);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        this.writeClassDeclaration();
        this.stream.println('{');
        this.stream.println();
    }

    protected abstract void writeClassDeclaration();

    protected abstract void writeBody();

    protected void writeDispatchMethod() {
        String string = "                                ";
        this.stream.println("  public org.omg.CORBA.portable.OutputStream _invoke (String $method,");
        this.stream.println(string + "org.omg.CORBA.portable.InputStream in,");
        this.stream.println(string + "org.omg.CORBA.portable.ResponseHandler $rh)");
        this.stream.println("  {");
        this.stream.println("    org.omg.CORBA.portable.OutputStream out = null;");
        this.stream.println("    java.lang.Integer __method = (java.lang.Integer)_methods.get ($method);");
        this.stream.println("    if (__method == null)");
        this.stream.println("      throw new org.omg.CORBA.BAD_OPERATION (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
        this.stream.println();
        if (this.methodList.size() > 0) {
            this.stream.println("    switch (__method.intValue ())");
            this.stream.println("    {");
            int n = 0;
            for (int i = 0; i < this.methodList.size(); ++i) {
                MethodEntry methodEntry = (MethodEntry)this.methodList.elementAt(i);
                ((MethodGen)methodEntry.generator()).dispatchSkeleton(this.symbolTable, methodEntry, this.stream, n);
                if (methodEntry instanceof AttributeEntry && !((AttributeEntry)methodEntry).readOnly()) {
                    n += 2;
                    continue;
                }
                ++n;
            }
            string = "       ";
            this.stream.println(string + "default:");
            this.stream.println(string + "  throw new org.omg.CORBA.BAD_OPERATION (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
            this.stream.println("    }");
            this.stream.println();
        }
        this.stream.println("    return out;");
        this.stream.println("  } // _invoke");
        this.stream.println();
    }

    protected void writeClosing() {
        this.stream.println();
        if (this.tie) {
            this.stream.println("} // class " + this.className);
        } else {
            this.stream.println("} // class _" + this.className);
        }
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void buildMethodList() {
        this.methodList = new Vector();
        this.buildMethodList(this.i);
    }

    private void buildMethodList(InterfaceEntry interfaceEntry) {
        Enumeration enumeration = interfaceEntry.methods().elements();
        while (enumeration.hasMoreElements()) {
            this.addMethod((MethodEntry)enumeration.nextElement());
        }
        Enumeration enumeration2 = interfaceEntry.derivedFrom().elements();
        while (enumeration2.hasMoreElements()) {
            InterfaceEntry interfaceEntry2 = (InterfaceEntry)enumeration2.nextElement();
            if (interfaceEntry2.name().equals("Object")) continue;
            this.buildMethodList(interfaceEntry2);
        }
    }

    private void addMethod(MethodEntry methodEntry) {
        if (!this.methodList.contains(methodEntry)) {
            this.methodList.addElement(methodEntry);
        }
    }

    protected void writeMethodTable() {
        this.stream.println("  private static java.util.Hashtable _methods = new java.util.Hashtable ();");
        this.stream.println("  static");
        this.stream.println("  {");
        int n = -1;
        Enumeration enumeration = this.methodList.elements();
        while (enumeration.hasMoreElements()) {
            MethodEntry methodEntry = (MethodEntry)enumeration.nextElement();
            if (methodEntry instanceof AttributeEntry) {
                this.stream.println("    _methods.put (\"_get_" + Util.stripLeadingUnderscores(methodEntry.name()) + "\", new java.lang.Integer (" + ++n + "));");
                if (((AttributeEntry)methodEntry).readOnly()) continue;
                this.stream.println("    _methods.put (\"_set_" + Util.stripLeadingUnderscores(methodEntry.name()) + "\", new java.lang.Integer (" + ++n + "));");
                continue;
            }
            this.stream.println("    _methods.put (\"" + Util.stripLeadingUnderscores(methodEntry.name()) + "\", new java.lang.Integer (" + ++n + "));");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected abstract void writeMethods();

    protected void writeIDs() {
        Vector vector = new Vector();
        this.buildIDList(this.i, vector);
        Enumeration enumeration = vector.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                this.stream.println(", ");
            }
            this.stream.print("    \"" + (String)enumeration.nextElement() + '\"');
        }
    }

    private void buildIDList(InterfaceEntry interfaceEntry, Vector vector) {
        if (!interfaceEntry.fullName().equals("org/omg/CORBA/Object")) {
            String string = Util.stripLeadingUnderscoresFromID(interfaceEntry.repositoryID().ID());
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            Enumeration enumeration = interfaceEntry.derivedFrom().elements();
            while (enumeration.hasMoreElements()) {
                this.buildIDList((InterfaceEntry)enumeration.nextElement(), vector);
            }
        }
    }

    protected void writeCORBAOperations() {
        this.stream.println("  // Type-specific CORBA::Object operations");
        this.stream.println("  private static String[] __ids = {");
        this.writeIDs();
        this.stream.println("};");
        this.stream.println();
        this.stream.println("  public String[] _ids ()");
        this.stream.println("  {");
        this.stream.println("    return __ids;");
        this.stream.println("  }");
        this.stream.println();
    }
}

