/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.CORBANotSupportedException;
import com.ibm.idl.Util;

public class CORBALevel {
    public static final float MinSupported = 2.0f;
    public static final float MaxSupported = 2.4f;
    public static final float DefaultSupported = 2.4f;
    protected float supported = 2.4f;
    protected static int minorLength = 2;
    protected static final float MinorScale = (float)Math.pow(10.0, minorLength);
    protected static final float Precision = 0.1f;
    protected static final float Threshold = 0.9f / MinorScale;

    public void set(float f) throws CORBANotSupportedException {
        if (!(f >= 2.0f) || !(f <= 2.4f)) {
            throw new CORBANotSupportedException(f);
        }
        this.supported = f;
    }

    public void set(String string) throws NumberFormatException, CORBANotSupportedException {
        float f = new Float(string).floatValue();
        this.set(f);
    }

    public float get() {
        return this.supported;
    }

    public float getMajor() {
        return (int)this.supported;
    }

    public float getMinor() {
        int n = (int)((this.supported - this.getMajor() + 0.1f / MinorScale) * MinorScale);
        return (float)n / MinorScale;
    }

    public CORBALevel() {
        minorLength = 2;
        this.supported = 2.4f;
    }

    public CORBALevel(float f) throws CORBANotSupportedException {
        this();
        this.set(f);
    }

    public CORBALevel(String string) throws CORBANotSupportedException {
        this();
        this.set(string);
    }

    public int compareTo(float f) {
        if (Util.absDelta(f, this.supported) < Threshold) {
            return 0;
        }
        if (this.supported > f) {
            return 1;
        }
        return -1;
    }

    public boolean eq(float f) {
        return this.compareTo(f) == 0;
    }

    public boolean gt(float f) {
        return this.compareTo(f) > 0;
    }

    public boolean gte(float f) {
        return this.compareTo(f) >= 0;
    }

    public boolean lt(float f) {
        return this.compareTo(f) < 0;
    }

    public boolean lte(float f) {
        return this.compareTo(f) <= 0;
    }

    public boolean inRange(float f, float f2) {
        return this.gte(f) && this.lte(f2);
    }
}

