/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.CallbackValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ComponentsValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ContactValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.DiscriminatorValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ExampleValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ExtensionValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ExternalDocumentationValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.HeaderValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.InfoValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.LicenseValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.LinkValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.MediaTypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.OAuthFlowValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.OAuthFlowsValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.OpenAPIValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.OperationValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ParameterValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.PathItemValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.PathsValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.RequestBodyValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ResponseValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ResponsesValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.SchemaValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.SecurityRequirementValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.SecuritySchemeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ServerValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ServerVariableValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ServerVariablesValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.TagValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.XMLValidator;
import com.ibm.ws.microprofile.openapi.utils.DefaultOpenAPIModelVisitor;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public final class OASValidator
extends DefaultOpenAPIModelVisitor
implements ValidationHelper {
    private OASValidationResult result;
    private final Set<String> operationIds = new HashSet<String>();
    private final Map<String, Set<String>> linkOperationIds = new HashMap<String, Set<String>>();
    private static final TraceComponent tc = Tr.register(OASValidator.class);

    public OASValidationResult validate(OpenAPI model) {
        this.result = new OASValidationResult();
        this.operationIds.clear();
        this.linkOperationIds.clear();
        OpenAPIModelWalker walker = new OpenAPIModelWalker(model);
        walker.accept(this);
        this.validateLinkOperationIds();
        OASValidationResult _result = this.result;
        this.result = null;
        return _result;
    }

    @Override
    public void addValidationEvent(OASValidationResult.ValidationEvent event) {
        if (this.result != null && event != null) {
            this.result.getEvents().add(event);
        }
    }

    @Override
    public boolean addOperationId(String operationId) {
        return !this.operationIds.add(operationId);
    }

    @Override
    public void addLinkOperationId(String operationId, String location) {
        if (this.linkOperationIds.containsKey(operationId)) {
            this.linkOperationIds.get(operationId).add(location);
        } else {
            HashSet<String> locations = new HashSet<String>();
            locations.add(location);
            this.linkOperationIds.put(operationId, locations);
        }
    }

    public void validateLinkOperationIds() {
        for (String k : this.linkOperationIds.keySet()) {
            if (this.operationIds.contains(k)) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"linkOperationIdInvalid", (Object[])new Object[]{k});
            for (String location : this.linkOperationIds.get(k)) {
                this.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, location, message));
            }
        }
    }

    @Override
    public void visitOpenAPI(OpenAPIModelWalker.Context context) {
        OpenAPIValidator v = OpenAPIValidator.getInstance();
        v.validate(this, context, context.getModel());
    }

    @Override
    public void visitComponents(OpenAPIModelWalker.Context context, Components components) {
        ComponentsValidator v = ComponentsValidator.getInstance();
        v.validate(this, context, components);
    }

    @Override
    public void visitExtension(OpenAPIModelWalker.Context context, String key, Object extension) {
        ExtensionValidator v = ExtensionValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, extension);
    }

    @Override
    public void visitExternalDocumentation(OpenAPIModelWalker.Context context, ExternalDocumentation extDocs) {
        ExternalDocumentationValidator v = ExternalDocumentationValidator.getInstance();
        v.validate(this, context, extDocs);
    }

    @Override
    public void visitInfo(OpenAPIModelWalker.Context context, Info info) {
        InfoValidator v = InfoValidator.getInstance();
        v.validate(this, context, info);
    }

    @Override
    public void visitPaths(OpenAPIModelWalker.Context context, Paths paths) {
        PathsValidator v = PathsValidator.getInstance();
        v.validate(this, context, paths);
    }

    @Override
    public void visitSecurityRequirement(OpenAPIModelWalker.Context context, SecurityRequirement sr) {
        SecurityRequirementValidator v = SecurityRequirementValidator.getInstance();
        v.validate(this, context, sr);
    }

    @Override
    public void visitServer(OpenAPIModelWalker.Context context, Server server) {
        ServerValidator v = ServerValidator.getInstance();
        v.validate(this, context, server);
    }

    @Override
    public void visitTag(OpenAPIModelWalker.Context context, Tag tag) {
        TagValidator v = TagValidator.getInstance();
        v.validate(this, context, tag);
    }

    @Override
    public void visitCallback(OpenAPIModelWalker.Context context, String key, Callback callback) {
        CallbackValidator v = CallbackValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, callback);
    }

    @Override
    public void visitExample(OpenAPIModelWalker.Context context, Example example) {
        ExampleValidator v = ExampleValidator.getInstance();
        v.validate(this, context, example);
    }

    @Override
    public void visitExample(OpenAPIModelWalker.Context context, String key, Example example) {
        ExampleValidator v = ExampleValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, example);
    }

    @Override
    public void visitHeader(OpenAPIModelWalker.Context context, String key, Header header) {
        HeaderValidator v = HeaderValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, header);
    }

    @Override
    public void visitLink(OpenAPIModelWalker.Context context, String key, Link link) {
        LinkValidator v = LinkValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, link);
    }

    @Override
    public void visitParameter(OpenAPIModelWalker.Context context, Parameter p) {
        ParameterValidator v = ParameterValidator.getInstance();
        v.validate(this, context, p);
    }

    @Override
    public void visitParameter(OpenAPIModelWalker.Context context, String key, Parameter p) {
        ParameterValidator v = ParameterValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, p);
    }

    @Override
    public void visitRequestBody(OpenAPIModelWalker.Context context, RequestBody rb) {
        RequestBodyValidator v = RequestBodyValidator.getInstance();
        v.validate(this, context, rb);
    }

    @Override
    public void visitRequestBody(OpenAPIModelWalker.Context context, String key, RequestBody rb) {
        RequestBodyValidator v = RequestBodyValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, rb);
    }

    @Override
    public void visitResponses(OpenAPIModelWalker.Context context, APIResponses responses) {
        ResponsesValidator v = ResponsesValidator.getInstance();
        v.validate(this, context, responses);
    }

    @Override
    public void visitResponse(OpenAPIModelWalker.Context context, String key, APIResponse response) {
        ResponseValidator v = ResponseValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, response);
    }

    @Override
    public void visitSchema(OpenAPIModelWalker.Context context, Schema schema) {
        SchemaValidator v = SchemaValidator.getInstance();
        v.validate(this, context, schema);
    }

    @Override
    public void visitSchema(OpenAPIModelWalker.Context context, String key, Schema schema) {
        SchemaValidator v = SchemaValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, schema);
    }

    @Override
    public void visitSecurityScheme(OpenAPIModelWalker.Context context, String key, SecurityScheme scheme) {
        SecuritySchemeValidator v = SecuritySchemeValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, scheme);
    }

    @Override
    public void visitPathItem(OpenAPIModelWalker.Context context, String key, PathItem item) {
        PathItemValidator v = PathItemValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, item);
    }

    @Override
    public void visitOperation(OpenAPIModelWalker.Context context, Operation operation) {
        OperationValidator v = OperationValidator.getInstance();
        v.validate(this, context, operation);
    }

    @Override
    public void visitMediaType(OpenAPIModelWalker.Context context, String key, MediaType mediaType) {
        MediaTypeValidator v = MediaTypeValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, mediaType);
    }

    @Override
    public void visitOAuthFlows(OpenAPIModelWalker.Context context, OAuthFlows authFlows) {
        OAuthFlowsValidator v = OAuthFlowsValidator.getInstance();
        v.validate(this, context, authFlows);
    }

    @Override
    public void visitOAuthFlow(OpenAPIModelWalker.Context context, OAuthFlow authFlow) {
        OAuthFlowValidator v = OAuthFlowValidator.getInstance();
        v.validate(this, context, authFlow);
    }

    @Override
    public void visitDiscriminator(OpenAPIModelWalker.Context context, Discriminator d) {
        DiscriminatorValidator v = DiscriminatorValidator.getInstance();
        v.validate(this, context, d);
    }

    @Override
    public void visitXML(OpenAPIModelWalker.Context context, XML xml) {
        XMLValidator v = XMLValidator.getInstance();
        v.validate(this, context, xml);
    }

    @Override
    public void visitContact(OpenAPIModelWalker.Context context, Contact contact) {
        ContactValidator v = ContactValidator.getInstance();
        v.validate(this, context, contact);
    }

    @Override
    public void visitLicense(OpenAPIModelWalker.Context context, License license) {
        LicenseValidator v = LicenseValidator.getInstance();
        v.validate(this, context, license);
    }

    @Override
    public void visitServerVariables(OpenAPIModelWalker.Context context, ServerVariables svs) {
        ServerVariablesValidator v = ServerVariablesValidator.getInstance();
        v.validate(this, context, svs);
    }

    @Override
    public void visitServerVariable(OpenAPIModelWalker.Context context, String key, ServerVariable sv) {
        ServerVariableValidator v = ServerVariableValidator.getInstance();
        v.validate((ValidationHelper)this, context, key, sv);
    }
}

