/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.RecordDataHashGenerator;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

class RecordDataHashGeneratorFactory$RecordDataHashGeneratorImpl
implements RecordDataHashGenerator {
    private static final String HASH_ALG = "SHA1";

    RecordDataHashGeneratorFactory$RecordDataHashGeneratorImpl() {
    }

    private void trace(String string) {
    }

    private Buffer generateHash(byte[] byArray) throws NoSuchAlgorithmException, NullPointerException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALG);
        byte[] byArray2 = messageDigest.digest(byArray);
        ByteSequence byteSequence = IntableByteSequenceFactory.newIntableByteSequence(messageDigest.getDigestLength()).append(ByteSequenceFactory.newByteSequence(byArray2));
        return BufferFactory.newBuffer(byteSequence.getInputStream());
    }

    public Buffer generateCertificateSignatureHash(X509Certificate x509Certificate) throws NoSuchAlgorithmException, NullPointerException, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putBitString(x509Certificate.getSignature());
        this.trace("generateCertificateSignatureHash");
        return this.generateHash(derOutputStream.toByteArray());
    }

    public Buffer generateTBSCertificateHash(X509Certificate x509Certificate) throws CertificateEncodingException, NoSuchAlgorithmException, NullPointerException, IOException {
        this.trace("generateTBSCertificateHash");
        return this.generateHash(x509Certificate.getTBSCertificate());
    }

    public Buffer generateSubjectNameHash(X509Certificate x509Certificate) throws NoSuchAlgorithmException, NullPointerException, IOException {
        this.trace("generateSubjectNameHash");
        return this.generateHash(x509Certificate.getSubjectX500Principal().getEncoded());
    }

    public Buffer generateSubjectPublicKeyInfoHash(X509Certificate x509Certificate) throws NoSuchAlgorithmException, NullPointerException, IOException {
        this.trace("generateSubjectPublicKeyInfoHash");
        return this.generateHash(x509Certificate.getPublicKey().getEncoded());
    }

    public Buffer generateIssuerAndSerialNumberHash(X509Certificate x509Certificate) throws IOException, NoSuchAlgorithmException, NullPointerException {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        byte[] byArray = x500Principal.getEncoded();
        SerialNumber serialNumber = new SerialNumber(x509Certificate.getSerialNumber());
        DerOutputStream derOutputStream = new DerOutputStream();
        serialNumber.encode(derOutputStream);
        byte[] byArray2 = derOutputStream.toByteArray();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[]{new DerValue(byArray), new DerValue(byArray2)};
        derOutputStream2.putSequence(derValueArray);
        this.trace("generateIssuerAndSerialNumberHash");
        byte[] byArray3 = derOutputStream2.toByteArray();
        Buffer buffer = this.generateHash(byArray3);
        return buffer;
    }

    public Buffer generateHash(ByteSequence byteSequence) throws NoSuchAlgorithmException, NullPointerException, IOException {
        byte[] byArray = new byte[byteSequence.length()];
        byteSequence.getInputStream().read(byArray);
        return this.generateHash(byArray);
    }
}

