/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKeyFactory;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class NonPrintableAsciiEncryptDecrypt {
    public static byte[] encrypt(char[] cArray, PrivateKey privateKey, AlgorithmId algorithmId) throws PKCSException {
        if (cArray == null || cArray.length == 0) {
            throw new InvalidParameterException("password is null or empty");
        }
        if (privateKey == null) {
            throw new InvalidParameterException("private key is null");
        }
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            NonPrintableAsciiPBEKeyFactory nonPrintableAsciiPBEKeyFactory = new NonPrintableAsciiPBEKeyFactory();
            SecretKey secretKey = nonPrintableAsciiPBEKeyFactory.engineGenerateSecret(pBEKeySpec);
            String string = algorithmId.getName().equals("PBES2") ? "PBEWithHmacSHA384AndAES_256" : algorithmId.getName();
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(1, secretKey);
            byte[] byArray = cipher.doFinal(privateKey.getEncoded());
            if (algorithmId.getParameters() == null) {
                algorithmId = new AlgorithmId(algorithmId.getOID(), cipher.getParameters());
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            algorithmId.derEncode((OutputStream)derOutputStream);
            derOutputStream.putOctetString(byArray);
            derOutputStream2.write((byte)48, derOutputStream);
            return derOutputStream2.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException((Exception)invalidKeyException, "Error initialising cipher");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new PKCSException((Exception)invalidKeySpecException, "Error generating encryption key");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException((Exception)noSuchAlgorithmException, "Error initialising cipher");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new PKCSException((Exception)noSuchPaddingException, "Error initialising cipher");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PKCSException((Exception)illegalBlockSizeException, "Error encrypting key");
        }
        catch (BadPaddingException badPaddingException) {
            throw new PKCSException((Exception)badPaddingException, "Error encrypting key");
        }
        catch (IOException iOException) {
            throw new PKCSException((Exception)iOException, iOException.toString());
        }
    }

    public static byte[] decrypt(byte[] byArray, char[] cArray, AlgorithmId algorithmId) throws PKCSException {
        if (cArray == null || cArray.length == 0) {
            throw new InvalidParameterException("password is null or empty");
        }
        if (byArray == null) {
            throw new InvalidParameterException("encrypted key is null");
        }
        try {
            AlgorithmParameters algorithmParameters = algorithmId.getAlgParameters();
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            NonPrintableAsciiPBEKeyFactory nonPrintableAsciiPBEKeyFactory = new NonPrintableAsciiPBEKeyFactory();
            SecretKey secretKey = nonPrintableAsciiPBEKeyFactory.engineGenerateSecret(pBEKeySpec);
            String string = algorithmId.getName().equals("PBES2") ? algorithmParameters.toString() : algorithmId.getName();
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(2, (Key)secretKey, algorithmParameters);
            return cipher.doFinal(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (invalidKeyException.getMessage() != null && invalidKeyException.getMessage().contains("Illegal key size")) {
                throw new RuntimeException("Illegal key size", invalidKeyException);
            }
            throw new RuntimeException("Error initialising cipher", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("Error generating decryption key", invalidKeySpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Error initialising cipher", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException("Error initialising cipher", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Error initialising cipher", invalidAlgorithmParameterException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("Error decrypting data", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("Error decrypting data", badPaddingException);
        }
    }
}

