/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BadFileTypeException;
import com.ibm.security.cmskeystore.BadMagicNumberException;
import com.ibm.security.cmskeystore.BadVersionNumberException;
import com.ibm.security.cmskeystore.ByteSequenceInputStream;
import com.ibm.security.cmskeystore.ByteSequenceInputStreamFactory;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderFactory$FileHeaderImpl;
import com.ibm.security.cmskeystore.FileType;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.MagicNumberValidator;
import com.ibm.security.cmskeystore.MagicNumberValidatorFactory;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.sequence.bytes.ByteSequence;
import java.io.IOException;
import java.io.InputStream;

final class FileHeaderFactory {
    private static final int HASH_LENGTH_V3 = 16;
    private static final int HASH_LENGTH_V4 = 20;
    private static final int HASH_LENGTH_V6 = 48;
    private static final int PASSWORD_SALT_LENGTH = 24;

    private FileHeaderFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static FileHeader newFileHeader(InputStream inputStream) throws NullPointerException, BadMagicNumberException, BadVersionNumberException, BadFileTypeException, IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        ByteSequenceInputStream byteSequenceInputStream = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        MagicNumberValidator magicNumberValidator = MagicNumberValidatorFactory.newMagicNumberValidator();
        ByteSequence byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 2);
        if (byteSequence == null) {
            return null;
        }
        if (!magicNumberValidator.isValid(byteSequence)) {
            throw new BadMagicNumberException(byteSequence);
        }
        IntableByteSequence intableByteSequence = IntableByteSequenceFactory.newIntableByteSequence(byteSequence);
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 1);
        if (byteSequence == null) {
            return null;
        }
        VersionNumber versionNumber = VersionNumber.versionNumberFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(byteSequence));
        if (versionNumber == null) {
            throw new BadVersionNumberException(byteSequence);
        }
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 1);
        if (byteSequence == null) {
            return null;
        }
        VersionNumber versionNumber2 = VersionNumber.versionNumberFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(byteSequence));
        if (versionNumber2 == null) {
            throw new BadVersionNumberException(byteSequence);
        }
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        IntableByteSequence intableByteSequence2 = IntableByteSequenceFactory.newIntableByteSequence(byteSequence);
        ByteSequence byteSequence2 = byteSequenceInputStream.getByteSequence(inputStream, 8);
        if (byteSequence2 == null) {
            return null;
        }
        FileType fileType = FileType.fileTypeFromByteSequence(byteSequence2);
        if (fileType == null) {
            throw new BadFileTypeException(fileType);
        }
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        IntableByteSequence intableByteSequence3 = IntableByteSequenceFactory.newIntableByteSequence(byteSequence);
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        IntableByteSequence intableByteSequence4 = IntableByteSequenceFactory.newIntableByteSequence(byteSequence);
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 24);
        if (byteSequence == null) {
            return null;
        }
        IntableByteSequence intableByteSequence5 = IntableByteSequenceFactory.newIntableByteSequence(byteSequence);
        int n = FileHeaderFactory.getHashLength(versionNumber, versionNumber2);
        ByteSequence byteSequence3 = byteSequenceInputStream.getByteSequence(inputStream, n);
        if (byteSequence3 == null) {
            return null;
        }
        ByteSequence byteSequence4 = byteSequenceInputStream.getByteSequence(inputStream, n);
        if (byteSequence4 == null) {
            return null;
        }
        return new FileHeaderFactory$FileHeaderImpl(intableByteSequence, versionNumber, versionNumber2, intableByteSequence2, fileType, intableByteSequence3, intableByteSequence4, intableByteSequence5, byteSequence3, byteSequence4);
    }

    private static int getHashLength(VersionNumber versionNumber, VersionNumber versionNumber2) {
        if (versionNumber.equals(VersionNumber.SIX)) {
            return 48;
        }
        if (versionNumber.equals(VersionNumber.THREE)) {
            return 16;
        }
        return 20;
    }
}

