/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.CMSPrivateKey;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory$CMSPrivateKeyDHImpl;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory$CMSPrivateKeyDSAImpl;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory$CMSPrivateKeyECImpl;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory$CMSPrivateKeyRSACrtImpl;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory$CMSPrivateKeyRSAImpl;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory$CMSPrivateKeyRSAMultiPrimeImpl;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.interfaces.DHPrivateKey;

public class CMSPrivateKeyFactory {
    public static CMSPrivateKey newCMSPrivateKey(PrivateKey privateKey, boolean bl) throws KeyStoreException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            return new CMSPrivateKeyFactory$CMSPrivateKeyRSACrtImpl((RSAPrivateCrtKey)privateKey, bl);
        }
        if (privateKey instanceof RSAPrivateKey) {
            return new CMSPrivateKeyFactory$CMSPrivateKeyRSAImpl((RSAPrivateKey)privateKey, bl);
        }
        if (privateKey instanceof RSAMultiPrimePrivateCrtKey) {
            return new CMSPrivateKeyFactory$CMSPrivateKeyRSAMultiPrimeImpl((RSAMultiPrimePrivateCrtKey)privateKey, bl);
        }
        if (privateKey instanceof ECPrivateKey) {
            return new CMSPrivateKeyFactory$CMSPrivateKeyECImpl((ECPrivateKey)privateKey, bl);
        }
        if (privateKey instanceof DSAPrivateKey) {
            return new CMSPrivateKeyFactory$CMSPrivateKeyDSAImpl((DSAPrivateKey)privateKey, bl);
        }
        if (privateKey instanceof DHPrivateKey) {
            return new CMSPrivateKeyFactory$CMSPrivateKeyDHImpl((DHPrivateKey)privateKey, bl);
        }
        throw new KeyStoreException("Invalid PrivateKey type " + privateKey.getClass());
    }
}

