/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Element;

public final class DOMRSA15
extends DOMEncryptionMethod {
    private Cipher cipher;
    private boolean padding = false;
    private SecureRandom random = null;

    public DOMRSA15(Integer keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2001/04/xmlenc#rsa-1_5", keySize, params);
    }

    public DOMRSA15(Element smElem) throws MarshalException {
        super(smElem);
    }

    public String getAlgorithmConstant() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    }

    @Override
    protected void checkParams(Integer keySize, EncryptionMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for RSA-v1.5 cipher algorithm");
        }
    }

    @Override
    protected EncryptionMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA-v1.5 cipher algorithm");
    }

    @Override
    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA-v1.5 cipher algorithm");
    }

    @Override
    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    @Override
    public byte[] decrypt(Key key, byte[] data) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key == null || data == null) {
            throw new NullPointerException("key or cipher cannot be null");
        }
        Integer keysizeInt = this.getKeySize();
        if (keysizeInt != null) {
            int keysize = keysizeInt;
            int bitLen = ((RSAPrivateKey)key).getModulus().bitLength();
            if (bitLen != keysize && (bitLen < keysize ? keysize - bitLen >= 8 : bitLen > keysize && bitLen - keysize >= 8)) {
                throw new InvalidKeyException("Keysize doesn't match the specified keysize of EncryptionMethod");
            }
        }
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING Cipher not found");
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING");
            }
        }
        this.cipher.init(2, key);
        byte[] decrypted = this.cipher.doFinal(data);
        return decrypted;
    }

    @Override
    public Key decryptKey(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException {
        return this.unwrap(key, encrypted, algo);
    }

    @Override
    public byte[] encrypt(Key key, byte[] data, EncryptedType type) throws InvalidKeyException, IllegalBlockSizeException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("key must be a RSAPublicKey");
        }
        Integer keysizeInt = this.getKeySize();
        if (keysizeInt != null) {
            Utils.checkKeySize(keysizeInt, (RSAKey)((Object)key));
        }
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING Cipher not found");
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING");
            }
        }
        this.cipher.init(1, key);
        try {
            byte[] encrypted = null;
            encrypted = this.cipher.doFinal(data);
            return encrypted;
        }
        catch (IllegalStateException ise) {
            throw new RuntimeException(ise.getMessage());
        }
        catch (BadPaddingException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    @Override
    public byte[] wrap(Key key, Key toBeWrapped) throws InvalidKeyException, IllegalBlockSizeException {
        String keyAlgo;
        if (key == null || toBeWrapped == null) {
            throw new NullPointerException();
        }
        Integer keysizeInt = this.getKeySize();
        if (keysizeInt != null) {
            Utils.checkKeySize(keysizeInt, (RSAKey)((Object)key));
        }
        if (!(keyAlgo = toBeWrapped.getAlgorithm()).equalsIgnoreCase("AES") && keyAlgo.equalsIgnoreCase("TripleDES")) {
            throw new InvalidKeyException("Wrapping of " + keyAlgo + " is not supported");
        }
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING Cipher not found");
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING");
            }
        }
        this.cipher.init(3, key);
        try {
            byte[] encrypted = null;
            encrypted = this.cipher.wrap(toBeWrapped);
            return encrypted;
        }
        catch (IllegalStateException ise) {
            throw new RuntimeException(ise.getMessage());
        }
    }

    @Override
    public byte[] unwrap(Key key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return this.unwrapKeyRaw(key, encrypted);
    }

    @Override
    public Key unwrap(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException {
        if (key == null || encrypted == null) {
            throw new NullPointerException("key pr cipher data cannot be null");
        }
        if (!(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("key must be a RSAPrivateKey");
        }
        Integer keysizeInt = this.getKeySize();
        if (keysizeInt != null) {
            Utils.checkKeySize(keysizeInt, (RSAKey)((Object)key));
        }
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING Cipher not found");
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING");
            }
        }
        this.cipher.init(4, key);
        String alg = Utils.mapAlgorithm(algo.getAlgorithm());
        if (!alg.equals("RSA")) {
            return this.cipher.unwrap(encrypted, alg, 3);
        }
        try {
            Key result = this.cipher.unwrap(encrypted, alg, 2);
            if (result != null) {
                return result;
            }
            result = this.cipher.unwrap(encrypted, alg, 1);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            Key result = this.cipher.unwrap(encrypted, alg, 1);
            return result;
        }
        throw new InvalidKeyException();
    }

    private byte[] unwrapKeyRaw(Key key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key == null || encrypted == null) {
            throw new NullPointerException("key or cipher data cannot be null");
        }
        if (!(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("key must be a RSAPrivateKey");
        }
        Integer keysizeInt = this.getKeySize();
        if (keysizeInt != null) {
            Utils.checkKeySize(keysizeInt, (RSAKey)((Object)key));
        }
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING Cipher not found");
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException("RSA/ECB/PKCS1PADDING");
            }
        }
        this.cipher.init(2, key);
        byte[] decrypted = this.cipher.doFinal(encrypted);
        return decrypted;
    }
}

