/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.Base64;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import java.io.IOException;
import java.math.BigInteger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class DOMCryptoBinary
extends DOMStructure {
    private final BigInteger bigNum;
    private String value;

    public DOMCryptoBinary(BigInteger bigNum) {
        if (bigNum == null) {
            throw new NullPointerException("bigNum is null");
        }
        this.bigNum = bigNum;
        byte[] bigNumAsBytes = bigNum.toByteArray();
        try {
            this.value = Base64.encode(bigNum);
        }
        catch (IOException ex) {
            this.value = null;
        }
    }

    public DOMCryptoBinary(Node cbNode) throws MarshalException {
        this.value = cbNode.getNodeValue();
        try {
            this.bigNum = new BigInteger(1, Base64.decode(((Text)cbNode).getData()));
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
    }

    public BigInteger getBigNum() {
        return this.bigNum;
    }

    @Override
    public void marshal(Node parent, String prefix, DOMCryptoContext context) throws MarshalException {
        parent.appendChild(DOMUtils.getOwnerDocument(parent).createTextNode(this.value));
    }
}

