/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkKupdRepEvent;
import com.ibm.security.certclient.base.PkKupdReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.UnresolvedAttribute;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;

public class PkPkcsEventFormatter
extends PkEventFormatter
implements PkConstants {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "PkPkcsEventFormatter";
    private static final ObjectIdentifier EXT_OID = PkPkcsEventFormatter.getOID();

    private static final ObjectIdentifier getOID() {
        try {
            return new ObjectIdentifier("1.3.6.1.4.1.311.2.1.14");
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(4L, className, "getOID", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public PkEvent readEvent(Object source, InputStream is, PkReqEvent req) throws PkException, IOException {
        DerValue der = new DerValue(is);
        try {
            return this.readCertReqEvent(source, der);
        }
        catch (IOException e) {
            return this.readCertRepEvent(source, der, req);
        }
    }

    @Override
    public void writeException(Exception e, OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeCertReq(PkCertReqEvent req, OutputStream out) throws IOException {
        CertificationRequest cr;
        PKCSAttributes attrs = new PKCSAttributes();
        CertificateExtensions certExt = null;
        ArrayList<DerValue> v = new ArrayList<DerValue>();
        PkAttrs.Iter i = req.getAttrs().iterator();
        while (i.hasNext()) {
            PkAttr a = (PkAttr)i.next();
            if (!a.isApproved() || !a.isApplied()) continue;
            if (a.isNameOid()) {
                attrs = attrs.addAttribute(new PKCSAttribute(new ObjectIdentifier(a.getName()), a.getValue()));
                continue;
            }
            if (!a.getName().startsWith("x509.info.extensions.")) continue;
            if (certExt == null) {
                certExt = new CertificateExtensions();
            }
            ObjectIdentifier oid = OIDMap.getOID((String)a.getName());
            CertAttrSet certAttrSet = (CertAttrSet)a.getValue();
            DerOutputStream tempOut = new DerOutputStream();
            try {
                certAttrSet.encode((OutputStream)tempOut);
                DerValue dv = new DerValue(tempOut.toByteArray());
                v.add(dv);
            }
            catch (CertificateException e) {
                throw new PkIoException(e);
            }
        }
        if (v.size() > 0) {
            DerValue[] dvs = new DerValue[v.size()];
            Object[] objs = v.toArray();
            for (int i2 = 0; i2 < objs.length; ++i2) {
                dvs[i2] = (DerValue)objs[i2];
            }
            DerOutputStream attrOut = new DerOutputStream();
            attrOut.putSequence(dvs);
            DerOutputStream attrOut2 = new DerOutputStream();
            attrOut2.write((byte)49, attrOut);
            attrs = attrs.addAttribute(new PKCSAttribute(new UnresolvedAttribute(EXT_OID, (Object)attrOut2.toByteArray())));
        }
        PkAttrs ats = req.getAttrs();
        String algo = ((AlgorithmId)ats.getValue("x509.info.algorithmID")).getName();
        algo = algo.substring(0, algo.indexOf("with"));
        try {
            cr = new CertificationRequest(new CertificationRequestInfo((X500Name)ats.getValue("x509.info.subject"), (PublicKey)ats.getValue("x509.info.key"), attrs), (PrivateKey)ats.getValue("cert.oper.privateKey"), algo);
        }
        catch (PKCSException e) {
            throw new PkIoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PkIoException(e);
        }
        cr.encode(out);
    }

    @Override
    public void writeCertRep(PkCertRepEvent rep, OutputStream out) throws IOException {
        new ContentInfo((Content)new SignedData(new Certificate[]{rep.getCert()}, null)).encode(out);
    }

    protected PkCertReqEvent readCertReqEvent(Object source, DerValue der) throws IOException {
        CertificationRequest msg = new CertificationRequest(der.toByteArray());
        return new PkCertReqEvent(source, msg, this.getAttrs(msg));
    }

    protected PkCertRepEvent readCertRepEvent(Object source, DerValue der, PkReqEvent req) throws IOException {
        ContentInfo contentInfo = new ContentInfo(der.toByteArray());
        SignedData innerSignedData = (SignedData)contentInfo.getContent();
        Certificate[] certs = innerSignedData.getCertificates();
        if (req instanceof PkInitReqEvent) {
            return new PkInitRepEvent(source, contentInfo, req, certs[0]);
        }
        if (req instanceof PkSecnReqEvent) {
            return new PkSecnRepEvent(source, contentInfo, req, certs[0]);
        }
        if (req instanceof PkXcerReqEvent) {
            return new PkXcerRepEvent(source, contentInfo, req, certs[0]);
        }
        if (req instanceof PkKupdReqEvent) {
            return new PkKupdRepEvent(source, contentInfo, req, certs[0]);
        }
        throw new PkIoException(PkNLSConstants.PKCSEVENT_BAD_REQUEST);
    }

    private PkAttrs getAttrs(CertificationRequest cr) throws IOException {
        CertificationRequestInfo cri = cr.getCertRequestInfo();
        PkAttrs result = new PkAttrs();
        PkPkcsEventFormatter.add(result, "x509.info.subject", cri.getSubjectName());
        try {
            PkPkcsEventFormatter.add(result, "x509.info.key", cri.getSubjectPublicKeyInfo());
        }
        catch (InvalidKeyException e) {
            throw new PkIoException(e);
        }
        PKCSAttribute[] attrs = cri.getAttributes().getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ObjectIdentifier oid = attrs[i].getAttributeId();
            String name = PKCS9.getName((ObjectIdentifier)oid);
            if (name != null) {
                PkPkcsEventFormatter.add(result, name, attrs[i].getAttributeValue());
                continue;
            }
            if (!oid.equals(EXT_OID)) continue;
            DerInputStream derIn = new DerInputStream((byte[])attrs[i].getAttributeValue());
            DerValue[] val = derIn.getSet(1);
            DerInputStream dis = new DerInputStream(val[0].toByteArray());
            CertificateExtensions exts = new CertificateExtensions(dis);
            Enumeration xenum = exts.getElements();
            while (xenum.hasMoreElements()) {
                Object obj = xenum.nextElement();
                String extName = !(obj instanceof CertAttrSet) ? ((Extension)obj).getExtensionId().toString() : "x509.info.extensions." + ((CertAttrSet)obj).getName();
                PkPkcsEventFormatter.add(result, extName, obj);
            }
        }
        return result;
    }

    private static void add(PkAttrs attrs, String name, Object value) {
        attrs.add(name, 1, value);
    }
}

