/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkHttpRepEvent;
import com.ibm.security.certclient.base.PkHttpReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPollException;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.util.PkString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class PkHttpEventFormatter
extends PkEventFormatter
implements PkConstants {
    private static final String sccsid = "@(#) 83 1.1    src/com/ibm/security/certclient/fmt/PkHttpEventFormatter.java, keycertmanagement, kcm60 7/3/05 23:20:44";

    @Override
    public PkEvent readEvent(Object source, InputStream is, PkReqEvent req) throws PkException, IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is, "8859_1"));
        String line = in.readLine();
        PkAttrs attrs = new PkAttrs();
        int firstSpace = line.indexOf(32);
        String method = line.substring(0, firstSpace);
        method = method.intern();
        attrs.add("http.method", 0, method);
        if (method == "GET" || method == "POST") {
            PkAttrs params;
            String fileName;
            String url;
            int lastSpace = line.lastIndexOf(32);
            if (lastSpace == firstSpace) {
                url = line.substring(firstSpace + 1);
            } else {
                url = line.substring(firstSpace + 1, lastSpace);
                attrs.add("http.version", 0, line.substring(lastSpace + 1));
            }
            while ((line = in.readLine()) != null && !line.equals("")) {
                int colon = line.indexOf(58);
                String name = line.substring(0, colon).trim();
                String value = line.substring(colon + 1).trim();
                if (!attrs.has(name)) {
                    attrs.add(name, 0, value);
                    continue;
                }
                Object oldValue = attrs.getValue(name);
                if (oldValue instanceof Set) {
                    ((Set)oldValue).add(value);
                    continue;
                }
                HashSet<Object> set = new HashSet<Object>();
                set.add(value);
                set.add(oldValue);
                attrs.get(name).setValue(set);
            }
            if (method == "POST") {
                int bytes;
                int len = Integer.parseInt(attrs.getStringIgnoreCase("Content-Length"));
                char[] buffer = new char[len];
                fileName = url;
                for (int read = 0; read < len; read += bytes) {
                    bytes = in.read(buffer, read, len - read);
                    if (bytes != -1) continue;
                    throw new PkException(PkNLSConstants.HTTPEVENT_END_OF_INPUT);
                }
                params = this.getParams(new String(buffer));
            } else {
                int endOfFile = url.indexOf("?");
                if (endOfFile == -1) {
                    fileName = url;
                    params = new PkAttrs();
                } else {
                    fileName = url.substring(0, endOfFile);
                    params = this.getParams(url.substring(endOfFile + 1));
                }
            }
            attrs.add("http.filename", 0, fileName);
            int index = fileName.lastIndexOf(47);
            if (index == -1) {
                attrs.add("http.basename", 0, fileName);
            } else {
                attrs.add("http.basename", 0, fileName.substring(index + 1));
            }
            return new PkHttpReqEvent(source, null, attrs, params);
        }
        throw new UnsupportedOperationException(method);
    }

    private PkAttrs getParams(String params) {
        PkAttrs result = new PkAttrs();
        String[] parameters = PkString.split(params, "&");
        for (int i = 0; i < parameters.length; ++i) {
            String[] parameter = PkString.split(parameters[i], "=");
            parameter[0] = this.removeQuotes(parameter[0]);
            parameter[1] = this.removeQuotes(parameter[1]);
            if (!result.has(parameter[0])) {
                result.add(parameter[0], 0, parameter[1]);
                continue;
            }
            Object oldValue = result.getValue(parameter[0]);
            if (oldValue instanceof Set) {
                ((Set)oldValue).add(parameter[1]);
                continue;
            }
            HashSet<Object> set = new HashSet<Object>();
            set.add(parameter[1]);
            set.add(oldValue);
            result.get(parameter[0]).setValue(set);
        }
        return result;
    }

    private String removeQuotes(String string) {
        if ((string = string.replace('+', ' ')).indexOf("%") == -1) {
            return string;
        }
        StringBuffer result = new StringBuffer(string.length());
        char[] array = string.toCharArray();
        int prev = 0;
        int next = 0;
        while ((next = string.indexOf("%", next)) != -1) {
            result.append(array, prev, next - prev);
            char c = (char)(this.hexToChar(string.charAt(next + 1)) * 16);
            c = (char)(c + this.hexToChar(string.charAt(next + 2)));
            result.append(c);
            prev = next + 3;
            next += 3;
        }
        result.append(array, prev, array.length - prev);
        return result.toString();
    }

    private char hexToChar(char hex) {
        switch (hex) {
            case '0': {
                return '\u0000';
            }
            case '1': {
                return '\u0001';
            }
            case '2': {
                return '\u0002';
            }
            case '3': {
                return '\u0003';
            }
            case '4': {
                return '\u0004';
            }
            case '5': {
                return '\u0005';
            }
            case '6': {
                return '\u0006';
            }
            case '7': {
                return '\u0007';
            }
            case '8': {
                return '\b';
            }
            case '9': {
                return '\t';
            }
            case 'A': 
            case 'a': {
                return '\n';
            }
            case 'B': 
            case 'b': {
                return '\u000b';
            }
            case 'C': 
            case 'c': {
                return '\f';
            }
            case 'D': 
            case 'd': {
                return '\r';
            }
            case 'E': 
            case 'e': {
                return '\u000e';
            }
            case 'F': 
            case 'f': {
                return '\u000f';
            }
        }
        throw new IllegalArgumentException(PkNLSConstants.HTTPEVENT_BAD_HEX_CHAR + hex);
    }

    @Override
    public void writeException(Exception e, OutputStream os) throws IOException {
        if (e instanceof PkPollException) {
            this.writeHeader(os, "text/html");
            PrintStream out = new PrintStream(os);
            out.write("<html><body><h2>Please poll again in ".getBytes("UTF8"));
            int ttcb = ((PkPollException)e).getTimeToCheckBack();
            out.write((ttcb + " seconds</h2></body></html>\n").getBytes("UTF8"));
            out.close();
        } else {
            this.writeHeader(os, "text/html");
            PrintStream out = new PrintStream(os);
            out.write("<html><title>Exception</title><body><pre>".getBytes("UTF8"));
            e.printStackTrace(out);
            out.write("</pre></body></html>\n".getBytes("UTF8"));
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHttpRep(PkHttpRepEvent httpRep, OutputStream out) throws IOException {
        this.writeHeader(out, httpRep.getContentType());
        InputStream in = httpRep.getInputStream();
        try {
            int numBytes;
            byte[] bytes = new byte[4096];
            while ((numBytes = in.read(bytes)) > 0) {
                out.write(bytes, 0, numBytes);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private void writeHeader(OutputStream out, String contentType) throws IOException {
        String s = "HTTP/1.0 200 OK\r\nDate: " + new Date() + "\r\nServer: Tivoli PKI 1.0\r\nContent-type: " + contentType + "\r\n\r\n";
        out.write(s.getBytes("UTF8"));
    }
}

