/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.orb.CallLink;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

abstract class RequestDataStore {
    private final Map dataMap = new HashMap();
    private final Map linkMap = new HashMap();
    private final Key dataSkeletonKey = new Key(0);
    private final Key linkSkeletonKey = new Key(1);
    private final Object dataLock = this.dataSkeletonKey;
    private final Object linkLock = this.linkSkeletonKey;
    private IOException closeConnectionException = null;

    RequestDataStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeRequestData(int n, Object object) {
        Object object2 = this.dataLock;
        synchronized (object2) {
            this.dataMap.put(new Key(n), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object retrieveRequestData(int n) {
        if (this.closeConnectionException != null) {
            return this.closeConnectionException;
        }
        Object object = this.dataLock;
        synchronized (object) {
            return this.dataMap.get(this.dataSkeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object clearRequestData(int n) {
        Object object = this.dataLock;
        synchronized (object) {
            return this.dataMap.remove(this.dataSkeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean noRequestData() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.dataMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeCallLink(int n, CallLink callLink) {
        Object object = this.linkLock;
        synchronized (object) {
            this.linkMap.put(new Key(n), callLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeCallLink(int n, CallLink callLink, long l) {
        Object object = this.linkLock;
        synchronized (object) {
            this.linkMap.put(new Key(n, l), callLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink retrieveCallLink(int n) {
        Object object = this.linkLock;
        synchronized (object) {
            return (CallLink)this.linkMap.get(this.linkSkeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] getCallLinkKeySet() {
        Object object = this.linkLock;
        synchronized (object) {
            return this.linkMap.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink clearCallLink(int n) {
        Object object = this.linkLock;
        synchronized (object) {
            return (CallLink)this.linkMap.remove(this.linkSkeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean noCallLink() {
        Object object = this.linkLock;
        synchronized (object) {
            return this.linkMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeException(int n, IOException iOException) {
        Object object = this.dataLock;
        synchronized (object) {
            this.dataMap.put(new Key(n), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IOException retrieveException(int n) {
        if (this.closeConnectionException != null) {
            return this.closeConnectionException;
        }
        Object var2_2 = null;
        Object object = this.dataLock;
        synchronized (object) {
            var2_2 = this.dataMap.get(this.dataSkeletonKey.toFit(n));
        }
        if (var2_2 instanceof IOException) {
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink clearCallLinkIfWaiting(Object object) {
        Object object2 = this.dataLock;
        synchronized (object2) {
            Object v = this.dataMap.get(object);
            if (v == null) {
                Object object3 = this.linkLock;
                synchronized (object3) {
                    return (CallLink)this.linkMap.remove(object);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink clearCallLinkIfTimeout(Object object) {
        long l = ((Key)object).getEndTime();
        if (l == 0L || l - System.currentTimeMillis() > 0L) {
            return null;
        }
        Object object2 = this.linkLock;
        synchronized (object2) {
            return (CallLink)this.linkMap.remove(object);
        }
    }

    public final int getIdForKey(Object object) {
        return ((Key)object).getId();
    }

    public final void markCloseConnection(IOException iOException) {
        this.closeConnectionException = iOException;
    }

    private static final class Key {
        private int val;
        private long endTime = 0L;

        Key(int n) {
            this.val = n;
        }

        Key(int n, long l) {
            this(n);
            this.endTime = l;
        }

        Key toFit(int n) {
            this.val = n;
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.val == key.val;
            }
            return false;
        }

        public int hashCode() {
            return this.val;
        }

        private int getId() {
            return this.val;
        }

        private long getEndTime() {
            return this.endTime;
        }
    }
}

