/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.nio;

import com.ibm.CORBA.nio.Sink;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.BufferHandler;
import com.ibm.jtc.orb.nio.BufferMarker;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.jtc.orb.nio.CDRWriteHandler;
import com.ibm.jtc.orb.nio.EncoderInputHandler;
import com.ibm.jtc.orb.nio.EncoderOutputHandler;
import com.ibm.jtc.orb.nio.SimpleBufferHandler;
import com.ibm.jtc.orb.nio.WriteBufferHandler;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;

public class CDROutputHandler
extends CDRWriter {
    private static final String CLASS = CDRWriter.class.getName();
    private static final WsByteBuffer[] NO_BUFFERS = new WsByteBuffer[0];
    WriteBufferHandler dataHandler;
    final Sink sink;
    private BufferMarker blockSizePosition = null;
    private BufferMarker endFlagPosition = null;
    private static String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static String[] _ids = new String[]{_id};
    private static final long serialVersionUID = 0L;

    public CDROutputHandler(Sink sink, EncoderOutputHandler encoderOutputHandler) {
        super(encoderOutputHandler);
        this.sink = sink;
    }

    public CDROutputHandler(ORB oRB, Sink sink, byte by, byte by2, EncoderOutputHandler encoderOutputHandler) {
        super(oRB, by, by2, (EncoderOutputStream)encoderOutputHandler);
        this.sink = sink;
    }

    public CDROutputHandler(ORB oRB, Sink sink, boolean bl, int n, EncoderOutputHandler encoderOutputHandler) {
        super(oRB, bl, n, (EncoderOutputStream)encoderOutputHandler);
        this.sink = sink;
    }

    public CDROutputHandler(ORB oRB, Sink sink, int n, int n2, EncoderOutputHandler encoderOutputHandler) {
        super(oRB, n, n2, (EncoderOutputStream)encoderOutputHandler);
        this.sink = sink;
    }

    @Override
    public void releaseBuffer() {
        if (this.dataHandler != null) {
            this.dataHandler.releaseBuffer();
            this.dataHandler = null;
        }
    }

    @Override
    public byte[] toByteArray() {
        throw new INTERNAL("This method should not be used in nio mode.");
    }

    @Override
    public WsByteBuffer[] toByteBuffer() {
        BufferHandler bufferHandler = this.getBufferHandler();
        return bufferHandler == null ? NO_BUFFERS : bufferHandler.getFlippedBuffers();
    }

    @Override
    protected void pad(int n) {
        for (int i = 0; i < n; ++i) {
            this.dataHandler.getBuffer().put((byte)-67);
        }
    }

    @Override
    protected final void align(int n) {
        if (n > 1) {
            if (this.dataHandler == null) {
                this.allocateBuffer();
            } else {
                int n2 = this.dataHandler.getStreamPosition() & n - 1;
                if (n2 != 0) {
                    n2 = n - n2;
                    this.pad(n2);
                }
            }
        }
    }

    @Override
    protected final int alignAndReserve(int n, int n2) {
        int n3 = 0;
        if (this.dataHandler != null) {
            this.align(n);
        } else {
            this.allocateBuffer();
        }
        n3 = this.dataHandler.available();
        if (n > n3) {
            if (this.fragmenting()) {
                this.completeFragment(n2);
                n3 = this.dataHandler.available();
            } else {
                WsByteBuffer wsByteBuffer = this.sink.getBuffer(this.bufferSize());
                this.dataHandler.addNextBuffer(wsByteBuffer);
                n3 = this.dataHandler.available();
            }
        }
        n3 = Math.min(n2, n3);
        return n3 / n;
    }

    @Override
    protected final void rememberBlockSizePosition() {
        this.blockSizePosition = new BufferMarker();
        this.dataHandler.mark(this.blockSizePosition);
    }

    @Override
    protected final void forgetBlockSizePosition() {
        this.blockSizePosition = null;
    }

    @Override
    protected final void writeBlockSizeHere(int n) {
        if (this.blockSizePosition == null) {
            this.blockSizePosition = new BufferMarker();
        }
        this.write_long(n, false, this.blockSizePosition);
    }

    @Override
    protected final void rewriteBlockSize(int n, int n2) {
        int n3 = this.blockSizePosition.getStreamPosition() + 4;
        int n4 = n + this.dataHandler.getStreamPosition() + n2;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, Trc.str(this.blockSizePosition.getStreamPosition()), Trc.str(n), Trc.str(this.dataHandler.getStreamPosition()), Trc.str(n2), CLASS, "rewriteBlockSize:235");
        }
        int n5 = n4 - n3;
        this.rewriteLong(n5, this.blockSizePosition);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "block length: ", Trc.hex(n5), CLASS, "rewriteBlockSize:238");
        }
    }

    @Override
    protected final void clearEndFlagMarker() {
        this.endFlagPosition = null;
    }

    @Override
    protected final void allocateBuffer() {
        this.dataHandler = new CDRWriteHandler(this.orb, this.sink, this.bufferSize());
        this.dataHandler.setByteOrder(this.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    @Override
    public InputStream create_input_stream() {
        WsByteBuffer[] wsByteBufferArray = this.dataHandler.getFlippedReadOnlyBuffers();
        final SimpleBufferHandler simpleBufferHandler = new SimpleBufferHandler(this.orb, null, wsByteBufferArray);
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new EncoderInputHandler(simpleBufferHandler);
            }
        });
    }

    @Override
    public void write_octet(byte by) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(1, 1);
        this.writeByte(by, null);
    }

    @Override
    public final Object writePlaceHolderOctet(byte by) {
        return this.writeByte(by, new BufferMarker());
    }

    @Override
    public final void rewriteOctet(byte by, Object object) {
        this.checkPadding();
        this.put(by, (BufferMarker)object);
    }

    private void put(byte by, BufferMarker bufferMarker) {
        this.dataHandler.getBuffers()[bufferMarker.getArrayIndex()].put(bufferMarker.getBufferIndex(), by);
    }

    public void put(int n, BufferMarker bufferMarker) {
        this.dataHandler.getBuffers()[bufferMarker.getArrayIndex()].putInt(bufferMarker.getBufferIndex(), n);
    }

    BufferMarker writeByte(byte by, BufferMarker bufferMarker) {
        if (bufferMarker != null) {
            this.dataHandler.mark(bufferMarker);
        }
        this.dataHandler.getBuffer().put(by);
        return bufferMarker;
    }

    @Override
    protected final void writeBoolean(boolean bl) {
        this.write_octet(CDROutputHandler.booleanToByte(bl));
    }

    @Override
    public final Object writePlaceHolderBoolean(boolean bl) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(1, 1);
        return this.writeByte((byte)(bl ? 1 : 0), new BufferMarker());
    }

    @Override
    public final void rewriteBoolean(boolean bl, Object object) {
        this.rewriteOctet((byte)(bl ? 1 : 0), object);
    }

    @Override
    protected final void writeShort(int n, boolean bl) {
        assert (bl == this.littleEndian);
        this.checkPadding();
        this.dataHandler.getBuffer().putShort((short)n);
    }

    @Override
    protected final void writeLong(int n, boolean bl) {
        assert (bl == this.littleEndian);
        this.checkPadding();
        this.dataHandler.getBuffer().putInt(n);
    }

    private final void writeLong(int n, boolean bl, BufferMarker bufferMarker) {
        assert (bl == this.littleEndian);
        this.put(n, bufferMarker);
    }

    @Override
    protected final void writeLongLong(long l, boolean bl) {
        assert (bl == this.littleEndian);
        this.checkPadding();
        this.dataHandler.getBuffer().putLong(l);
    }

    public void write_wchar(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(new char[]{c}, this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n = cArray.length;
        int n2 = n * 2;
        int n3 = 0;
        boolean bl2 = false;
        this.checkPadding();
        this.checkChunkStart();
        if (this.isPreGiop12()) {
            if (n > 1) {
                throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (wchar) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            n3 = this.alignAndReserve(2, n2);
        } else {
            n3 = this.alignAndReserve(1, n2 + 1);
            this.dataHandler.getBuffer().put((byte)n2);
            bl2 = --n3 == 0;
        }
        int[] nArray = CDROutputHandler.getByteShifts(2, bl);
        int n4 = 0;
        do {
            if (bl2) {
                n3 += this.alignAndReserve(1, n2 - n4);
            }
            do {
                this.dataHandler.getBuffer().put((byte)(cArray[n4 / 2] >>> nArray[n4 % 2] & 0xFF));
            } while (++n4 < n3);
            bl2 = true;
        } while (n4 < n2);
    }

    @Override
    public void write_short(short s) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(2, 2);
        this.writeShort(s, this.littleEndian);
    }

    @Override
    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.write_long(n, true);
    }

    @Override
    public final void write_long(int n, boolean bl) {
        if (bl) {
            this.checkChunkStart();
        }
        this.alignAndReserve(4, 4);
        this.writeLong(n, this.littleEndian);
    }

    @Override
    public final void rewriteLong(int n, Object object) {
        this.writeLong(n, this.littleEndian, (BufferMarker)object);
    }

    @Override
    public final Object writePlaceHolderLong(int n) {
        return this.write_long(n, false, new BufferMarker());
    }

    private BufferMarker write_long(int n, boolean bl, BufferMarker bufferMarker) {
        this.checkPadding();
        if (bl) {
            this.checkChunkStart();
        }
        this.alignAndReserve(4, 4);
        if (bufferMarker != null) {
            this.dataHandler.mark(bufferMarker);
        }
        this.writeLong(n, this.littleEndian);
        return bufferMarker;
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    @Override
    public void write_longlong(long l) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(8, 8);
        this.writeLongLong(l, this.littleEndian);
    }

    public void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM("Null Param (2) - string", 1229124098, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        int n = byArray.length;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n + 1);
        this.writeLong(n + 1, this.littleEndian);
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = this.alignAndReserve(1, n - i + 1);
            if (n2 + i == n + 1) {
                --n2;
            }
            this.dataHandler.getBuffer().put(byArray, i, n2);
        }
        this.alignAndReserve(1, 1);
        this.dataHandler.getBuffer().put((byte)0);
    }

    public void write_wstring(String string) {
        int n;
        if (null == string) {
            throw new BAD_PARAM("Null Param (3) - wstring", 1229124099, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(string.toCharArray(), this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n2 = cArray.length;
        if (this.isPreGiop12()) {
            this.write_long(n2 + 1);
        } else {
            n = n2 * 2;
            this.checkPadding();
            this.checkChunkStart();
            this.alignAndReserve(4, 4 + n);
            this.writeLong(n, this.littleEndian);
        }
        n = 0;
        int n3 = 0;
        byte[] byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        for (int i = 0; i < n2; i += n) {
            int n4;
            n = this.alignAndReserve(2, (n2 - i) * 2);
            n3 = n * 2;
            if (byArray.length < n3) {
                byArray = new byte[n3];
            }
            int n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                char c = cArray[i + n4];
                byArray[n5] = (byte)(c >>> 8 & 0xFF);
                byArray[++n5] = (byte)(c & 0xFF);
                ++n5;
            }
            if (bl) {
                for (n5 = 0; n5 < n3; n5 += 2) {
                    int n6 = n5 + 1;
                    n4 = byArray[n5];
                    byArray[n5] = byArray[n6];
                    byArray[n6] = n4;
                }
            }
            this.dataHandler.getBuffer().put(byArray, 0, n3);
        }
        if (this.isPreGiop12()) {
            this.write_short((short)0);
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        this.write_octet_array(byArray, n, n2, true);
    }

    @Override
    public void write_octet_array(byte[] byArray, int n, int n2, boolean bl) {
        this.writeOctetArrayPiece(byArray, n, n2, true, n2);
    }

    @Override
    public final void writeOctetArrayPiece(byte[] byArray, int n, int n2, boolean bl, int n3) {
        if (byArray == null) {
            throw new BAD_PARAM("Null Param (4) - octet array", 1229124100, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            int n4;
            this.checkPadding();
            if (bl) {
                this.checkChunkStart();
            }
            for (int i = 0; i < n2; i += n4) {
                n4 = this.alignAndReserve(1, n3 - i);
                n4 = Math.min(n4, n2 - i);
                this.dataHandler.getBuffer().put(byArray, n + i, n4);
            }
        }
    }

    @Override
    public int get_offset(boolean bl) {
        int n = this.initialOffset;
        if (this.dataHandler != null) {
            if (bl) {
                this.checkChunkStart();
            }
            n += this.dataHandler.getStreamPosition();
        }
        return n;
    }

    private CharToTcsConverter getTcsCConverter() {
        if (this.tcsCConverter == null) {
            int n = this.getTcsC();
            if (n == 0) {
                n = 65537;
            }
            this.tcsCConverter = CharToTcsConverter.getConverter(n);
            if (!this.tcsCConverter.isByteOriented()) {
                throw new INTERNAL("non-byte-oriented char code set specified", 1229125042, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsCConverter;
    }

    private CharToTcsConverter getTcsWConverter() {
        if (this.tcsWConverter == null) {
            int n = this.getTcsW();
            if (n == 0) {
                throw new INV_OBJREF("wchar code set support not specified", 1330446338, CompletionStatus.COMPLETED_NO);
            }
            this.tcsWConverter = CharToTcsConverter.getConverter(n);
            if (this.tcsWConverter.isByteOriented()) {
                throw new INTERNAL("byte-oriented wchar code set specified", 1229125044, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsWConverter;
    }

    public void write_char(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(new char[]{c});
        if (byArray.length > 1) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (char) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.write_octet(byArray[0]);
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        byte[] byArray;
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (8) - char array", 1229124104, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        if (n == 0 && n2 == cArray.length) {
            byArray = charToTcsConverter.convertToByte(cArray);
        } else {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            byArray = charToTcsConverter.convertToByte(cArray2);
        }
        if (byArray.length > n2) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        if (n2 > 0) {
            int n3;
            this.checkPadding();
            this.checkChunkStart();
            for (int i = 0; i < n2; i += n3) {
                n3 = this.alignAndReserve(1, n2 - i);
                this.dataHandler.getBuffer().put(byArray, i, n3);
            }
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (9) - wchar array", 1229124105, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
            boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
            if (this.isPreGiop12()) {
                Object[] objectArray;
                char[] cArray2;
                if (n == 0 && cArray.length == n2) {
                    cArray2 = charToTcsConverter.convertToChar(cArray, this.littleEndian);
                } else {
                    objectArray = new char[n2];
                    System.arraycopy(cArray, n, objectArray, 0, n2);
                    cArray2 = charToTcsConverter.convertToChar((char[])objectArray, this.littleEndian);
                }
                if (cArray2.length > n2) {
                    throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - wchar array", 1330446337, CompletionStatus.COMPLETED_NO);
                }
                objectArray = CDROutputHandler.getByteShifts(2, bl);
                int n3 = n2;
                int n4 = 0;
                int n5 = 0;
                do {
                    n5 += this.alignAndReserve(2, (n3 - n4) * 2);
                    do {
                        this.dataHandler.getBuffer().put((byte)(cArray2[n4] >>> objectArray[0] & 0xFF));
                        this.dataHandler.getBuffer().put((byte)(cArray2[n4] >>> objectArray[1] & 0xFF));
                    } while (++n4 < n5);
                } while (n4 < n3);
            } else {
                int[] nArray = CDROutputHandler.getByteShifts(2, bl);
                byte[] byArray = new byte[n2 * 3];
                int n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    char[] cArray3 = charToTcsConverter.convertToChar(new char[]{cArray[n + i]}, this.littleEndian);
                    if (n6 + (cArray3.length * 2 + 1) > byArray.length) {
                        byte[] byArray2 = byArray;
                        byArray = new byte[byArray2.length * 2];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    }
                    byArray[n6++] = (byte)(cArray3.length * 2);
                    for (int j = 0; j < cArray3.length; ++j) {
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[0] & 0xFF);
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[1] & 0xFF);
                    }
                }
                this.write_octet_array(byArray, 0, n6);
            }
        }
    }

    @Override
    protected final boolean resetBufferData() {
        if (this.dataHandler != null) {
            this.initialOffset += this.dataHandler.getStreamPosition();
            this.dataHandler.releaseBuffer();
            this.dataHandler = null;
            this.endFlagPosition = null;
            return true;
        }
        return false;
    }

    protected void sendFragment() {
        try {
            this.getCDRWriteHandler().flush();
        }
        catch (IOException iOException) {
            throw new MARSHAL("Error sending fragment", 1229125873, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.dataHandler != null) {
            this.dataHandler.flushTo(outputStream);
        }
    }

    @Override
    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        if (this.dataHandler != null) {
            this.dataHandler.flushTo(outputStream);
        }
    }

    @Override
    public int getSize() {
        int n = this.dataHandler == null ? 0 : this.dataHandler.getSize();
        return n;
    }

    @Override
    protected byte[] getBuffer() {
        return this.toByteArray();
    }

    @Override
    public BufferHandler getBufferHandler() {
        return this.dataHandler;
    }

    protected CDRWriteHandler getCDRWriteHandler() {
        return (CDRWriteHandler)this.dataHandler;
    }

    @Override
    protected byte[] convertStringToTcsBytes(String string) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    @Override
    protected final void writeEndTag(int n) {
        if (this.endFlagPosition != null && this.endFlagPosition.getStreamPosition() == this.dataHandler.getStreamPosition() - 4) {
            this.rewriteLong(this.end_flag, this.endFlagPosition);
        } else {
            if (this.endFlagPosition == null) {
                this.endFlagPosition = new BufferMarker();
            }
            this.write_long(this.end_flag, true, this.endFlagPosition);
        }
    }

    @Override
    public void write_Abstract(Object object) {
        this.write_abstract_interface(object);
    }

    @Override
    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    @Override
    public String[] _truncatable_ids() {
        return _ids;
    }

    @Override
    public final void printBuffer() {
        if (this.dataHandler != null) {
            WsByteBuffer[] wsByteBufferArray = this.dataHandler.getFlippedBuffers();
            String string = ByteBufferUtils.bytesToHexString(wsByteBufferArray);
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])wsByteBufferArray);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:912");
        throw notSerializableException;
    }
}

