/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.nio;

import com.ibm.CORBA.ras.HexFormatter;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.Aligner;
import com.ibm.jtc.orb.nio.BufferHandler;
import com.ibm.jtc.orb.nio.BufferHandlerHelper;
import com.ibm.jtc.orb.nio.BufferMarker;
import com.ibm.jtc.orb.nio.EncoderInputHandler;
import com.ibm.rmi.ORB;
import com.ibm.rmi.iiop.CDRReader;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.util.Interop;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public class CDRInputHandler
extends CDRReader {
    private static final String CLASS = CDRInputHandler.class.getName();
    private static final long serialVersionUID = 0L;
    private HashMap bufferMarkers = new HashMap();
    BufferHandler dataHandler;
    private WsByteBuffer data;
    private Connection connection;

    public CDRInputHandler(EncoderInputHandler encoderInputHandler) {
        super(encoderInputHandler);
    }

    public CDRInputHandler(BufferHandler bufferHandler, EncoderInputHandler encoderInputHandler) {
        super(encoderInputHandler);
        this.setData(bufferHandler);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:105");
        throw notSerializableException;
    }

    public short read_short() {
        short s;
        this.alignAndCheck(Aligner.TWO, 2, 2);
        switch (this.data.remaining()) {
            case 1: {
                s = this.read_short_from_octet();
                break;
            }
            case 0: {
                this.data = this.dataHandler.getNextBuffer(2);
                if (this.data.remaining() < 2) {
                    s = this.read_short_from_octet();
                    break;
                }
            }
            default: {
                s = this.data.getShort();
            }
        }
        return s;
    }

    private short read_short_from_octet() {
        short s = (short)((this.read_octet() & 0xFF) << 8 | this.read_octet() & 0xFF);
        if (this.data.order() == ByteOrder.LITTLE_ENDIAN) {
            s = CDRInputHandler.swapBytes(s);
        }
        return s;
    }

    public int read_long() {
        int n;
        this.alignAndCheck(Aligner.FOUR, 4, 4);
        switch (this.data.remaining()) {
            case 1: 
            case 2: 
            case 3: {
                n = this.read_long_from_octet();
                break;
            }
            case 0: {
                this.data = this.dataHandler.getNextBuffer(4);
                if (this.data.remaining() < 4) {
                    n = this.read_long_from_octet();
                    break;
                }
            }
            default: {
                n = this.data.getInt();
            }
        }
        return n;
    }

    private int read_long_from_octet() {
        int n = (this.read_octet() & 0xFF) << 24 | (this.read_octet() & 0xFF) << 16 | (this.read_octet() & 0xFF) << 8 | this.read_octet() & 0xFF;
        if (this.data.order() == ByteOrder.LITTLE_ENDIAN) {
            n = CDRInputHandler.swapBytes(n);
        }
        return n;
    }

    @Override
    public float read_float() {
        float f;
        this.alignAndCheck(Aligner.FOUR, 4, 4);
        switch (this.data.remaining()) {
            case 1: 
            case 2: 
            case 3: {
                f = super.read_float();
                break;
            }
            case 0: {
                this.data = this.dataHandler.getNextBuffer(4);
                if (this.data.remaining() < 4) {
                    f = super.read_float();
                    break;
                }
            }
            default: {
                f = this.data.getFloat();
            }
        }
        return f;
    }

    public final long read_longlong() {
        long l;
        this.alignAndCheck(Aligner.EIGHT, 8, 8);
        switch (this.data.remaining()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                l = this.read_longlong_from_long();
                break;
            }
            case 0: {
                this.data = this.dataHandler.getNextBuffer(8);
                if (this.data.remaining() < 8) {
                    l = this.read_longlong_from_long();
                    break;
                }
            }
            default: {
                l = this.data.getLong();
            }
        }
        return l;
    }

    @Override
    public double read_double() {
        double d;
        this.alignAndCheck(Aligner.EIGHT, 8, 8);
        switch (this.data.remaining()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                d = super.read_double();
                break;
            }
            case 0: {
                this.data = this.dataHandler.getNextBuffer(8);
                if (this.data.remaining() < 8) {
                    d = super.read_double();
                    break;
                }
            }
            default: {
                d = this.data.getDouble();
            }
        }
        return d;
    }

    private static int swapBytes(int n) {
        return (n & 0xFF000000) >> 24 | (n & 0xFF0000) >> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
    }

    private static short swapBytes(short s) {
        return (short)((s & 0xFF00) >> 8 | (s & 0xFF) << 8);
    }

    public byte read_octet() {
        this.alignAndCheck(1, 1);
        byte by = this.fast_read_byte();
        this.check_start_block(this.getBufferIndex());
        return by;
    }

    @Override
    public void read_octet_array(byte[] byArray, int n, int n2) {
        assert (byArray != null);
        assert (byArray.length >= n + n2);
        if (byArray == null) {
            throw new BAD_PARAM("NULL_PARAM (17) - Null encountered reading octet array", 1229124113, CompletionStatus.COMPLETED_NO);
        }
        int n3 = n2;
        while (n3 > 0) {
            int n4 = this.alignAndCheck(1, n3);
            this.data.get(byArray, n, n4);
            n3 -= n4;
            n += n4;
        }
    }

    public void skip_octet_array(int n) {
        this.skip(n);
    }

    @Override
    public BufferHandler setDataHandler(BufferHandler bufferHandler) {
        BufferHandler bufferHandler2 = this.dataHandler;
        this.setData(bufferHandler);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, this + " switch ", bufferHandler2, " to ", this.dataHandler, CLASS, "setDataHandler:333");
        }
        return bufferHandler2;
    }

    private void setData(BufferHandler bufferHandler) {
        this.dataHandler = bufferHandler;
        this.setOrb(bufferHandler.getORB());
        this.connection = bufferHandler.getConnection();
        this.data = bufferHandler.getBuffer();
    }

    @Override
    public void addNextBuffer(WsByteBuffer[] wsByteBufferArray) {
        this.dataHandler.addNextBuffers(wsByteBufferArray);
        this.data = this.dataHandler.getBuffer();
    }

    @Override
    public BufferHandler getBufferHandler() {
        return this.dataHandler;
    }

    public void resetDataHandler(BufferHandler bufferHandler) {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, this + " switch ", this.dataHandler, " back to ", bufferHandler, CLASS, "resetDataHandler:378");
        }
        if (bufferHandler == null) {
            this.unsetDataHandler();
        } else {
            this.setData(bufferHandler);
        }
    }

    @Override
    public void unsetDataHandler() {
        this.setOrb(null);
        this.connection = null;
        this.dataHandler = null;
        this.data = null;
    }

    @Override
    protected int checkSize(int n) {
        assert (n > 0);
        int n2 = 0;
        if (this.data != null) {
            n2 = this.data.remaining();
        }
        while (n2 == 0) {
            this.data = this.dataHandler.getNextBuffer(n);
            try {
                if (this.data == null) {
                    this.encoderStream.getNextBuffer();
                }
            }
            catch (MARSHAL mARSHAL) {
                throw new MARSHAL("No available data: " + mARSHAL.getMessage(), 1330446344, CompletionStatus.COMPLETED_MAYBE);
            }
            n2 = this.data.remaining();
        }
        return n2 > n ? n : n2;
    }

    @Override
    public int alignAndCheck(Aligner aligner, int n, int n2) {
        this.checkSize(n);
        int n3 = super.alignAndCheck(aligner, n, n2);
        return n3;
    }

    @Override
    public int availableData(int n, int n2, int n3) {
        if (n2 != 0) {
            n2 = this.checkSize(n2) / n3;
        }
        return n2;
    }

    @Override
    public final void toAlign(Aligner aligner, int n) {
        if (aligner == null) {
            aligner = Aligner.getAligner(n);
        }
        aligner.skip(this.dataHandler);
    }

    @Override
    public int get_offset() {
        return this.dataHandler.getStreamPosition();
    }

    @Override
    public void setOffset(int n) {
    }

    @Override
    public int available() throws IOException {
        return this.getSize() - this.get_offset();
    }

    @Override
    public boolean isAtEnd() {
        return this.dataHandler.getStreamPosition() == this.dataHandler.getSize();
    }

    @Override
    public int mark() {
        CDRBufferMarker cDRBufferMarker = new CDRBufferMarker(this.getBlockLength());
        this.dataHandler.mark(cDRBufferMarker);
        this.bufferMarkers.put(cDRBufferMarker.getStreamPosition(), cDRBufferMarker);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, cDRBufferMarker, CLASS, "mark:507");
        }
        return cDRBufferMarker.getStreamPosition();
    }

    @Override
    public void reset(int n) {
        CDRBufferMarker cDRBufferMarker = (CDRBufferMarker)this.bufferMarkers.get(n);
        if (cDRBufferMarker == null) {
            throw new MARSHAL("CDRBufferMarker not available for " + n);
        }
        this.setBlockLength(cDRBufferMarker.getBlockLength());
        this.dataHandler.reset(cDRBufferMarker);
        this.data = this.dataHandler.getBuffer();
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, this.getData(), CLASS, "reset:528");
        }
    }

    @Override
    public void printBuffer() {
        Exception exception = new Exception("printBuffer() not implemented yet");
        exception.printStackTrace();
    }

    @Override
    public void rewind() {
        this.reset(0);
    }

    @Override
    public int getSize() {
        return this.dataHandler.getSize();
    }

    @Override
    public Interop getInterop() {
        return ((ORB)this.orb).getInterop(this);
    }

    @Override
    public void closeBuffer() {
        this.dataHandler.releaseBuffer();
        this.unsetDataHandler();
    }

    @Override
    public int getBufferIndex() {
        return this.get_offset();
    }

    @Override
    public int getBufferStart() {
        return 0;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public void walk_string() {
        this.skip(this.read_ulong());
    }

    @Override
    public void skip(int n) {
        for (int i = BufferHandlerHelper.skip(this.dataHandler, n); i < n; i += BufferHandlerHelper.skip(this.dataHandler, n)) {
            this.encoderStream.getNextBuffer();
        }
        this.data = this.dataHandler.getBuffer();
    }

    @Override
    public byte fast_read_byte() {
        return this.data.get();
    }

    @Override
    public void setEndian(boolean bl) {
        ByteOrder byteOrder = bl ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.dataHandler.setByteOrder(byteOrder);
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public WsByteBuffer getData() {
        return this.data;
    }

    protected void traceData(String string, String string2, String string3) {
        String string4 = HexFormatter.format(this.dataHandler.getBuffers(), this.data);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, string + "\n" + string4, string2, string3);
        }
    }

    @Override
    protected int getCurrentRemaining() {
        if (this.data != null) {
            return this.data.remaining();
        }
        return -1;
    }

    public static class CDRBufferMarker
    extends BufferMarker {
        private final long blockLength;

        public CDRBufferMarker(long l) {
            this.blockLength = l;
        }

        public long getBlockLength() {
            return this.blockLength;
        }
    }
}

