/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;

final class XPathFactoryFinder {
    private static boolean debug;
    private static Properties jaxpProperties;
    private static long lastModified;

    private XPathFactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2, String string3) throws ConfigurationError {
        Object object;
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (classLoader == null) {
            classLoader = XPathFactoryFinder.class.getClassLoader();
        }
        String string4 = string + ":" + string2;
        if (debug) {
            XPathFactoryFinder.dPrint("find factoryId=" + string4);
        }
        try {
            String string5 = SecuritySupport.getSystemProperty(string4);
            if (string5 != null) {
                if (debug) {
                    XPathFactoryFinder.dPrint("found system property, value=" + string5);
                }
                return XPathFactoryFinder.newInstance(string5, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        boolean bl = false;
        File file = null;
        try {
            object = SecuritySupport.getSystemProperty("java.home");
            String string6 = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
            file = new File(string6);
            bl = SecuritySupport.getFileExists(file);
        }
        catch (SecurityException securityException) {
            lastModified = -1L;
            jaxpProperties = null;
        }
        object = XPathFactoryFinder.class;
        synchronized (XPathFactoryFinder.class) {
            boolean bl2 = false;
            FileInputStream fileInputStream = null;
            try {
                if (lastModified >= 0L) {
                    if (bl && lastModified < (lastModified = SecuritySupport.getLastModified(file))) {
                        bl2 = true;
                    } else if (!bl) {
                        lastModified = -1L;
                        jaxpProperties = null;
                    }
                } else if (bl) {
                    bl2 = true;
                    lastModified = SecuritySupport.getLastModified(file);
                }
                if (bl2) {
                    jaxpProperties = new Properties();
                    fileInputStream = SecuritySupport.getFileInputStream(file);
                    jaxpProperties.load(fileInputStream);
                }
            }
            catch (Exception exception) {
                lastModified = -1L;
                jaxpProperties = null;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            // ** MonitorExit[var7_9] (shouldn't be in output)
            if (jaxpProperties != null && (object = jaxpProperties.getProperty(string4)) != null) {
                if (debug) {
                    XPathFactoryFinder.dPrint("found in jaxp.properties, value=" + (String)object);
                }
                return XPathFactoryFinder.newInstance((String)object, classLoader, true);
            }
            object = XPathFactoryFinder.findServiceProvider(string2);
            if (object != null) {
                if (debug) {
                    XPathFactoryFinder.dPrint("found service provider by ServiceLoader, value=" + object.getClass().getName());
                }
                return object;
            }
            if (string3 != null && string2.equals("http://java.sun.com/jaxp/xpath/dom")) {
                if (debug) {
                    XPathFactoryFinder.dPrint("using fallback, value=" + string3);
                }
                return XPathFactoryFinder.newInstance(string3, classLoader, true);
            }
            throw new ConfigurationError("Provider for " + string4 + " cannot be found", null);
        }
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            Object object;
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                object = string.substring(0, n);
                securityManager.checkPackageAccess((String)object);
            }
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        classLoader = XPathFactoryFinder.class.getClassLoader();
                        clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    }
                    throw classNotFoundException;
                }
            }
            object = clazz.newInstance();
            if (debug) {
                XPathFactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static Object findServiceProvider(String string) throws ConfigurationError {
        Class<XPathFactory> clazz = XPathFactory.class;
        ServiceLoader<XPathFactory> serviceLoader = ServiceLoader.load(clazz, SecuritySupport.getContextClassLoader());
        Iterator<XPathFactory> iterator = serviceLoader.iterator();
        try {
            while (iterator.hasNext()) {
                XPathFactory xPathFactory = iterator.next();
                if (!xPathFactory.isObjectModelSupported(string)) continue;
                return xPathFactory;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationError("Provider " + clazz.getName() + " could not be instantiated: " + runtimeException, runtimeException);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new ConfigurationError("Provider " + clazz.getName() + " could not be instantiated: " + serviceConfigurationError, null);
        }
        return null;
    }

    static {
        jaxpProperties = null;
        lastModified = -1L;
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

