/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Program;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.StreamInstruction;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;

public class Optimizer {
    protected Function m_currentFunction = null;
    protected boolean m_skipStringStreams = true;
    protected static final Logger s_logger = Logger.getInstance(Optimizer.class);

    protected Instruction optimizeStep(Instruction instruction) {
        return instruction;
    }

    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        return this.optimizeStep(instruction);
    }

    public Instruction optimize(Instruction instruction) {
        Instruction instruction2 = this.optimizeStep(instruction, null, -1);
        if (instruction2 == null) {
            return instruction;
        }
        if (instruction2 != instruction) {
            return instruction2;
        }
        this.optimizeChildren(instruction);
        return instruction;
    }

    public void optimizeFunction(Function function) {
        Function function2 = this.m_currentFunction;
        this.m_currentFunction = function;
        try {
            function.m_body = this.optimize(function.getBody());
        }
        catch (StackOverflowError stackOverflowError) {
            try {
                s_logger.error("Stack Overflow caught optimizing " + function.getName());
                s_logger.error(" dumping stacktrace to stacktrace.txt");
                stackOverflowError.printStackTrace(new PrintStream(new FileOutputStream("stacktrace.txt")));
                s_logger.error(" dumping functionto stackoverflow.xylem");
                Program.dumpXylemFunctions(new Function[]{function}, null, "stackoverflow");
                throw new Error();
            }
            catch (IOException iOException) {
                s_logger.error("died trying to write", iOException);
                throw new Error();
            }
        }
        catch (Exception exception) {
            s_logger.error(exception.getClass().getName() + " encountered in " + this.getClass().getName() + " in function " + function.getName(), exception);
            throw new RuntimeException(exception.getMessage());
        }
        this.m_currentFunction = function2;
    }

    protected void optimizeChildren(Instruction instruction) {
        int n;
        if (this.m_skipStringStreams && instruction instanceof StreamInstruction && ((StreamInstruction)instruction).isString()) {
            return;
        }
        ArrayList<OptimizationStep> arrayList = new ArrayList<OptimizationStep>();
        int n2 = instruction.getChildInstructionCount();
        arrayList.ensureCapacity(n2);
        for (n = n2 - 1; n >= 0; --n) {
            arrayList.add(new OptimizationStep(instruction, instruction.getChildInstruction(n), n));
        }
        while (!arrayList.isEmpty()) {
            int n3;
            n = arrayList.size() - 1;
            OptimizationStep optimizationStep = (OptimizationStep)arrayList.remove(n);
            Instruction instruction2 = optimizationStep.getParent();
            Instruction instruction3 = optimizationStep.getCurrent();
            Instruction instruction4 = this.optimizeStep(instruction3, instruction2, n3 = optimizationStep.getPosition());
            if (instruction4 == null) continue;
            if (instruction4 != instruction3) {
                instruction2.setChildInstruction(n3, instruction4);
                instruction3.m_bindingEnvironment = null;
                continue;
            }
            if (this.m_skipStringStreams && instruction3 instanceof StreamInstruction && ((StreamInstruction)instruction3).isString()) continue;
            int n4 = instruction3.getChildInstructionCount();
            arrayList.ensureCapacity(n + n4);
            for (int i = n4 - 1; i >= 0; --i) {
                arrayList.add(new OptimizationStep(instruction3, instruction3.getChildInstruction(i), i));
            }
        }
    }

    protected Instruction doTypeCheck(Instruction instruction, Instruction instruction2, BindingEnvironment bindingEnvironment) {
        try {
            LinkedList<Function> linkedList = new LinkedList<Function>();
            linkedList.add(this.m_currentFunction);
            instruction2.typeCheck(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, linkedList);
        }
        catch (TypeCheckException typeCheckException) {
            throw new RuntimeException();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        return instruction2;
    }

    public Type resolveType(Instruction instruction) {
        TypeEnvironment typeEnvironment = this.m_currentFunction.getTypeEnvironment();
        BindingEnvironment bindingEnvironment = instruction.getBindingEnvironment();
        if (bindingEnvironment == null) {
            return instruction.getType(typeEnvironment, this.m_currentFunction.getBindingEnvironment()).resolveType(typeEnvironment);
        }
        return instruction.getCachedType().resolveType(typeEnvironment);
    }

    public Module getCurrentModule() {
        return this.m_currentFunction.getTypeEnvironment().getModule();
    }

    public Function getCurrentFunction() {
        return this.m_currentFunction;
    }

    static class OptimizationStep {
        private Instruction m_parent;
        private Instruction m_current;
        private int m_position;

        public OptimizationStep(Instruction instruction, Instruction instruction2, int n) {
            this.m_parent = instruction;
            this.m_current = instruction2;
            this.m_position = n;
        }

        public Instruction getParent() {
            return this.m_parent;
        }

        public Instruction getCurrent() {
            return this.m_current;
        }

        public int getPosition() {
            return this.m_position;
        }
    }
}

