/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.utils;

import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xslt.jaxp.DefaultErrorListener;
import java.lang.ref.SoftReference;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderManager {
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static SAXParserFactory m_parserFactory;
    private static SAXParserFactory m_secureParserFactory;
    private ErrorListener m_errorL = new DefaultErrorListener();
    private ThreadLocal m_reader;
    private ThreadLocal m_secureReader;

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance() {
        return m_singletonManager;
    }

    public synchronized XMLReader getXMLReader(boolean bl, String string) throws SAXException {
        boolean bl2;
        XMLReader xMLReader = this.acquireThisThreadsReader(bl);
        boolean bl3 = bl2 = xMLReader != null;
        if (!bl2) {
            try {
                SAXParser sAXParser = this.getParserFactory(bl).newSAXParser();
                if (string != null) {
                    try {
                        sAXParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", string);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        this.reportUnrecognizedProperty(string, sAXParser, sAXNotRecognizedException);
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        this.reportUnrecognizedProperty(string, sAXParser, sAXNotSupportedException);
                    }
                }
                xMLReader = sAXParser.getXMLReader();
                try {
                    xMLReader.setFeature(NAMESPACES_FEATURE, true);
                    xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                }
                catch (SAXException sAXException) {}
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (this.getThisThreadsReader(bl) == null) {
                this.setThisThreadsReader(xMLReader, bl);
            }
        }
        return xMLReader;
    }

    private void reportUnrecognizedProperty(String string, SAXParser sAXParser, Exception exception) throws SAXException {
        if (!string.equals("all")) {
            try {
                this.warning(new TransformerConfigurationException(XMLMessages.createXMLMessage("ERR_PARSER_PROPERTY_NOT_SUPPORTED", new Object[]{sAXParser.getClass(), "http://javax.xml.XMLConstants/property/accessExternalDTD", string}), exception));
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
        }
    }

    public synchronized void releaseXMLReader(XMLReader xMLReader) {
        if (xMLReader == null) {
            return;
        }
        if (this.getThisThreadsReader(false) == xMLReader) {
            ((ReservableSoftReference)this.m_reader.get()).release();
        } else if (this.getThisThreadsReader(true) == xMLReader) {
            ((ReservableSoftReference)this.m_secureReader.get()).release();
        }
    }

    private XMLReader acquireThisThreadsReader(boolean bl) {
        XMLReader xMLReader = null;
        ThreadLocal threadLocal = this.getReader(bl);
        if (threadLocal == null) {
            return null;
        }
        ReservableSoftReference reservableSoftReference = (ReservableSoftReference)threadLocal.get();
        if (reservableSoftReference != null && reservableSoftReference.isAvailable()) {
            xMLReader = (XMLReader)reservableSoftReference.get();
            if (xMLReader == null) {
                return xMLReader;
            }
            reservableSoftReference.reserve();
        }
        return xMLReader;
    }

    private XMLReader getThisThreadsReader(boolean bl) {
        XMLReader xMLReader = null;
        ThreadLocal threadLocal = this.getReader(bl);
        if (threadLocal == null) {
            return null;
        }
        ReservableSoftReference reservableSoftReference = (ReservableSoftReference)threadLocal.get();
        if (reservableSoftReference != null) {
            xMLReader = (XMLReader)reservableSoftReference.get();
        }
        return xMLReader;
    }

    private void setThisThreadsReader(XMLReader xMLReader, boolean bl) {
        if (xMLReader != null) {
            ReservableSoftReference reservableSoftReference = new ReservableSoftReference(xMLReader);
            if (bl) {
                this.m_secureReader.set(reservableSoftReference);
            } else {
                this.m_reader.set(reservableSoftReference);
            }
        }
    }

    private ThreadLocal getReader(boolean bl) {
        if (bl) {
            if (this.m_secureReader == null) {
                this.m_secureReader = new ThreadLocal();
                return null;
            }
            return this.m_secureReader;
        }
        if (this.m_reader == null) {
            this.m_reader = new ThreadLocal();
            return null;
        }
        return this.m_reader;
    }

    private SAXParserFactory getParserFactory(boolean bl) throws SAXException, ParserConfigurationException {
        if (bl) {
            if (m_secureParserFactory == null) {
                m_secureParserFactory = SAXParserFactory.newInstance();
                m_secureParserFactory.setNamespaceAware(true);
                try {
                    m_secureParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.reportUnrecognizedSecureProcessingProperty(true, m_secureParserFactory, sAXNotRecognizedException);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.reportUnrecognizedSecureProcessingProperty(true, m_secureParserFactory, sAXNotSupportedException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.reportUnrecognizedSecureProcessingProperty(true, m_secureParserFactory, parserConfigurationException);
                }
            }
            return m_secureParserFactory;
        }
        if (m_parserFactory == null) {
            m_parserFactory = SAXParserFactory.newInstance();
            m_parserFactory.setNamespaceAware(true);
            try {
                m_parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        return m_parserFactory;
    }

    private void reportUnrecognizedSecureProcessingProperty(boolean bl, SAXParserFactory sAXParserFactory, Exception exception) throws SAXException {
        if (bl) {
            try {
                this.warning(new TransformerConfigurationException(XMLMessages.createXMLMessage("ERR_PARSER_PROPERTY_NOT_SUPPORTED", new Object[]{sAXParserFactory.getClass(), "http://javax.xml.XMLConstants/feature/secure-processing", bl}), exception));
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
        }
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        this.m_errorL.warning(transformerException);
    }

    public void error(TransformerException transformerException) throws TransformerException {
        this.m_errorL.error(transformerException);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.m_errorL.fatalError(transformerException);
        throw transformerException;
    }

    private static class ReservableSoftReference
    extends SoftReference {
        private boolean m_inUse = true;

        public ReservableSoftReference(Object object) {
            super(object);
        }

        public boolean isAvailable() {
            return !this.m_inUse;
        }

        public void reserve() {
            this.m_inUse = true;
        }

        public void release() {
            this.m_inUse = false;
        }
    }
}

