/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import com.ibm.crypto.provider.IBMJCE;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.ws.collective.security.internal.provider.CollectiveProvider;
import com.ibm.ws.collective.utility.ICertificateUtility;
import com.ibm.ws.collective.utility.utils.CommandUtils;
import com.ibm.ws.collective.utility.utils.Trlog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

public class CertificateUtility
implements ICertificateUtility {
    static final String SLASH = String.valueOf(File.separatorChar);
    String className = CertificateUtility.class.getName();
    private static final String JKS_STORE_TYPE = "jks";
    private static final String P12_STORE_TYPE = "PKCS12";
    private final PrintStream stdout;
    private final PrintStream stderr;
    private String provider = "IBMJCE";

    public CertificateUtility(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
        if (CollectiveProvider.checkCollectiveProviderHasBaseProvider()) {
            try {
                Security.addProvider((Provider)new CollectiveProvider());
                this.provider = "CollectiveProvider";
            }
            catch (CollectiveProvider.CollectiveProviderException e) {
                Trlog.debug(this.className, "CertificateUtility", this.getMessage("create.collectiveProvider.NotAvailable", new Object[0]), e);
                throw e;
            }
        } else {
            Security.addProvider((Provider)new IBMJCE());
        }
    }

    private String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    @Override
    public KeyStore createKeystore(File ksFile, char[] ksPassword) {
        String methodName = "createKeyStore";
        Trlog.enter(this.className, methodName, "ksFile = " + ksFile);
        KeyStore ks = null;
        try {
            FileInputStream inp = null;
            Object kstore = null;
            try {
                ks = ksFile.getCanonicalPath().toLowerCase().endsWith(".jks") ? KeyStore.getInstance(JKS_STORE_TYPE) : KeyStore.getInstance(P12_STORE_TYPE);
                try {
                    inp = new FileInputStream(ksFile.getCanonicalPath());
                    ks.load(inp, ksPassword);
                    inp.close();
                }
                catch (FileNotFoundException e) {
                    ks.load(null, ksPassword);
                    FileOutputStream file = new FileOutputStream(ksFile.getCanonicalPath());
                    ks.store(file, ksPassword);
                    file.close();
                }
            }
            catch (GeneralSecurityException e) {
                throw new GeneralSecurityException(e);
            }
            catch (IOException ioe) {
                throw new IOException(ioe);
            }
            Trlog.debug(this.className, methodName, "keystore is created successfully");
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace(this.stderr);
        }
        catch (IOException e) {
            e.printStackTrace(this.stderr);
        }
        Trlog.exit(this.className, methodName);
        return ks;
    }

    @Override
    public PkSsCertificate createSelfSignedCACert(String subjectDN, List<String> subjectAltNames, int validity) {
        int keySize = 2048;
        Date notBefore = null;
        boolean useShortSubjectKId = false;
        List kUsage = null;
        List extKUsage = null;
        KeyPair keyPair = null;
        boolean CA = true;
        String keyType = "RSA";
        String sigAlg = "SHA256withRSA";
        try {
            return PkSsCertFactory.newSsCert((int)keySize, (String)keyType, (String)sigAlg, (String)subjectDN, (int)validity, notBefore, (boolean)useShortSubjectKId, subjectAltNames, kUsage, extKUsage, (String)this.provider, keyPair, (boolean)CA);
        }
        catch (PkRejectionException e) {
            e.printStackTrace(this.stderr);
            return null;
        }
    }

    @Override
    public PkNewCertificate createSignedCert(String subjectDN, List<String> subjectAltNames, int validity, PkSsCertificate signingCert) {
        int keySize = 2048;
        Date notBefore = null;
        boolean useShortSubjectKId = false;
        List kUsage = null;
        List extKUsage = null;
        X509Certificate[] signing_cert_chain = new X509Certificate[]{signingCert.getCertificate()};
        PrivateKey signing_cert_private_key = signingCert.getKey();
        try {
            return PkNewCertFactory.newCert((int)keySize, (String)subjectDN, (int)validity, notBefore, (boolean)useShortSubjectKId, subjectAltNames, kUsage, extKUsage, (String)this.provider, (X509Certificate[])signing_cert_chain, (PrivateKey)signing_cert_private_key);
        }
        catch (PkRejectionException e) {
            e.printStackTrace(this.stderr);
            return null;
        }
    }

    @Override
    public boolean setToKeyStore(PkSsCertificate ssCert, KeyStore ks, String keyPassword, String alias) {
        String methodName = "setToKeyStore";
        Trlog.enter(this.className, methodName, "PkSsCertificate: alias = " + alias);
        try {
            ssCert.setToKeyStore(alias, keyPassword, ks);
            Trlog.exit(this.className, methodName, "returns true");
            return true;
        }
        catch (PkException e) {
            e.printStackTrace(this.stderr);
            Trlog.exit(this.className, methodName, "returns false");
            return false;
        }
    }

    @Override
    public boolean setToKeyStore(PkNewCertificate ssCert, KeyStore ks, String keyPassword, String alias) {
        String methodName = "setToKeyStore";
        Trlog.enter(this.className, methodName, "PkNewCertificate: alias = " + alias);
        try {
            ssCert.setToKeyStore(alias, keyPassword, ks);
            Trlog.exit(this.className, methodName, "returns true");
            return true;
        }
        catch (PkException e) {
            e.printStackTrace(this.stderr);
            Trlog.exit(this.className, methodName, "returns false");
            return false;
        }
    }

    @Override
    public boolean setCertToKeyStore(X509Certificate cert, KeyStore ks, String alias) {
        String methodName = "setCertToKeyStore";
        Trlog.enter(this.className, methodName, "alias = " + alias);
        try {
            ks.setCertificateEntry(alias, cert);
            Trlog.exit(this.className, methodName, "returns true");
            return true;
        }
        catch (KeyStoreException e) {
            e.printStackTrace(this.stderr);
            Trlog.exit(this.className, methodName, "returns false");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveKeyStore(KeyStore ks, File ksFile, String ksPassword) {
        String methodName = "saveKeyStore";
        Trlog.enter(this.className, methodName, "KS File = " + ksFile);
        FileOutputStream os = null;
        String ksFilePath = ksFile.getAbsolutePath();
        try {
            os = new FileOutputStream(ksFile);
            ks.store(os, ksPassword.toCharArray());
            os.flush();
            Trlog.exit(this.className, methodName, "Successfully save the KS file " + ksFilePath);
            boolean bl = true;
            return bl;
        }
        catch (KeyStoreException e) {
            e.printStackTrace(this.stderr);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(this.stderr);
        }
        catch (CertificateException e) {
            e.printStackTrace(this.stderr);
        }
        catch (IOException e) {
            e.printStackTrace(this.stderr);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace(this.stderr);
                }
            }
        }
        Trlog.exit(this.className, methodName, "Failed to save the KS file " + ksFilePath);
        this.stdout.println(this.getMessage("create.failedKSSave", ksFilePath));
        return false;
    }
}

