/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedAbstractHelper;
import com.ibm.oti.shared.SharedDataHelper;
import com.ibm.oti.util.Msg;
import java.nio.ByteBuffer;

final class SharedDataHelperImpl
extends SharedAbstractHelper
implements SharedDataHelper {
    SharedDataHelperImpl(ClassLoader loader, int id, boolean canFind, boolean canStore) {
        this.initialize(loader, id, canFind, canStore);
    }

    private native ByteBuffer findSharedDataImpl(int var1, String var2);

    private native ByteBuffer storeSharedDataImpl(ClassLoader var1, int var2, String var3, ByteBuffer var4);

    @Override
    public ByteBuffer findSharedData(String token) {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (!SharedDataHelperImpl.checkReadPermission(loader)) {
            this.printVerboseError(Msg.getString("K05b5"));
            return null;
        }
        if (token == null) {
            this.printVerboseError(Msg.getString("K05b6"));
            return null;
        }
        return this.findSharedDataImpl(this.id, token);
    }

    @Override
    public ByteBuffer storeSharedData(String token, ByteBuffer data) {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canStore) {
            return null;
        }
        if (!SharedDataHelperImpl.checkWritePermission(loader)) {
            this.printVerboseError(Msg.getString("K05b7"));
            return null;
        }
        if (token == null) {
            this.printVerboseError(Msg.getString("K05b8"));
            return null;
        }
        if (data != null && !data.isDirect()) {
            this.printVerboseError(Msg.getString("K05b9"));
            return null;
        }
        return this.storeSharedDataImpl(loader, this.id, token, data);
    }

    @Override
    String getHelperType() {
        return "SharedDataHelper";
    }
}

