/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.ContentInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public final class SMIMEMessage
implements Cloneable {
    private byte[] header;
    private Hashtable htable;
    private byte[] body;
    private byte[] message;
    private byte[] contentInfoBytes;
    private byte[] certRequestBytes;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.SMIMEMessage";
    private static String crlf = "\r\n";
    private static byte[] crlfbytes = null;
    private static String BASE64 = "base64";

    public SMIMEMessage(byte[] message) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMessage", (Object)message);
        }
        this.parse(message);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(byte[] message, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMessage", message, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.parse(message);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMessage", in);
        }
        byte[] bytes = new byte[in.available()];
        in.read(bytes);
        in.close();
        this.parse(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(InputStream in, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMessage", in, provider);
        }
        byte[] bytes = new byte[in.available()];
        if (provider != null) {
            this.provider = new String(provider);
        }
        in.read(bytes);
        in.close();
        this.parse(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMessage", filename);
        }
        FileInputStream fis = new FileInputStream(filename);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        this.parse(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public SMIMEMessage(String filename, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMessage", filename, provider);
        }
        FileInputStream fis = new FileInputStream(filename);
        byte[] bytes = new byte[fis.available()];
        if (provider != null) {
            this.provider = new String(provider);
        }
        fis.read(bytes);
        fis.close();
        this.parse(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMessage");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            SMIMEMessage smime = new SMIMEMessage(this.getBytes(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", smime);
            }
            return smime;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void setHeader(String header) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setHeader", header);
        }
        try {
            this.setHeader(header.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(8192L, className, "setHeader", e);
            }
            this.setHeader(header.getBytes());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setHeader");
        }
    }

    private void setHeader(byte[] header) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setHeader", (Object)header);
        }
        this.parseHeader(header);
        if (debug != null) {
            debug.exit(8192L, className, "setHeader");
        }
    }

    private void setBody(String body) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setBody", body);
        }
        try {
            this.setBody(body.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(8192L, className, "setBody", e);
            }
            this.setBody(body.getBytes());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setBody");
        }
    }

    private void setBody(byte[] body) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setBody", (Object)body);
        }
        this.parseBody(body);
        if (debug != null) {
            debug.exit(8192L, className, "setBody");
        }
    }

    private void setMessage(String message) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setMessage", message);
        }
        if (message == null) {
            if (debug != null) {
                debug.text(8192L, className, "setMessage", "message not specified.");
            }
            throw new IOException("message not specified.");
        }
        try {
            this.parse(message.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(8192L, className, "setMessage", e);
            }
            this.parse(message.getBytes());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setMessage");
        }
    }

    private void setMessage(byte[] message) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setMessage", (Object)message);
        }
        if (message == null) {
            if (debug != null) {
                debug.text(8192L, className, "setMessage", "message not specified.");
            }
            throw new IOException("message not specified.");
        }
        this.parse(message);
        if (debug != null) {
            debug.exit(8192L, className, "setMessage");
        }
    }

    public byte[] getBytes() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getBytes");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.header);
        bos.write(this.body);
        byte[] retBytes = bos.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getBytes", retBytes);
        }
        return retBytes;
    }

    public byte[] getHeader() {
        if (debug != null) {
            debug.entry(16384L, className, "getHeader");
        }
        if (this.header == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getHeader_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getHeader_2", (byte[])this.header.clone());
        }
        return (byte[])this.header.clone();
    }

    public Hashtable getHeaderHashTable() {
        if (debug != null) {
            debug.entry(16384L, className, "getHeaderHashTable");
            debug.exit(16384L, (Object)className, "getHeaderHashTable", this.htable);
        }
        return this.htable;
    }

    public byte[] getBody() {
        if (debug != null) {
            debug.entry(16384L, className, "getBody");
        }
        if (this.body == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getBody_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getBody_2", this.body.clone());
        }
        return (byte[])this.body.clone();
    }

    private void parse(byte[] message) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", (Object)message);
        }
        if (message == null) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "message not specified.");
            }
            throw new IOException("message not specified.");
        }
        this.parseHeader(message);
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }

    private void parseHeader(byte[] header) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseHeader", (Object)header);
        }
        if (header == null) {
            this.header = null;
            if (debug != null) {
                debug.exit(8192L, className, "parseHeader_1");
            }
            return;
        }
        this.htable = new Hashtable();
        String pszheader = null;
        try {
            pszheader = new String(header, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(8192L, className, "parseHeader", e);
            }
            pszheader = new String(header);
        }
        StringReader sreader = new StringReader(pszheader);
        BufferedReader breader = new BufferedReader(sreader);
        String inline = null;
        boolean bbody = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String previousname = null;
        while ((inline = breader.readLine()) != null) {
            if (inline.equals("")) {
                bbody = true;
                break;
            }
            try {
                bos.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseHeader", e);
                }
                bos.write(inline.getBytes());
            }
            bos.write(crlfbytes);
            if (inline.charAt(0) == '\t') {
                if (previousname != null) {
                    String value = (String)this.htable.get(previousname);
                    value = value + crlf + inline;
                    this.htable.put(previousname, value);
                    continue;
                }
                if (debug != null) {
                    debug.text(8192L, className, "parseHeader", "Header line extends an invalid S/MIME tag.");
                }
                throw new IOException("Header line extends an invalid S/MIME tag.");
            }
            int index = inline.indexOf(":");
            if (index <= -1) continue;
            String name = inline.substring(0, index);
            String value = inline.substring(index + 1, inline.length());
            this.htable.put(name, value);
            previousname = name;
        }
        this.header = bos.toByteArray();
        if (bbody) {
            bos = new ByteArrayOutputStream();
            while ((inline = breader.readLine()) != null) {
                try {
                    bos.write(inline.getBytes("8859_1"));
                }
                catch (UnsupportedEncodingException e) {
                    if (debug != null) {
                        debug.exception(8192L, className, "parseHeader", e);
                    }
                    bos.write(inline.getBytes());
                }
                bos.write(crlfbytes);
            }
            byte[] bytes = bos.toByteArray();
            this.parseBody(bytes);
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseHeader_2");
        }
    }

    private void parseBody(byte[] body) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseBody", (Object)body);
        }
        this.body = body;
        this.parseMessage(body);
        if (debug != null) {
            debug.exit(8192L, className, "parseBody");
        }
    }

    private void setBodyBytes(byte[] bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setBodyBytes", (Object)bytes);
        }
        String ctencoding = this.getContentTransferEncoding();
        this.setBodyBytes(bytes, ctencoding);
    }

    private void setBodyBytes(byte[] bytes, String ctencoding) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "setBodyBytes", bytes, ctencoding);
        }
        this.contentInfoBytes = null;
        this.certRequestBytes = null;
        if (bytes == null || bytes.length == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "setBodyBytes_1");
            }
            return;
        }
        if (ctencoding == null || !ctencoding.equalsIgnoreCase(BASE64)) {
            if (debug != null) {
                debug.exit(8192L, className, "setBodyBytes_2");
            }
            return;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] encoding = null;
        try {
            encoding = decoder.decodeBuffer(new String(bytes, "8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(8192L, className, "setBodyBytes", e);
            }
            encoding = decoder.decodeBuffer(new String(bytes));
        }
        try {
            ContentInfo ci = new ContentInfo(encoding, this.provider);
            this.contentInfoBytes = bytes;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "setBodyBytes", e);
            }
            try {
                CertificationRequest cr = new CertificationRequest(encoding, this.provider);
                this.certRequestBytes = bytes;
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setBodyBytes", e2);
                }
                throw new IOException("Body byte array is not a ContentInfo or CertificationRequest object.");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "setBodyBytes_3");
        }
    }

    private void parseMessage(byte[] body) throws IOException {
        byte[] tmpbyte;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseMessage", (Object)body);
        }
        this.message = null;
        this.contentInfoBytes = null;
        this.certRequestBytes = null;
        if (body == null) {
            if (debug != null) {
                debug.exit(8192L, className, "parseMessage_1");
            }
            return;
        }
        String pszbody = null;
        try {
            pszbody = new String(body, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(8192L, className, "parseMessage", e);
            }
            pszbody = new String(body);
        }
        StringReader sreader = new StringReader(pszbody);
        BufferedReader breader = new BufferedReader(sreader);
        String boundary = this.getBoundary();
        if (boundary == null) {
            this.parseBodyBytes(breader, boundary);
            if (debug != null) {
                debug.exit(8192L, className, "parseMessage_2");
            }
            return;
        }
        String beginboundary = "--" + boundary;
        String endboundary = beginboundary + "--";
        String inline = null;
        boolean bfirsttime = true;
        boolean bincontent = false;
        boolean bcontentType = false;
        boolean bcontent = false;
        boolean bnewmessage = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayOutputStream iebos = new ByteArrayOutputStream();
        while ((inline = breader.readLine()) != null) {
            if (inline.equals(beginboundary) && bfirsttime) {
                bfirsttime = false;
                bincontent = true;
                continue;
            }
            if (inline.equals(beginboundary)) {
                bnewmessage = true;
                break;
            }
            if (inline.equals("") && !bincontent) continue;
            if (bincontent) {
                try {
                    bos.write(inline.getBytes("8859_1"));
                }
                catch (UnsupportedEncodingException e) {
                    if (debug != null) {
                        debug.exception(8192L, className, "parseMessage", e);
                    }
                    bos.write(inline.getBytes());
                }
                bos.write(crlfbytes);
                continue;
            }
            if (inline.equals(".")) break;
            try {
                iebos.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseMessage", e);
                }
                iebos.write(inline.getBytes());
            }
            iebos.write(crlfbytes);
        }
        if ((tmpbyte = bos.toByteArray()) == null || tmpbyte.length == 0) {
            this.message = null;
            if (boundary != null && ((tmpbyte = iebos.toByteArray()) != null || tmpbyte.length > 0)) {
                this.setBodyBytes(tmpbyte);
            }
            if (debug != null) {
                debug.exit(8192L, className, "parseMessage_3");
            }
            return;
        }
        byte[] tmpbyte2 = new byte[tmpbyte.length - 2];
        System.arraycopy(tmpbyte, 0, tmpbyte2, 0, tmpbyte2.length);
        this.message = tmpbyte2;
        if (bnewmessage) {
            this.parseBodyBytes(breader, endboundary);
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseMessage_4");
        }
    }

    private void parseBodyBytes(BufferedReader breader, String endboundary) throws IOException {
        String inline = null;
        boolean bfirsttime = true;
        boolean bincontent = false;
        boolean bcontentType = false;
        boolean bcontent = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (debug != null) {
            debug.entry(8192L, className, "parseBodyBytes", breader, endboundary);
        }
        while ((inline = breader.readLine()) != null && !(endboundary != null ? inline.equals(endboundary) : inline.equals("") || inline.equals("."))) {
            try {
                bos.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseBodyBytes", e);
                }
                bos.write(inline.getBytes());
            }
            bos.write(crlfbytes);
        }
        if (endboundary != null) {
            SMIMEMessage newsmime = new SMIMEMessage(bos.toByteArray(), this.provider);
            String ctencoding = newsmime.getContentTransferEncoding();
            this.setBodyBytes(newsmime.getContentInfoBytes(), ctencoding);
        } else {
            this.setBodyBytes(bos.toByteArray());
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseBodyBytes");
        }
    }

    private String getBoundary() {
        String contentType;
        String boundaryequals = "boundary=";
        String boundary = null;
        if (debug != null) {
            debug.entry(8192L, className, "getBoundary");
        }
        if ((contentType = (String)this.htable.get("Content-Type")) == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getBoundary_1", boundary);
            }
            return boundary;
        }
        int index = contentType.indexOf(boundaryequals);
        if (index > -1) {
            boundary = "";
            String value = contentType.substring(index + boundaryequals.length(), contentType.length());
            int valuelen = value.length();
            boolean bdone = false;
            for (int i = 0; i < valuelen; ++i) {
                char ch = value.charAt(i);
                if (ch == '\"') {
                    for (int j = 1; j < valuelen; ++j) {
                        char ch2 = value.charAt(j);
                        if (ch2 == '\"' || ch2 == ';') {
                            bdone = true;
                            break;
                        }
                        boundary = boundary + ch2;
                    }
                    bdone = true;
                }
                if (bdone || ch == ' ' || ch == ';') break;
                boundary = boundary + ch;
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getBoundary_2", boundary);
        }
        return boundary;
    }

    private String getContentTransferEncoding() {
        String ctencoding;
        if (debug != null) {
            debug.entry(8192L, className, "getContentTransferEncoding");
        }
        if ((ctencoding = (String)this.htable.get("Content-Transfer-Encoding")) != null) {
            ctencoding = ctencoding.trim();
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContentTransferEncoding", ctencoding);
        }
        return ctencoding;
    }

    public byte[] getMessage() {
        if (debug != null) {
            debug.entry(16384L, className, "getMessage");
        }
        if (this.message == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessage_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMessage_2", (byte[])this.message.clone());
        }
        return (byte[])this.message.clone();
    }

    public byte[] getContentInfoBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfoBytes");
        }
        if (this.contentInfoBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfoBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfoBytes_2", (byte[])this.contentInfoBytes.clone());
        }
        return (byte[])this.contentInfoBytes.clone();
    }

    public ContentInfo getContentInfo() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfoBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] ciencoding = null;
        try {
            ciencoding = decoder.decodeBuffer(new String(this.contentInfoBytes, "8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getContentInfo", e);
            }
            ciencoding = decoder.decodeBuffer(new String(this.contentInfoBytes));
        }
        ContentInfo ci = new ContentInfo(ciencoding, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", ci);
        }
        return ci;
    }

    public byte[] getCertificationRequestBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequestBytes");
        }
        if (this.certRequestBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequestBytes_2", (byte[])this.certRequestBytes.clone());
        }
        return (byte[])this.certRequestBytes.clone();
    }

    public CertificationRequest getCertificationRequest() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
        }
        if (this.certRequestBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequest_1", null);
            }
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] crencoding = null;
        try {
            crencoding = decoder.decodeBuffer(new String(this.certRequestBytes, "8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getCertificationRequest", e);
            }
            crencoding = decoder.decodeBuffer(new String(this.certRequestBytes));
        }
        CertificationRequest cr = new CertificationRequest(crencoding, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequest_2", cr);
        }
        return cr;
    }

    public String toString() {
        String out = "SMIMEMessage:\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.header == null) {
            out = out + "\tNo header information\r\n";
        } else {
            try {
                out = out + new String(this.header, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "toString", e);
                }
                out = out + new String(this.header);
            }
        }
        out = out + "\r\n";
        if (this.body == null) {
            out = out + "\tNo body information\r\n";
        } else {
            try {
                out = out + new String(this.body, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "toString", e);
                }
                out = out + new String(this.body);
            }
        }
        out = out + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    static {
        try {
            crlfbytes = crlf.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            crlfbytes = crlf.getBytes();
        }
    }
}

