/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;

public final class PublicKeyAndChallenge
extends PKCSDerObject {
    private PublicKey spki;
    private String challenge;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PublicKeyAndChallenge";
    private volatile int cachedHashVal = 0;

    public PublicKeyAndChallenge(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PublicKeyAndChallenge", (Object)der);
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKeyAndChallenge(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "PublicKeyAndChallenge", der, provider);
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKeyAndChallenge(PublicKey publicKey, String challenge) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "PublicKeyAndChallenge", publicKey, challenge);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "publicKey not specified");
            }
            throw new IllegalArgumentException("publicKey not specified");
        }
        if (challenge == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "challenge not specified");
            }
            throw new IllegalArgumentException("challenge not specified");
        }
        this.challenge = challenge;
        this.spki = publicKey;
        if (debug != null) {
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKeyAndChallenge(PublicKey publicKey, String challenge, String provider) throws InvalidKeyException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{publicKey, challenge, provider};
            debug.entry(16384L, (Object)className, "PublicKeyAndChallenge", parms);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "publicKey not specified");
            }
            throw new IllegalArgumentException("publicKey not specified");
        }
        if (challenge == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "challenge not specified");
            }
            throw new IllegalArgumentException("challenge not specified");
        }
        this.challenge = challenge;
        this.spki = publicKey;
        if (debug != null) {
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKey getSubjectPublicKeyInfo() throws InvalidKeyException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectPublicKeyInfo");
        }
        if (this.spki == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo_1", null);
            }
            return null;
        }
        DerValue der = new DerValue(this.spki.getEncoded());
        PublicKey retkey = X509Key.parse(der);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo_2", retkey);
        }
        return retkey;
    }

    public String getChallenge() {
        if (debug != null) {
            debug.entry(16384L, className, "getChallenge");
            debug.exit(16384L, (Object)className, "getChallenge", this.challenge);
        }
        return this.challenge;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        bytes.write(this.spki.getEncoded());
        bytes.putIA5String(this.challenge);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, not a SEQUENCE");
            }
            throw new IOException("parsing error, not a SEQUENCE");
        }
        this.spki = null;
        this.challenge = null;
        if (encoding.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing data");
            }
            throw new IOException("parsing error, missing data");
        }
        this.spki = X509Key.parse(encoding.getData().getDerValue());
        if (encoding.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing data");
            }
            throw new IOException("parsing error, missing data");
        }
        this.challenge = encoding.getData().getDerValue().getIA5String();
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, data overrun");
            }
            throw new IOException("parsing error, data overrun");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof PublicKeyAndChallenge)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((PublicKeyAndChallenge)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        String out = "PublicKeyAndChallenge:";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = this.spki != null ? out + "\r\n\tpublicKey: " + this.spki.toString() : out + "\r\n\tpublicKey: null";
        out = this.challenge != null ? out + "\r\n\tchallenge: " + this.challenge : out + "\r\n\tchallenge: null";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public Object clone() {
        try {
            DerOutputStream derout = new DerOutputStream();
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            this.encode(derout);
            PublicKeyAndChallenge retobj = new PublicKeyAndChallenge(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }
}

