/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AffineCurve;
import com.ibm.crypto.fips.provider.ECParameterGenerator;
import com.ibm.crypto.fips.provider.GenericPrimeField;
import com.ibm.crypto.fips.provider.JacobianCurve;
import com.ibm.crypto.fips.provider.P256PrimeField;
import com.ibm.crypto.fips.provider.PrimeCurve;
import com.ibm.crypto.fips.provider.PrimeField;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public final class ECUtils {
    public static final int EC_SIZE_192 = 192;
    public static final int EC_SIZE_224 = 224;
    public static final int EC_SIZE_256 = 256;
    public static final int EC_SIZE_384 = 384;
    public static final int EC_SIZE_521 = 521;
    public static final int EC_CURVE_COFACTOR_1_Y2_X3 = 1;
    public static final int EC_CURVE_KOBLITZ = 2;
    public static final int EC_CURVE_DEFAULT = 0;
    private static final String[] z;

    protected static String a(ECPoint eCPoint) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(eCPoint.getAffineX().toString());
        stringBuffer.append(",");
        stringBuffer.append(eCPoint.getAffineY().toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static String a(EllipticCurve ellipticCurve) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[5]);
        stringBuffer.append(ECUtils.a(ellipticCurve.getField()));
        stringBuffer.append(z[6] + ellipticCurve.getA());
        stringBuffer.append(z[4] + ellipticCurve.getB());
        stringBuffer.append("#");
        return stringBuffer.toString();
    }

    protected static String a(ECField eCField) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(z[1] + eCField.getFieldSize());
        if (eCField instanceof ECFieldFp) {
            ECFieldFp eCFieldFp = (ECFieldFp)eCField;
            stringBuffer.append(z[2] + eCFieldFp.getP());
        } else if (eCField instanceof ECFieldF2m) {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
            stringBuffer.append(z[3] + eCFieldF2m.getM());
            stringBuffer.append(z[0] + eCFieldF2m.getReductionPolynomial());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static PrimeField getField(int n2, BigInteger bigInteger, boolean bl) {
        switch (n2) {
            case 256: {
                if (!bl) break;
                return new P256PrimeField();
            }
        }
        return new GenericPrimeField(bigInteger);
    }

    public static boolean isNistPrime(BigInteger bigInteger) {
        BigInteger bigInteger2 = null;
        switch (bigInteger.bitLength()) {
            case 192: {
                bigInteger2 = ECParameterGenerator.a;
                break;
            }
            case 224: {
                bigInteger2 = ECParameterGenerator.g;
                break;
            }
            case 256: {
                bigInteger2 = ECParameterGenerator.m;
                break;
            }
            case 384: {
                bigInteger2 = ECParameterGenerator.s;
                break;
            }
            case 521: {
                bigInteger2 = ECParameterGenerator.y;
                break;
            }
            default: {
                return false;
            }
        }
        return bigInteger2.compareTo(bigInteger) == 0;
    }

    public static PrimeCurve getCurve(PrimeField primeField, BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        if (n2 == 1) {
            return new JacobianCurve(primeField, bigInteger, bigInteger2);
        }
        return new AffineCurve(primeField, bigInteger, bigInteger2);
    }

    public static PrimeCurve getCurve(PrimeField primeField, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2) {
        if (n2 == 1) {
            return new JacobianCurve(primeField, bigInteger, bigInteger2, byArray);
        }
        return new AffineCurve(primeField, bigInteger, bigInteger2, byArray);
    }

    public static PrimeCurve getPrimeCurve(EllipticCurve ellipticCurve) {
        if (ellipticCurve instanceof PrimeCurve) {
            return (PrimeCurve)ellipticCurve;
        }
        BigInteger bigInteger = ((ECFieldFp)ellipticCurve.getField()).getP();
        int n2 = 0;
        if (ECUtils.isNistPrime(bigInteger)) {
            n2 = 1;
        }
        PrimeField primeField = ECUtils.getField(ellipticCurve.getField().getFieldSize(), bigInteger, ECUtils.isNistPrime(bigInteger));
        return ECUtils.getCurve(primeField, ellipticCurve.getA(), ellipticCurve.getB(), n2);
    }

    public static ECParameterSpec getPrimeParameterSpec(ECParameterSpec eCParameterSpec) {
        if (!(eCParameterSpec.getCurve() instanceof PrimeCurve)) {
            return new ECParameterSpec(ECUtils.getPrimeCurve(eCParameterSpec.getCurve()), eCParameterSpec.getGenerator(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor());
        }
        return eCParameterSpec;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "TcK@\u0015>eGK\u000e}aAH\u00193~CM\u00011+\u000e";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 93;
                                break;
                            }
                            case 1: {
                                n9 = 17;
                                break;
                            }
                            case 2: {
                                n9 = 46;
                                break;
                            }
                            case 3: {
                                n9 = 36;
                                break;
                            }
                            default: {
                                n9 = 96;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "&Tmb\t8}J\u0004i.xTAZ}";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Ta\u0014\u0004";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "T|\u0014\u0004";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "Ts\u0014\u0004";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "~TBH\t-eGG#(cXA@";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "Tp\u0014\u0004";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

